/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.reflection;

import at.unbounded.reflection.MethodAccessor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DefaultMethodAccessor
implements MethodAccessor {
    private final Method method;

    public DefaultMethodAccessor(Method method) {
        this.method = method;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object invoke(Object instance, Object ... arguments) {
        try {
            return this.method.invoke(instance, arguments);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Cannot invoke the method", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot be reflected.", ex);
        }
    }
}

