/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization;

import at.unbounded.serialization.stream.Decoder;
import at.unbounded.serialization.stream.Encoder;
import at.unbounded.serialization.template.Template;
import at.unbounded.serialization.template.TemplateRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class Serialization {
    private final TemplateRegistry registry = new TemplateRegistry();

    public <T> void register(Class<T> clazz) {
        this.registry.register(clazz);
    }

    public <T> void register(Class<T> clazz, Template<T> template) {
        this.registry.register(clazz, template);
    }

    public <T> boolean unregister(Class<T> clazz) {
        return this.registry.unregister(clazz);
    }

    public <T> T decode(byte[] value, Class<?> clazz) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(value);
        Decoder decoder = new Decoder(input);
        return this.registry.lookup(clazz).read(decoder, null);
    }

    public <T> byte[] encode(T value) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Encoder encoder = new Encoder(output);
        if (value == null) {
            encoder.writeNil();
        } else {
            this.registry.lookup(value.getClass()).write(encoder, value);
        }
        return output.toByteArray();
    }
}

