/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.stream;

import at.unbounded.io.Charsets;
import at.unbounded.serialization.SerializationException;
import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.StreamStack;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class Decoder
implements IDecoder {
    private static final byte HEAD_RESET = -63;
    private final StreamStack stack = new StreamStack();
    private final DataInputStream stream;
    private byte head = (byte)-63;

    public Decoder(InputStream stream) {
        this.stream = new DataInputStream(stream);
    }

    public int getHead() throws IOException {
        if (this.head == -63) {
            this.head = this.stream.readByte();
        }
        return this.head & 0xFF;
    }

    public void resetHead() {
        this.head = (byte)-63;
    }

    @Override
    public boolean readNil() throws IOException {
        if (this.stack.getPointer() > 0 && this.stack.getPointingCount() <= 0) {
            return true;
        }
        int head = this.getHead();
        if (head == 192) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return true;
        }
        return false;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.stack.validate();
        int head = this.getHead();
        if (head == 193) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return false;
        }
        if (head == 194) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return true;
        }
        return false;
    }

    @Override
    public byte readByte() throws IOException {
        this.stack.validate();
        int head = this.getHead();
        if ((head & 0x80) == 0) {
            this.stack.decrementPointingCount();
            int fixnum = head;
            this.resetHead();
            return (byte)fixnum;
        }
        if ((head & 0xE0) == 224) {
            this.stack.decrementPointingCount();
            int fixnum = head;
            this.resetHead();
            return (byte)fixnum;
        }
        if (head == 195) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readByte();
        }
        if (head == 196) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readByte();
        }
        return 0;
    }

    @Override
    public short readShort() throws IOException {
        this.stack.validate();
        int head = this.getHead();
        if ((head & 0x80) == 0) {
            this.stack.decrementPointingCount();
            int fixnum = head;
            this.resetHead();
            return (short)fixnum;
        }
        if ((head & 0xE0) == 224) {
            this.stack.decrementPointingCount();
            int fixnum = head;
            this.resetHead();
            return (short)fixnum;
        }
        if (head == 195) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readByte();
        }
        if (head == 196) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readByte();
        }
        if (head == 197) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readShort();
        }
        if (head == 198) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readShort();
        }
        return 0;
    }

    @Override
    public int readInteger() throws IOException {
        this.stack.validate();
        int head = this.getHead();
        if ((head & 0x80) == 0) {
            this.stack.decrementPointingCount();
            int fixnum = head;
            this.resetHead();
            return fixnum;
        }
        if ((head & 0xE0) == 224) {
            this.stack.decrementPointingCount();
            int fixnum = head;
            this.resetHead();
            return fixnum;
        }
        if (head == 195) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readByte();
        }
        if (head == 196) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readByte();
        }
        if (head == 197) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readShort();
        }
        if (head == 198) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readShort();
        }
        if (head == 199) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readInt();
        }
        if (head == 200) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readInt();
        }
        return 0;
    }

    @Override
    public long readLong() throws IOException {
        this.stack.validate();
        int head = this.getHead();
        if ((head & 0x80) == 0) {
            this.stack.decrementPointingCount();
            int fixnum = head;
            this.resetHead();
            return fixnum;
        }
        if ((head & 0xE0) == 224) {
            this.stack.decrementPointingCount();
            int fixnum = head;
            this.resetHead();
            return fixnum;
        }
        if (head == 195) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readByte();
        }
        if (head == 196) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readByte();
        }
        if (head == 197) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readShort();
        }
        if (head == 198) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readShort();
        }
        if (head == 199) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readInt();
        }
        if (head == 200) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readInt();
        }
        if (head == 201) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readLong();
        }
        if (head == 202) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readLong();
        }
        return 0L;
    }

    @Override
    public float readFloat() throws IOException {
        this.stack.validate();
        int head = this.getHead();
        if (head == 203) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readFloat();
        }
        return 0.0f;
    }

    @Override
    public double readDouble() throws IOException {
        this.stack.validate();
        int head = this.getHead();
        if (head == 203) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readFloat();
        }
        if (head == 204) {
            this.stack.decrementPointingCount();
            this.resetHead();
            return this.stream.readDouble();
        }
        return 0.0;
    }

    @Override
    public byte[] readBytes() throws IOException {
        this.stack.validate();
        int head = this.getHead();
        if ((head & 0xE0) == 160) {
            this.stack.decrementPointingCount();
            int count = head & 0x1F;
            if (count == 0) {
                this.resetHead();
                return new byte[0];
            }
            byte[] raw = new byte[count];
            this.stream.read(raw, 0, count);
            this.resetHead();
            return raw;
        }
        if (head == 205) {
            this.stack.decrementPointingCount();
            byte count = this.stream.readByte();
            if (count == 0) {
                this.resetHead();
                return new byte[0];
            }
            byte[] raw = new byte[count];
            this.stream.read(raw, 0, count);
            this.resetHead();
            return raw;
        }
        if (head == 206) {
            this.stack.decrementPointingCount();
            short count = this.stream.readShort();
            if (count == 0) {
                this.resetHead();
                return new byte[0];
            }
            byte[] raw = new byte[count];
            this.stream.read(raw, 0, count);
            this.resetHead();
            return raw;
        }
        if (head == 207) {
            this.stack.decrementPointingCount();
            int count = this.stream.readInt();
            if (count == 0) {
                this.resetHead();
                return new byte[0];
            }
            byte[] raw = new byte[count];
            this.stream.read(raw, 0, count);
            this.resetHead();
            return raw;
        }
        return new byte[0];
    }

    @Override
    public String readString() throws IOException {
        this.stack.validate();
        int head = this.getHead();
        if ((head & 0xE0) == 160) {
            this.stack.decrementPointingCount();
            int count = head & 0x1F;
            if (count == 0) {
                this.resetHead();
                return new String();
            }
            byte[] raw = new byte[count];
            this.stream.read(raw, 0, count);
            this.resetHead();
            return new String(raw, Charsets.UTF_16BE);
        }
        if (head == 205) {
            this.stack.decrementPointingCount();
            byte count = this.stream.readByte();
            if (count == 0) {
                this.resetHead();
                return new String();
            }
            byte[] raw = new byte[count];
            this.stream.read(raw, 0, count);
            this.resetHead();
            return new String(raw, Charsets.UTF_16BE);
        }
        if (head == 206) {
            this.stack.decrementPointingCount();
            short count = this.stream.readShort();
            if (count == 0) {
                this.resetHead();
                return new String();
            }
            byte[] raw = new byte[count];
            this.stream.read(raw, 0, count);
            this.resetHead();
            return new String(raw, Charsets.UTF_16BE);
        }
        if (head == 207) {
            this.stack.decrementPointingCount();
            int count = this.stream.readInt();
            if (count == 0) {
                this.resetHead();
                return new String();
            }
            byte[] raw = new byte[count];
            this.stream.read(raw, 0, count);
            this.resetHead();
            return new String(raw, Charsets.UTF_16BE);
        }
        return new String();
    }

    @Override
    public int readListBegin() throws IOException {
        int head = this.getHead();
        if ((head & 0xF0) == 144) {
            this.resetHead();
            int size = head & 0xF;
            this.stack.decrementPointingCount();
            this.stack.pushList(size);
            return size;
        }
        if (head == 208) {
            this.resetHead();
            short size = this.stream.readShort();
            this.stack.decrementPointingCount();
            this.stack.pushList(size);
            return size;
        }
        if (head == 209) {
            this.resetHead();
            int size = this.stream.readInt();
            this.stack.decrementPointingCount();
            this.stack.pushList(size);
            return size;
        }
        return 0;
    }

    @Override
    public void readListEnd() throws IOException {
        if (!this.stack.isPointingToList()) {
            throw new SerializationException("Stack is not pointing to list");
        }
        int remain = this.stack.getPointingCount();
        if (remain > 0) {
            for (int i = 0; i < remain; ++i) {
                this.readNil();
            }
        }
        this.stack.pop();
    }

    @Override
    public int readMapBegin() throws IOException {
        int head = this.getHead();
        if ((head & 0xF0) == 128) {
            this.resetHead();
            int size = head & 0xF;
            this.stack.decrementPointingCount();
            this.stack.pushMap(size);
            return size;
        }
        if (head == 210) {
            this.resetHead();
            short size = this.stream.readShort();
            this.stack.decrementPointingCount();
            this.stack.pushMap(size);
            return size;
        }
        if (head == 211) {
            this.resetHead();
            int size = this.stream.readInt();
            this.stack.decrementPointingCount();
            this.stack.pushMap(size);
            return size;
        }
        return 0;
    }

    @Override
    public void readMapEnd() throws IOException {
        if (!this.stack.isPointingToMap()) {
            throw new SerializationException("Stack is not pointing to map");
        }
        int remain = this.stack.getPointingCount();
        if (remain > 0) {
            for (int i = 0; i < remain; ++i) {
                this.readNil();
            }
        }
        this.stack.pop();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

