/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.stream;

import at.unbounded.io.Charsets;
import at.unbounded.serialization.SerializationException;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.stream.StreamStack;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class Encoder
implements IEncoder {
    private final StreamStack stack = new StreamStack();
    private final DataOutputStream stream;

    public Encoder(OutputStream stream) {
        this.stream = new DataOutputStream(stream);
    }

    @Override
    public void writeNil() throws IOException {
        this.stream.writeByte(192);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.stream.writeByte(value ? 194 : 193);
        this.stack.decrementPointingCount();
    }

    @Override
    public void writeByte(byte value) throws IOException {
        if (value < -32) {
            this.stream.writeByte(196);
            this.stream.writeByte(value);
        } else if (value < 128) {
            this.stream.writeByte(value);
        } else {
            this.stream.writeByte(195);
            this.stream.writeByte(value);
        }
        this.stack.decrementPointingCount();
    }

    @Override
    public void writeShort(short value) throws IOException {
        if (value < -32) {
            if (value < -128) {
                this.stream.writeByte(198);
                this.stream.writeShort(value);
            } else {
                this.stream.writeByte(196);
                this.stream.writeByte(value);
            }
        } else if (value < 128) {
            this.stream.writeByte(value);
        } else if (value < 256) {
            this.stream.writeByte(195);
            this.stream.writeByte(value);
        } else {
            this.stream.writeByte(197);
            this.stream.writeShort(value);
        }
        this.stack.decrementPointingCount();
    }

    @Override
    public void writeInteger(int value) throws IOException {
        if (value < -32) {
            if (value < Short.MIN_VALUE) {
                this.stream.writeByte(200);
                this.stream.writeInt(value);
            } else if (value < -128) {
                this.stream.writeByte(198);
                this.stream.writeShort(value);
            } else {
                this.stream.writeByte(196);
                this.stream.writeByte(value);
            }
        } else if (value < 128) {
            this.stream.writeByte(value);
        } else if (value < 256) {
            this.stream.writeByte(195);
            this.stream.writeByte(value);
        } else if (value < 65536) {
            this.stream.writeByte(197);
            this.stream.writeShort(value);
        } else {
            this.stream.writeByte(199);
            this.stream.writeInt(value);
        }
        this.stack.decrementPointingCount();
    }

    @Override
    public void writeLong(long value) throws IOException {
        if (value < -32L) {
            if (value < -32768L) {
                if (value < Integer.MIN_VALUE) {
                    this.stream.writeByte(202);
                    this.stream.writeLong(value);
                } else {
                    this.stream.writeByte(200);
                    this.stream.writeInt((int)value);
                }
            } else if (value < -128L) {
                this.stream.writeByte(198);
                this.stream.writeShort((short)value);
            } else {
                this.stream.writeByte(196);
                this.stream.writeByte((byte)value);
            }
        } else if (value < 128L) {
            this.stream.writeByte((int)value);
        } else if (value < 65536L) {
            if (value < 256L) {
                this.stream.writeByte(195);
                this.stream.writeByte((byte)value);
            } else {
                this.stream.writeByte(197);
                this.stream.writeShort((short)value);
            }
        } else if (value < 0x100000000L) {
            this.stream.writeByte(199);
            this.stream.writeInt((int)value);
        } else {
            this.stream.writeByte(201);
            this.stream.writeLong(value);
        }
        this.stack.decrementPointingCount();
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.stream.writeByte(203);
        this.stream.writeFloat(value);
        this.stack.decrementPointingCount();
    }

    @Override
    public void writeDouble(double value) throws IOException {
        if ((double)((float)value) == value) {
            this.stream.writeByte(203);
            this.stream.writeFloat((float)value);
        } else {
            this.stream.writeByte(204);
            this.stream.writeDouble(value);
        }
        this.stack.decrementPointingCount();
    }

    @Override
    public void writeBytes(byte[] value) throws IOException {
        if (value.length < 32) {
            this.stream.writeByte(0xA0 | value.length);
        } else if (value.length < 256) {
            this.stream.writeByte(205);
            this.stream.writeShort(value.length);
        } else if (value.length < 65536) {
            this.stream.writeByte(206);
            this.stream.writeShort(value.length);
        } else {
            this.stream.writeByte(207);
            this.stream.writeInt(value.length);
        }
        this.stream.write(value, 0, value.length);
        this.stack.decrementPointingCount();
    }

    @Override
    public void writeString(String value) throws IOException {
        this.writeBytes(value.getBytes(Charsets.UTF_16BE));
        this.stack.decrementPointingCount();
    }

    @Override
    public void writeListBegin(int size) throws IOException {
        if (size < 16) {
            this.stream.writeByte(0x90 | size);
        } else if (size < 65536) {
            this.stream.writeByte(208);
            this.stream.writeShort(size);
        } else {
            this.stream.writeByte(209);
            this.stream.writeInt(size);
        }
        this.stack.decrementPointingCount();
        this.stack.pushList(size);
    }

    @Override
    public void writeListEnd() throws IOException {
        if (!this.stack.isPointingToList()) {
            throw new SerializationException("Stack is not pointing to list");
        }
        int remain = this.stack.getPointingCount();
        if (remain > 0) {
            for (int i = 0; i < remain; ++i) {
                this.writeNil();
            }
        }
        this.stack.pop();
    }

    @Override
    public void writeMapBegin(int size) throws IOException {
        if (size < 16) {
            this.stream.writeByte(0x80 | size);
        } else if (size < 65536) {
            this.stream.writeByte(210);
            this.stream.writeShort(size);
        } else {
            this.stream.writeByte(211);
            this.stream.writeInt(size);
        }
        this.stack.decrementPointingCount();
        this.stack.pushMap(size);
    }

    @Override
    public void writeMapEnd() throws IOException {
        if (!this.stack.isPointingToMap()) {
            throw new SerializationException("Stack is not pointing to map");
        }
        int remain = this.stack.getPointingCount();
        if (remain > 0) {
            for (int i = 0; i < remain; ++i) {
                this.writeNil();
            }
        }
        this.stack.pop();
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

