/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.stream;

import java.io.EOFException;

public final class StreamStack {
    private static final byte TYPE_LIST = 1;
    private static final byte TYPE_MAP = 2;
    private final byte[] stack = new byte[128];
    private final int[] count = new int[128];
    private int pointer;

    public int getPointer() {
        return this.pointer;
    }

    public void pop() {
        --this.pointer;
    }

    public void pushList(int size) {
        ++this.pointer;
        this.stack[this.pointer] = 1;
        this.count[this.pointer] = size;
    }

    public void pushMap(int size) {
        ++this.pointer;
        this.stack[this.pointer] = 2;
        this.count[this.pointer] = size * 2;
    }

    public boolean isPointingToList() {
        return this.stack[this.pointer] == 1;
    }

    public boolean isPointingToMap() {
        return this.stack[this.pointer] == 2;
    }

    public int getPointingCount() {
        return this.count[this.pointer];
    }

    public void incrementPointingCount() {
        int n = this.pointer;
        this.count[n] = this.count[n] + 1;
    }

    public void decrementPointingCount() {
        int n = this.pointer;
        this.count[n] = this.count[n] - 1;
    }

    public void validate() throws EOFException {
        if (this.count[this.pointer] > 0) {
            return;
        }
        if (this.stack[this.pointer] == 1) {
            throw new EOFException("List is ended without any end");
        }
        if (this.stack[this.pointer] == 1) {
            throw new EOFException("Map is ended without any end");
        }
    }
}

