/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;
import java.math.BigInteger;

public final class BigIntegerTemplate
implements Template<BigInteger> {
    private static final BigIntegerTemplate instance = new BigIntegerTemplate();

    private BigIntegerTemplate() {
    }

    @Override
    public BigInteger read(IDecoder decoder, BigInteger target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        return new BigInteger(decoder.readString());
    }

    @Override
    public void write(IEncoder encoder, BigInteger value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeString(value.toString());
    }

    public static BigIntegerTemplate getInstance() {
        return instance;
    }
}

