/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;

public final class BooleanArrayTemplate
implements Template<boolean[]> {
    private static final BooleanArrayTemplate instance = new BooleanArrayTemplate();

    private BooleanArrayTemplate() {
    }

    @Override
    public boolean[] read(IDecoder decoder, boolean[] target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        int size = decoder.readListBegin();
        if (target == null || target.length != size) {
            target = new boolean[size];
        }
        for (int i = 0; i < size; ++i) {
            target[i] = decoder.readBoolean();
        }
        decoder.readListEnd();
        return target;
    }

    @Override
    public void write(IEncoder encoder, boolean[] value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeListBegin(value.length);
        for (boolean element : value) {
            encoder.writeBoolean(element);
        }
        encoder.writeListEnd();
    }

    public static BooleanArrayTemplate getInstance() {
        return instance;
    }
}

