/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;

public final class ByteArrayTemplate
implements Template<byte[]> {
    private static final ByteArrayTemplate instance = new ByteArrayTemplate();

    private ByteArrayTemplate() {
    }

    @Override
    public byte[] read(IDecoder decoder, byte[] target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        int size = decoder.readListBegin();
        if (target == null || target.length != size) {
            target = new byte[size];
        }
        for (int i = 0; i < size; ++i) {
            target[i] = decoder.readByte();
        }
        decoder.readListEnd();
        return target;
    }

    @Override
    public void write(IEncoder encoder, byte[] value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeListBegin(value.length);
        for (byte element : value) {
            encoder.writeByte(element);
        }
        encoder.writeListEnd();
    }

    public static ByteArrayTemplate getInstance() {
        return instance;
    }
}

