/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class ByteBufferTemplate
implements Template<ByteBuffer> {
    private static final ByteBufferTemplate instance = new ByteBufferTemplate();

    private ByteBufferTemplate() {
    }

    @Override
    public ByteBuffer read(IDecoder decoder, ByteBuffer target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        byte[] buffer = decoder.readBytes();
        if (target == null || target.limit() < buffer.length) {
            target = ByteBuffer.wrap(buffer);
        } else {
            target.put(buffer, 0, buffer.length);
        }
        return target;
    }

    @Override
    public void write(IEncoder encoder, ByteBuffer value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeBytes(value.array());
    }

    public static ByteBufferTemplate getInstance() {
        return instance;
    }
}

