/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;

public final class CharacterArrayTemplate
implements Template<char[]> {
    private static final CharacterArrayTemplate instance = new CharacterArrayTemplate();

    private CharacterArrayTemplate() {
    }

    @Override
    public char[] read(IDecoder decoder, char[] target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        int size = decoder.readListBegin();
        if (target == null || target.length != size) {
            target = new char[size];
        }
        for (int i = 0; i < size; ++i) {
            target[i] = (char)decoder.readShort();
        }
        decoder.readListEnd();
        return target;
    }

    @Override
    public void write(IEncoder encoder, char[] value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeListBegin(value.length);
        for (char element : value) {
            encoder.writeShort((short)element);
        }
        encoder.writeListEnd();
    }

    public static CharacterArrayTemplate getInstance() {
        return instance;
    }
}

