/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;

public final class DoubleArrayTemplate
implements Template<double[]> {
    private static final DoubleArrayTemplate instance = new DoubleArrayTemplate();

    private DoubleArrayTemplate() {
    }

    @Override
    public double[] read(IDecoder decoder, double[] target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        int size = decoder.readListBegin();
        if (target == null || target.length != size) {
            target = new double[size];
        }
        for (int i = 0; i < size; ++i) {
            target[i] = decoder.readDouble();
        }
        decoder.readListEnd();
        return target;
    }

    @Override
    public void write(IEncoder encoder, double[] value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeListBegin(value.length);
        for (double element : value) {
            encoder.writeDouble(element);
        }
        encoder.writeListEnd();
    }

    public static DoubleArrayTemplate getInstance() {
        return instance;
    }
}

