/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;

public final class FloatArrayTemplate
implements Template<float[]> {
    private static final FloatArrayTemplate instance = new FloatArrayTemplate();

    private FloatArrayTemplate() {
    }

    @Override
    public float[] read(IDecoder decoder, float[] target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        int size = decoder.readListBegin();
        if (target == null || target.length != size) {
            target = new float[size];
        }
        for (int i = 0; i < size; ++i) {
            target[i] = decoder.readFloat();
        }
        decoder.readListEnd();
        return target;
    }

    @Override
    public void write(IEncoder encoder, float[] value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeListBegin(value.length);
        for (float element : value) {
            encoder.writeFloat(element);
        }
        encoder.writeListEnd();
    }

    public static FloatArrayTemplate getInstance() {
        return instance;
    }
}

