/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;

public final class FloatTemplate
implements Template<Float> {
    private static final FloatTemplate instance = new FloatTemplate();

    private FloatTemplate() {
    }

    @Override
    public Float read(IDecoder decoder, Float target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        return Float.valueOf(decoder.readFloat());
    }

    @Override
    public void write(IEncoder encoder, Float value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeFloat(value.floatValue());
    }

    public static FloatTemplate getInstance() {
        return instance;
    }
}

