/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;

public final class IntegerArrayTemplate
implements Template<int[]> {
    private static final IntegerArrayTemplate instance = new IntegerArrayTemplate();

    private IntegerArrayTemplate() {
    }

    @Override
    public int[] read(IDecoder decoder, int[] target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        int size = decoder.readListBegin();
        if (target == null || target.length != size) {
            target = new int[size];
        }
        for (int i = 0; i < size; ++i) {
            target[i] = decoder.readInteger();
        }
        decoder.readListEnd();
        return target;
    }

    @Override
    public void write(IEncoder encoder, int[] value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeListBegin(value.length);
        for (int element : value) {
            encoder.writeInteger(element);
        }
        encoder.writeListEnd();
    }

    public static IntegerArrayTemplate getInstance() {
        return instance;
    }
}

