/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ListTemplate<E>
implements Template<List<E>> {
    private final Template<E> elementTemplate;

    public ListTemplate(Template<E> elementTemplate) {
        this.elementTemplate = elementTemplate;
    }

    @Override
    public List<E> read(IDecoder decoder, List<E> target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        int size = decoder.readListBegin();
        if (target == null) {
            target = new ArrayList(size);
        }
        for (int i = 0; i < size; ++i) {
            target.add(this.elementTemplate.read(decoder, null));
        }
        decoder.readListEnd();
        return target;
    }

    @Override
    public void write(IEncoder encoder, List<E> value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeListBegin(value.size());
        for (E element : value) {
            this.elementTemplate.write(encoder, element);
        }
        encoder.writeListEnd();
    }
}

