/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;

public final class LongArrayTemplate
implements Template<long[]> {
    private static final LongArrayTemplate instance = new LongArrayTemplate();

    private LongArrayTemplate() {
    }

    @Override
    public long[] read(IDecoder decoder, long[] target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        int size = decoder.readListBegin();
        if (target == null || target.length != size) {
            target = new long[size];
        }
        for (int i = 0; i < size; ++i) {
            target[i] = decoder.readLong();
        }
        decoder.readListEnd();
        return target;
    }

    @Override
    public void write(IEncoder encoder, long[] value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeListBegin(value.length);
        for (long element : value) {
            encoder.writeLong(element);
        }
        encoder.writeListEnd();
    }

    public static LongArrayTemplate getInstance() {
        return instance;
    }
}

