/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class MapTemplate<K, V>
implements Template<Map<K, V>> {
    private final Template<K> keyTemplate;
    private final Template<V> valueTemplate;

    public MapTemplate(Template<K> keyTemplate, Template<V> valueTemplate) {
        this.keyTemplate = keyTemplate;
        this.valueTemplate = valueTemplate;
    }

    @Override
    public Map<K, V> read(IDecoder decoder, Map<K, V> target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        int size = decoder.readMapBegin();
        if (target == null) {
            target = new HashMap(size);
        }
        for (int i = 0; i < size; ++i) {
            target.put(this.keyTemplate.read(decoder, null), this.valueTemplate.read(decoder, null));
        }
        decoder.readMapEnd();
        return target;
    }

    @Override
    public void write(IEncoder encoder, Map<K, V> value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeMapBegin(value.size());
        for (Map.Entry<K, V> entry : value.entrySet()) {
            this.keyTemplate.write(encoder, entry.getKey());
            this.valueTemplate.write(encoder, entry.getValue());
        }
        encoder.writeMapEnd();
    }
}

