/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;

public final class ShortArrayTemplate
implements Template<short[]> {
    private static final ShortArrayTemplate instance = new ShortArrayTemplate();

    private ShortArrayTemplate() {
    }

    @Override
    public short[] read(IDecoder decoder, short[] target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        int size = decoder.readListBegin();
        if (target == null || target.length != size) {
            target = new short[size];
        }
        for (int i = 0; i < size; ++i) {
            target[i] = decoder.readShort();
        }
        decoder.readListEnd();
        return target;
    }

    @Override
    public void write(IEncoder encoder, short[] value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeListBegin(value.length);
        for (short element : value) {
            encoder.writeShort(element);
        }
        encoder.writeListEnd();
    }

    public static ShortArrayTemplate getInstance() {
        return instance;
    }
}

