/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.SerializationException;
import at.unbounded.serialization.template.BigDecimalTemplate;
import at.unbounded.serialization.template.BigIntegerTemplate;
import at.unbounded.serialization.template.BooleanArrayTemplate;
import at.unbounded.serialization.template.BooleanTemplate;
import at.unbounded.serialization.template.ByteArrayTemplate;
import at.unbounded.serialization.template.ByteTemplate;
import at.unbounded.serialization.template.CharacterTemplate;
import at.unbounded.serialization.template.DateTemplate;
import at.unbounded.serialization.template.DoubleArrayTemplate;
import at.unbounded.serialization.template.DoubleTemplate;
import at.unbounded.serialization.template.FloatArrayTemplate;
import at.unbounded.serialization.template.FloatTemplate;
import at.unbounded.serialization.template.GenericListTemplate;
import at.unbounded.serialization.template.GenericMapTemplate;
import at.unbounded.serialization.template.GenericTemplate;
import at.unbounded.serialization.template.IntegerArrayTemplate;
import at.unbounded.serialization.template.IntegerTemplate;
import at.unbounded.serialization.template.ListTemplate;
import at.unbounded.serialization.template.LongArrayTemplate;
import at.unbounded.serialization.template.LongTemplate;
import at.unbounded.serialization.template.MapTemplate;
import at.unbounded.serialization.template.ShortArrayTemplate;
import at.unbounded.serialization.template.ShortTemplate;
import at.unbounded.serialization.template.StringTemplate;
import at.unbounded.serialization.template.Template;
import at.unbounded.serialization.template.TemplateReference;
import at.unbounded.serialization.template.UUIDTemplate;
import at.unbounded.serialization.template.builder.TemplateBuilder;
import at.unbounded.serialization.template.builder.TemplateBuilderChain;
import at.unbounded.serialization.template.builder.TemplateEntry;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class TemplateRegistry {
    private final TemplateBuilderChain chain = new TemplateBuilderChain(this);
    protected final Map<Type, Template<Object>> registry = new ConcurrentHashMap<Type, Template<Object>>();
    protected final Map<Type, GenericTemplate> registryGeneric = new ConcurrentHashMap<Type, GenericTemplate>();

    public TemplateRegistry() {
        this.register(Boolean.TYPE, BooleanTemplate.getInstance());
        this.register((Type)((Object)Boolean.class), BooleanTemplate.getInstance());
        this.register(Byte.TYPE, ByteTemplate.getInstance());
        this.register((Type)((Object)Byte.class), ByteTemplate.getInstance());
        this.register(Short.TYPE, ShortTemplate.getInstance());
        this.register((Type)((Object)Short.class), ShortTemplate.getInstance());
        this.register(Character.TYPE, CharacterTemplate.getInstance());
        this.register((Type)((Object)Character.class), CharacterTemplate.getInstance());
        this.register(Integer.TYPE, IntegerTemplate.getInstance());
        this.register((Type)((Object)Integer.class), IntegerTemplate.getInstance());
        this.register(Long.TYPE, LongTemplate.getInstance());
        this.register((Type)((Object)Long.class), LongTemplate.getInstance());
        this.register(Float.TYPE, FloatTemplate.getInstance());
        this.register((Type)((Object)Float.class), FloatTemplate.getInstance());
        this.register(Double.TYPE, DoubleTemplate.getInstance());
        this.register((Type)((Object)Double.class), DoubleTemplate.getInstance());
        this.register((Type)((Object)BigInteger.class), BigIntegerTemplate.getInstance());
        this.register((Type)((Object)BigDecimal.class), BigDecimalTemplate.getInstance());
        this.register((Type)((Object)boolean[].class), BooleanArrayTemplate.getInstance());
        this.register((Type)((Object)short[].class), ShortArrayTemplate.getInstance());
        this.register((Type)((Object)int[].class), IntegerArrayTemplate.getInstance());
        this.register((Type)((Object)long[].class), LongArrayTemplate.getInstance());
        this.register((Type)((Object)float[].class), FloatArrayTemplate.getInstance());
        this.register((Type)((Object)double[].class), DoubleArrayTemplate.getInstance());
        this.register((Type)((Object)byte[].class), ByteArrayTemplate.getInstance());
        this.register((Type)((Object)String.class), StringTemplate.getInstance());
        this.register((Type)((Object)UUID.class), UUIDTemplate.getInstance());
        this.register((Type)((Object)Date.class), DateTemplate.getInstance());
        this.register((Type)((Object)List.class), new ListTemplate(new GenericTemplate.AnyTemplate(this)));
        this.registerGeneric((Type)((Object)List.class), new GenericListTemplate(this, ListTemplate.class));
        this.register((Type)((Object)Map.class), new MapTemplate(new GenericTemplate.AnyTemplate(this), new GenericTemplate.AnyTemplate(this)));
        this.registerGeneric((Type)((Object)Map.class), new GenericMapTemplate(this, MapTemplate.class));
    }

    public void register(Type type, Template template) {
        if (type instanceof ParameterizedType) {
            this.registry.put(((ParameterizedType)type).getRawType(), template);
        } else {
            this.registry.put(type, template);
        }
    }

    public void registerGeneric(Type type, GenericTemplate template) {
        if (type instanceof ParameterizedType) {
            this.registryGeneric.put(((ParameterizedType)type).getRawType(), template);
        } else {
            this.registryGeneric.put(type, template);
        }
    }

    public boolean unregister(Type type) {
        return this.registry.remove(type) != null;
    }

    public void register(Class<?> clazz) {
        this.build(clazz, null);
    }

    public void register(Class<?> clazz, TemplateEntry[] entries) {
        this.build(clazz, entries);
    }

    public Template<Object> lookup(Type type) {
        Template<Object> template = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            template = this.lookupGenericClass(parameterizedType);
            if (template != null) {
                return template;
            }
            template = this.lookupGenericInterface(parameterizedType);
            if (template != null) {
                return template;
            }
            template = this.lookupGenericSuperclass(parameterizedType);
            if (template != null) {
                return template;
            }
            type = parameterizedType.getRawType();
        } else if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            template = this.lookupGenericArray(genericArrayType);
            if (template != null) {
                return template;
            }
        } else if (type instanceof WildcardType || type instanceof TypeVariable) {
            template = new GenericTemplate.AnyTemplate<Object>(this);
            return template;
        }
        template = this.registry.get(type);
        if (template != null) {
            return template;
        }
        Class clazz = (Class)type;
        if (clazz.isInterface()) {
            template = new GenericTemplate.AnyTemplate<Object>(this);
            return template;
        }
        template = this.lookupClass(clazz);
        if (template != null) {
            return template;
        }
        template = this.lookupInterface(clazz);
        if (template != null) {
            return template;
        }
        template = this.lookupSuperclass(clazz);
        if (template != null) {
            return template;
        }
        template = this.lookupSuperclassInterface(clazz);
        if (template != null) {
            return template;
        }
        throw new SerializationException("Template for class " + clazz.getCanonicalName() + " cannot be resolved");
    }

    private Template<Object> lookupGenericClass(ParameterizedType parameterizedType) {
        GenericTemplate genericTemplate = this.registryGeneric.get(parameterizedType.getRawType());
        if (genericTemplate == null) {
            return null;
        }
        Type[] types = parameterizedType.getActualTypeArguments();
        Template[] templates = new Template[types.length];
        for (int i = 0; i < types.length; ++i) {
            templates[i] = this.lookup(types[i]);
        }
        return genericTemplate.build(templates);
    }

    private Template<Object> lookupGenericInterface(ParameterizedType parameterizedType) {
        try {
            Class<?>[] interfaceTypes;
            for (Class<?> interfaceType : interfaceTypes = ((Class)parameterizedType.getRawType()).getInterfaces()) {
                GenericTemplate genericTemplate = this.registryGeneric.get(interfaceType);
                if (genericTemplate == null) continue;
                Type[] types = parameterizedType.getActualTypeArguments();
                Template[] templates = new Template[types.length];
                for (int i = 0; i < types.length; ++i) {
                    templates[i] = this.lookup(types[i]);
                }
                return genericTemplate.build(templates);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    private Template<Object> lookupGenericSuperclass(ParameterizedType parameterizedType) {
        try {
            Class superclassType;
            if (superclassType == null) {
                return null;
            }
            for (superclassType = ((Class)parameterizedType.getRawType()).getSuperclass(); superclassType != Object.class; superclassType = superclassType.getSuperclass()) {
                GenericTemplate genericTemplate = this.registryGeneric.get(superclassType);
                if (genericTemplate == null) continue;
                Type[] types = parameterizedType.getActualTypeArguments();
                Template[] templates = new Template[types.length];
                for (int i = 0; i < types.length; ++i) {
                    templates[i] = this.lookup(types[i]);
                }
                return genericTemplate.build(templates);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    private Template<Object> lookupGenericArray(GenericArrayType genericArrayType) {
        Class<?> clazz;
        ClassLoader classLoader2;
        String name = "" + genericArrayType;
        int dimension = name.split("\\[").length - 1;
        if (dimension <= 0) {
            throw new SerializationException("Cannot convert type into string");
        }
        if (dimension > 1) {
            throw new SerializationException("Template generation with multiplie dimensions not implemented");
        }
        String component = "" + genericArrayType.getGenericComponentType();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dimension; ++i) {
            sb.append('[');
        }
        sb.append(TemplateRegistry.getJvmDefinition(component));
        try {
            classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 != null && (clazz = classLoader2.loadClass(sb.toString())) != null) {
                return this.lookupClass(clazz);
            }
        }
        catch (ClassNotFoundException classLoader2) {
            // empty catch block
        }
        try {
            classLoader2 = this.getClass().getClassLoader();
            if (classLoader2 != null && (clazz = classLoader2.loadClass(sb.toString())) != null) {
                return this.lookupClass(clazz);
            }
        }
        catch (ClassNotFoundException classLoader3) {
            // empty catch block
        }
        try {
            Class<?> clazz2 = Class.forName(sb.toString());
            if (clazz2 != null) {
                return this.lookupClass(clazz2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private Template<Object> lookupClass(Class<?> clazz) {
        Template<Object> template = this.chain.getBuilder(clazz).build(clazz);
        if (template != null) {
            this.register(clazz, template);
            return template;
        }
        return this.build(clazz, null);
    }

    private Template<Object> lookupInterface(Class<?> clazz) {
        Class<?>[] interfaceTypes;
        for (Class<?> interfaceType : interfaceTypes = clazz.getInterfaces()) {
            Template<Object> template = this.registry.get(interfaceType);
            if (template == null) continue;
            this.register(clazz, template);
            return template;
        }
        return null;
    }

    private Template<Object> lookupSuperclass(Class<?> clazz) {
        Class<?> superclassType = clazz.getSuperclass();
        if (superclassType == null) {
            return null;
        }
        while (superclassType != Object.class) {
            Template<Object> template = this.registry.get(superclassType);
            if (template != null) {
                this.register(clazz, template);
                return template;
            }
            superclassType = superclassType.getSuperclass();
        }
        return null;
    }

    private Template<Object> lookupSuperclassInterface(Class<?> clazz) {
        Class<?> superclassType = clazz.getSuperclass();
        if (superclassType == null) {
            return null;
        }
        while (superclassType != Object.class) {
            Template<Object> template = this.lookupInterface(superclassType);
            if (template != null) {
                return template;
            }
            superclassType = superclassType.getSuperclass();
        }
        return null;
    }

    private Template<Object> build(Class<?> clazz, TemplateEntry[] entries) {
        try {
            TemplateBuilder builder = this.chain.getBuilder(clazz);
            TemplateReference template = new TemplateReference(this, clazz);
            this.registry.put(clazz, template);
            return entries != null ? builder.build(clazz, entries) : builder.build(clazz);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String getJvmDefinition(String name) {
        if (name.equals("byte")) {
            return "B";
        }
        if (name.equals("boolean")) {
            return "Z";
        }
        if (name.equals("short")) {
            return "S";
        }
        if (name.equals("char")) {
            return "C";
        }
        if (name.equals("int")) {
            return "I";
        }
        if (name.equals("long")) {
            return "J";
        }
        if (name.equals("float")) {
            return "F";
        }
        if (name.equals("double")) {
            return "D";
        }
        return "L" + name.substring(6) + ";";
    }
}

