/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import java.io.IOException;
import java.util.UUID;

public class UUIDTemplate
implements Template<UUID> {
    private static final UUIDTemplate instance = new UUIDTemplate();

    private UUIDTemplate() {
    }

    @Override
    public UUID read(IDecoder decoder, UUID target) throws IOException {
        if (decoder.readNil()) {
            return null;
        }
        decoder.readListBegin();
        long mostSignificantBits = decoder.readLong();
        long leastSignificantBits = decoder.readLong();
        decoder.readListEnd();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    @Override
    public void write(IEncoder encoder, UUID value) throws IOException {
        if (value == null) {
            encoder.writeNil();
            return;
        }
        encoder.writeListBegin(2);
        encoder.writeLong(value.getMostSignificantBits());
        encoder.writeLong(value.getLeastSignificantBits());
        encoder.writeListEnd();
    }

    public static UUIDTemplate getInstance() {
        return instance;
    }
}

