/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template.builder;

import at.unbounded.serialization.SerializationException;
import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import at.unbounded.serialization.template.TemplateRegistry;
import at.unbounded.serialization.template.builder.TemplateBuilder;
import at.unbounded.serialization.template.builder.TemplateEntry;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;

public final class CompilationTemplateBuilder
extends TemplateBuilder {
    private final ClassPool pool = new ClassPool();
    private final ClassLoader loader;
    private String name;
    private String templateName;
    private CtClass template;

    public CompilationTemplateBuilder(TemplateRegistry registry) {
        super(registry);
        this.pool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
        this.loader = this.pool.getClassLoader();
        try {
            if (this.loader != null) {
                this.pool.appendClassPath((ClassPath)new LoaderClassPath(this.loader));
            } else {
                this.pool.appendSystemPath();
            }
        }
        catch (SecurityException ex) {
            throw new SerializationException("Cannot append a search path of classloader", ex);
        }
    }

    @Override
    public boolean matching(Type type) {
        return !((Class)type).isEnum() && !((Class)type).isInterface();
    }

    @Override
    public <T> Template<T> build(Class<?> clazz, TemplateEntry[] entries) {
        try {
            this.name = clazz.getName();
            this.templateName = this.name + "_$$_Template_" + this.hashCode();
            this.template = this.pool.makeClass(this.templateName);
            this.buildClass();
            this.buildConstructor();
            this.buildReadMethod(entries);
            this.buildWriteMethod(entries);
            Template[] templates = new Template[entries.length];
            for (int i = 0; i < templates.length; ++i) {
                templates[i] = this.registry.lookup(entries[i].getGenericType());
            }
            return (Template)this.template.toClass(this.loader, this.getClass().getProtectionDomain()).getConstructor(Class.class, Template[].class).newInstance(clazz, templates);
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot compile", ex);
        }
    }

    private void buildClass() throws CannotCompileException, NotFoundException {
        this.template.setSuperclass(this.pool.get(CompilationTemplate.class.getName()));
        this.template.addInterface(this.pool.get(Template.class.getName()));
    }

    private void buildConstructor() throws CannotCompileException, NotFoundException {
        this.template.addConstructor(CtNewConstructor.make((CtClass[])new CtClass[]{this.pool.get(Class.class.getName()), this.pool.get(Template.class.getName() + "[]")}, (CtClass[])new CtClass[0], (CtClass)this.template));
    }

    private void buildReadMethod(TemplateEntry[] entries) throws CannotCompileException, NotFoundException {
        StringBuilder sb = new StringBuilder();
        sb.append("{if($1.readNil()){return null;}");
        sb.append(String.format("%s _$$_t;", this.name));
        sb.append("if($2==null){");
        sb.append(String.format("_$$_t=new %s();", this.name));
        sb.append("}else{");
        sb.append(String.format("_$$_t=(%s)$2;", this.name));
        sb.append("}$1.readListBegin();");
        for (int i = 0; i < entries.length; ++i) {
            TemplateEntry entry = entries[i];
            sb.append("if(!$1.readNil()){");
            if (entry.getType().isPrimitive()) {
                sb.append(String.format("_$$_t.%s=$1.%s();", entry.getName(), this.getPrimitiveReadMethod(entry.getType())));
            } else if (Modifier.isPrivate(entry.getField().getModifiers())) {
                sb.append(String.format("%s.readPrivateField(_$$_t,%s.class,\"%s\",$1,templates[%d]);", CompilationTemplateBuilder.class.getName(), entry.getField().getDeclaringClass().getName(), entry.getName(), i));
            } else {
                sb.append(String.format("_$$_t.%s=(%s)templates[%d].read($1,_$$_t.%s);", entry.getName(), entry.getType().getName(), i, entry.getName()));
            }
            sb.append("}");
        }
        sb.append("$1.readListEnd();return _$$_t;}");
        System.out.println(sb.toString());
        this.template.addMethod(CtNewMethod.make((int)1, (CtClass)this.pool.get(Object.class.getName()), (String)"read", (CtClass[])new CtClass[]{this.pool.get(IDecoder.class.getName()), this.pool.get(Object.class.getName())}, (CtClass[])new CtClass[]{this.pool.get(IOException.class.getName())}, (String)sb.toString(), (CtClass)this.template));
    }

    private void buildWriteMethod(TemplateEntry[] entries) throws CannotCompileException, NotFoundException {
        StringBuilder sb = new StringBuilder();
        sb.append("{if($2==null){$1.writeNil();return;}");
        sb.append(String.format("%s _$$_t=(%s)$2;", this.name, this.name));
        sb.append(String.format("$1.writeListBegin(%d);", entries.length));
        for (int i = 0; i < entries.length; ++i) {
            TemplateEntry entry = entries[i];
            if (entry.getType().isPrimitive()) {
                sb.append(String.format("$1.%s(_$$_t.%s);", this.getPrimitiveWriteMethod(entry.getType()), entry.getName()));
                continue;
            }
            if (Modifier.isPrivate(entry.getField().getModifiers())) {
                sb.append(String.format("if(%s.readPrivateField(_$$_t,%s.class,\"%s\")==null){", entry.getName()));
                sb.append("$1.writeNil();}else{");
                sb.append(String.format("%s.writePrivateField(_$$_t,%s.class,\"%s\",$1,templates[%d]);", CompilationTemplateBuilder.class.getName(), entry.getField().getDeclaringClass().getName(), entry.getName(), i));
                sb.append("}");
                continue;
            }
            sb.append(String.format("if(_$$_t.%s==null){", entry.getName()));
            sb.append("$1.writeNil();}else{");
            sb.append(String.format("templates[%d].write($1, _$$_t.%s);", i, entry.getName()));
            sb.append("}");
        }
        sb.append("$1.writeListEnd();}");
        this.template.addMethod(CtNewMethod.make((int)1, (CtClass)CtClass.voidType, (String)"write", (CtClass[])new CtClass[]{this.pool.get(IEncoder.class.getName()), this.pool.get(Object.class.getName())}, (CtClass[])new CtClass[]{this.pool.get(IOException.class.getName())}, (String)sb.toString(), (CtClass)this.template));
    }

    protected static Object readPrivateField(Object object, Class<Object> clazz, String name) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            Object object2 = field.get(object);
            return object2;
        }
        catch (Exception ex) {
            throw new SerializationException(ex);
        }
        finally {
            if (field != null) {
                field.setAccessible(false);
            }
        }
    }

    protected static void readPrivateField(Object object, Class<Object> clazz, String name, IDecoder decoder, Template<Object> template) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            Object value = template.read(decoder, field.get(object));
            if (value != field.get(object)) {
                field.set(object, value);
            }
        }
        catch (Exception ex) {
            throw new SerializationException(ex);
        }
        finally {
            if (field != null) {
                field.setAccessible(false);
            }
        }
    }

    protected static void writePrivateField(Object object, Class<Object> clazz, String name, IEncoder encoder, Template<Object> template) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            template.write(encoder, field.get(object));
        }
        catch (Exception ex) {
            throw new SerializationException(ex);
        }
        finally {
            if (field != null) {
                field.setAccessible(false);
            }
        }
    }

    private String getPrimitiveReadMethod(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return "readBoolean";
        }
        if (clazz == Byte.TYPE) {
            return "readByte";
        }
        if (clazz == Short.TYPE) {
            return "readShort";
        }
        if (clazz == Character.TYPE) {
            return "readShort";
        }
        if (clazz == Integer.TYPE) {
            return "readInteger";
        }
        if (clazz == Long.TYPE) {
            return "readLong";
        }
        if (clazz == Float.TYPE) {
            return "readFloat";
        }
        if (clazz == Double.TYPE) {
            return "readDouble";
        }
        return "";
    }

    private String getPrimitiveWriteMethod(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return "writeBoolean";
        }
        if (clazz == Byte.TYPE) {
            return "writeByte";
        }
        if (clazz == Short.TYPE) {
            return "writeShort";
        }
        if (clazz == Character.TYPE) {
            return "writeShort";
        }
        if (clazz == Integer.TYPE) {
            return "writeInteger";
        }
        if (clazz == Long.TYPE) {
            return "writeLong";
        }
        if (clazz == Float.TYPE) {
            return "writeFloat";
        }
        if (clazz == Double.TYPE) {
            return "writeDouble";
        }
        return "";
    }

    public static abstract class CompilationTemplate<T>
    implements Template<T> {
        public final Class<?> clazz;
        public final Template<Object>[] templates;

        public CompilationTemplate(Class<?> clazz, Template<Object>[] templates) {
            this.clazz = clazz;
            this.templates = templates;
        }
    }
}

