/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template.builder;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import at.unbounded.serialization.template.TemplateRegistry;
import at.unbounded.serialization.template.builder.TemplateBuilder;
import at.unbounded.serialization.template.builder.TemplateEntry;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ReflectionEnumerationTemplateBuilder
extends TemplateBuilder {
    public ReflectionEnumerationTemplateBuilder(TemplateRegistry registry) {
        super(registry);
    }

    @Override
    public boolean matching(Type type) {
        return ((Class)type).isEnum();
    }

    @Override
    public <T> Template<T> build(Type type) {
        return new ReflectionEnumerationTemplate((Class)type);
    }

    @Override
    public <T> Template<T> build(Class<?> clazz, TemplateEntry[] entries) {
        throw new UnsupportedOperationException(clazz.getName());
    }

    public static final class ReflectionEnumerationTemplate<T>
    implements Template<T> {
        private final List<T> ordinals = new ArrayList<T>();
        private final Map<T, Integer> ordinalsInverse = new HashMap<T, Integer>();

        public ReflectionEnumerationTemplate(Class<T> clazz) {
            T[] constants = clazz.getEnumConstants();
            for (int i = 0; i < constants.length; ++i) {
                this.ordinals.add(constants[i]);
                this.ordinalsInverse.put(constants[i], i);
            }
        }

        @Override
        public T read(IDecoder decoder, T target) throws IOException {
            if (decoder.readNil()) {
                return null;
            }
            int ordinal = decoder.readInteger();
            if (ordinal < this.ordinals.size()) {
                return this.ordinals.get(ordinal);
            }
            return null;
        }

        @Override
        public void write(IEncoder encoder, T value) throws IOException {
            if (value == null) {
                encoder.writeNil();
                return;
            }
            encoder.writeInteger(this.ordinalsInverse.get(value));
        }
    }
}

