/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template.builder;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.BooleanArrayTemplate;
import at.unbounded.serialization.template.ByteArrayTemplate;
import at.unbounded.serialization.template.CharacterArrayTemplate;
import at.unbounded.serialization.template.DoubleArrayTemplate;
import at.unbounded.serialization.template.FloatArrayTemplate;
import at.unbounded.serialization.template.IntegerArrayTemplate;
import at.unbounded.serialization.template.LongArrayTemplate;
import at.unbounded.serialization.template.ShortArrayTemplate;
import at.unbounded.serialization.template.Template;
import at.unbounded.serialization.template.TemplateRegistry;
import at.unbounded.serialization.template.builder.TemplateBuilder;
import at.unbounded.serialization.template.builder.TemplateEntry;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class ReflectionGenericTemplateBuilder
extends TemplateBuilder {
    public ReflectionGenericTemplateBuilder(TemplateRegistry registry) {
        super(registry);
    }

    @Override
    public boolean matching(Type type) {
        return type instanceof GenericArrayType ? true : ((Class)type).isArray();
    }

    @Override
    public <T> Template<T> build(Type type) {
        Type elementType = null;
        Class elementClass = null;
        int dimension = 1;
        if (type instanceof GenericArrayType) {
            elementType = ((GenericArrayType)type).getGenericComponentType();
            while (elementType instanceof GenericArrayType) {
                elementType = ((GenericArrayType)elementType).getGenericComponentType();
                ++dimension;
            }
            elementClass = elementType instanceof ParameterizedType ? (Class)((ParameterizedType)elementType).getRawType() : elementType;
        } else {
            elementClass = ((Class)type).getComponentType();
            while (elementClass.isArray()) {
                elementClass = elementClass.getComponentType();
                ++dimension;
            }
            elementType = elementClass;
        }
        return this.build(type, dimension, elementType, elementClass);
    }

    @Override
    public <T> Template<T> build(Class<?> clazz, TemplateEntry[] entries) {
        throw new UnsupportedOperationException(clazz.getName());
    }

    private Template build(Type type, int dimension, Type elementType, Class<?> elementClass) {
        if (dimension == 1) {
            if (elementClass == Boolean.TYPE) {
                return BooleanArrayTemplate.getInstance();
            }
            if (elementClass == Byte.TYPE) {
                return ByteArrayTemplate.getInstance();
            }
            if (elementClass == Short.TYPE) {
                return ShortArrayTemplate.getInstance();
            }
            if (elementClass == Character.TYPE) {
                return CharacterArrayTemplate.getInstance();
            }
            if (elementClass == Integer.TYPE) {
                return IntegerArrayTemplate.getInstance();
            }
            if (elementClass == Long.TYPE) {
                return LongArrayTemplate.getInstance();
            }
            if (elementClass == Float.TYPE) {
                return FloatArrayTemplate.getInstance();
            }
            if (elementClass == Double.TYPE) {
                return DoubleArrayTemplate.getInstance();
            }
        } else {
            return new ReflectionGenericTemplate(Array.newInstance(elementClass, 0).getClass(), this.build(type, dimension - 1, elementType, elementClass));
        }
        return null;
    }

    private static final class ReflectionGenericTemplate
    implements Template<Object> {
        private final Class<?> clazz;
        private final Template<Object> template;

        public ReflectionGenericTemplate(Class<?> clazz, Template<Object> template) {
            this.clazz = clazz;
            this.template = template;
        }

        @Override
        public Object read(IDecoder decoder, Object target) throws IOException {
            if (decoder.readNil()) {
                return null;
            }
            int size = decoder.readListBegin();
            Object[] elements = (Object[])Array.newInstance(this.clazz, size);
            for (int i = 0; i < size; ++i) {
                elements[i] = this.template.read(decoder, null);
            }
            decoder.readListEnd();
            return elements;
        }

        @Override
        public void write(IEncoder encoder, Object value) throws IOException {
            if (value == null) {
                encoder.writeNil();
                return;
            }
            Object[] elements = (Object[])value;
            int size = elements.length;
            encoder.writeListBegin(size);
            for (Object element : elements) {
                this.template.write(encoder, element);
            }
            encoder.writeListEnd();
        }
    }
}

