/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template.builder;

import at.unbounded.serialization.stream.IDecoder;
import at.unbounded.serialization.stream.IEncoder;
import at.unbounded.serialization.template.Template;
import at.unbounded.serialization.template.TemplateRegistry;
import at.unbounded.serialization.template.builder.TemplateBuilder;
import at.unbounded.serialization.template.builder.TemplateEntry;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public final class ReflectionTemplateBuilder
extends TemplateBuilder {
    public ReflectionTemplateBuilder(TemplateRegistry registry) {
        super(registry);
    }

    @Override
    public boolean matching(Type type) {
        return !((Class)type).isEnum() && !((Class)type).isInterface();
    }

    @Override
    public <T> Template<T> build(Class<?> clazz, TemplateEntry[] entries) {
        for (TemplateEntry entry : entries) {
            Field field = entry.getField();
            if (Modifier.isPublic(field.getModifiers())) continue;
            field.setAccessible(true);
        }
        ReflectionFieldTemplate[] templates = new ReflectionFieldTemplate[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            templates[i] = new ReflectionFieldTemplate(entries[i], this.registry.lookup(entries[i].getGenericType()));
        }
        return new ReflectionClassTemplate(clazz, templates);
    }

    private static final class ReflectionFieldTemplate
    implements Template<Object> {
        private final TemplateEntry entry;
        private final Template<Object> template;

        public ReflectionFieldTemplate(TemplateEntry entry, Template<Object> template) {
            this.entry = entry;
            this.template = template;
        }

        @Override
        public Object read(IDecoder decoder, Object target) throws IOException {
            Object value = this.template.read(decoder, this.entry.get(target));
            if (value != this.entry.get(target)) {
                this.entry.set(target, value);
            }
            return value;
        }

        @Override
        public void write(IEncoder encoder, Object value) throws IOException {
            this.template.write(encoder, value);
        }
    }

    private static class ReflectionClassTemplate<T>
    implements Template<T> {
        private final Class<?> clazz;
        private final ReflectionFieldTemplate[] templates;

        public ReflectionClassTemplate(Class<?> clazz, ReflectionFieldTemplate[] templates) {
            this.clazz = clazz;
            this.templates = templates;
        }

        @Override
        public T read(IDecoder decoder, T target) throws IOException {
            if (decoder.readNil()) {
                return null;
            }
            if (target == null) {
                try {
                    target = this.clazz.newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            decoder.readListBegin();
            for (int i = 0; i < this.templates.length; ++i) {
                ReflectionFieldTemplate template = this.templates[i];
                if (decoder.readNil()) continue;
                template.read(decoder, target);
            }
            decoder.readListEnd();
            return target;
        }

        @Override
        public void write(IEncoder encoder, T value) throws IOException {
            if (value == null) {
                encoder.writeNil();
                return;
            }
            encoder.writeListBegin(this.templates.length);
            for (ReflectionFieldTemplate template : this.templates) {
                Object object = template.entry.get(value);
                if (object == null) {
                    encoder.writeNil();
                    continue;
                }
                template.write(encoder, object);
            }
            encoder.writeListEnd();
        }
    }
}

