/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template.builder;

import at.unbounded.serialization.SerializationException;
import at.unbounded.serialization.annotation.Ignore;
import at.unbounded.serialization.annotation.Index;
import at.unbounded.serialization.template.Template;
import at.unbounded.serialization.template.TemplateRegistry;
import at.unbounded.serialization.template.builder.TemplateEntry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class TemplateBuilder {
    protected final TemplateRegistry registry;

    protected TemplateBuilder(TemplateRegistry registry) {
        this.registry = registry;
    }

    public abstract boolean matching(Type var1);

    public <T> Template<T> build(Type type) {
        Class clazz = (Class)type;
        if (clazz.isInterface()) {
            throw new SerializationException("Cannot build template for interface " + clazz.getName());
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new SerializationException("Cannot build template for abstract class " + clazz.getName());
        }
        if (clazz.isArray()) {
            throw new SerializationException("Cannot build template for array class " + clazz.getName());
        }
        if (clazz.isPrimitive()) {
            throw new SerializationException("Cannot build template of primitive type " + clazz.getName());
        }
        return this.build(clazz, this.getFieldEntries(clazz));
    }

    public abstract <T> Template<T> build(Class<?> var1, TemplateEntry[] var2);

    protected TemplateEntry[] getFieldEntries(Class<?> clazz) {
        int currentIndex = -1;
        Field[] fields = this.getFields(clazz);
        ArrayList<TemplateEntry> indexed = new ArrayList<TemplateEntry>();
        for (Field field : fields) {
            if (this.isFieldIgnored(field)) {
                System.out.println("ignore " + field.getName());
                continue;
            }
            int index = this.getFieldIndex(field, currentIndex);
            if (indexed.size() > index && indexed.get(index) != null) {
                throw new SerializationException("Index " + index + " duplicating");
            }
            if (index < 0) {
                throw new SerializationException("Index " + index + " is invalid");
            }
            while (indexed.size() <= index) {
                indexed.add(null);
            }
            indexed.set(index, new TemplateEntry(field));
            if (currentIndex >= index) continue;
            currentIndex = index;
        }
        TemplateEntry[] entries = new TemplateEntry[currentIndex + 1];
        for (int i = 0; i < indexed.size(); ++i) {
            TemplateEntry entry = (TemplateEntry)indexed.get(i);
            entries[i] = entry == null ? new TemplateEntry() : entry;
        }
        return entries;
    }

    private Field[] getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> extension = clazz; extension != Object.class; extension = extension.getSuperclass()) {
            Field[] extensionFields = extension.getDeclaredFields();
            fields.addAll(Arrays.asList(extensionFields));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private int getFieldIndex(Field field, int currentIndex) {
        Index annotation = field.getAnnotation(Index.class);
        if (annotation == null) {
            return currentIndex + 1;
        }
        return annotation.index();
    }

    private boolean isFieldIgnored(Field field) {
        return field.isAnnotationPresent(Ignore.class);
    }
}

