/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.serialization.template.builder;

import at.unbounded.serialization.template.TemplateRegistry;
import at.unbounded.serialization.template.builder.CompilationTemplateBuilder;
import at.unbounded.serialization.template.builder.ReflectionEnumerationTemplateBuilder;
import at.unbounded.serialization.template.builder.ReflectionGenericTemplateBuilder;
import at.unbounded.serialization.template.builder.ReflectionTemplateBuilder;
import at.unbounded.serialization.template.builder.TemplateBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class TemplateBuilderChain {
    private final List<TemplateBuilder> builder = new ArrayList<TemplateBuilder>();

    public TemplateBuilderChain(TemplateRegistry registry) {
        boolean javassist = false;
        if (!System.getProperty("java.vm.name").equals("Dalvik")) {
            try {
                Class.forName("javassist.ClassClassPath");
                Class.forName("javassist.ClassPool");
                javassist = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.builder.add(new ReflectionGenericTemplateBuilder(registry));
        this.builder.add(new ReflectionEnumerationTemplateBuilder(registry));
        this.builder.add(javassist ? new CompilationTemplateBuilder(registry) : new ReflectionTemplateBuilder(registry));
    }

    public TemplateBuilder getBuilder(Type type) {
        for (TemplateBuilder templateBuilder : this.builder) {
            if (!templateBuilder.matching(type)) continue;
            return templateBuilder;
        }
        return null;
    }
}

