/*
 * Decompiled with CFR 0.152.
 */
package au.com.acegi.xmlformat;

import au.com.acegi.xmlformat.XmlOutputFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

class BlankLinesWriter
extends XMLWriter {
    BlankLinesWriter(OutputStream out, XmlOutputFormat fmt) throws UnsupportedEncodingException {
        super(out, (OutputFormat)fmt);
    }

    protected void writeString(String text) throws IOException {
        if (text == null || text.length() == 0) {
            return;
        }
        String input = text;
        if (this.isEscapeText()) {
            input = this.escapeElementEntities(text);
        }
        if (this.getOutputFormat().isTrimText()) {
            boolean first = true;
            StringTokenizer tokenizer = new StringTokenizer(input, " \t\r\f");
            NewLinesHandler newLinesHandler = new NewLinesHandler();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (newLinesHandler.processToken(token, tokenizer.hasMoreTokens())) continue;
                if (first) {
                    first = false;
                    if (this.lastOutputNodeType == 3) {
                        this.writer.write(" ");
                    }
                } else {
                    this.writer.write(" ");
                }
                this.writer.write(token.trim());
                this.lastOutputNodeType = 3;
            }
            newLinesHandler.finished();
        } else {
            this.lastOutputNodeType = 3;
            this.writer.write(input);
        }
    }

    private final class NewLinesHandler {
        private int newLinesCount;

        private NewLinesHandler() {
        }

        private boolean processToken(String token, boolean hasMoreTokens) throws IOException {
            int tokenNewLines = StringUtils.countMatches((CharSequence)token, (char)'\n');
            if (tokenNewLines > 0) {
                this.newLinesCount += tokenNewLines;
                return hasMoreTokens;
            }
            if (this.newLinesCount > 1) {
                BlankLinesWriter.this.writer.write("\n");
                this.newLinesCount = 0;
            }
            return false;
        }

        private void finished() throws IOException {
            if (this.newLinesCount > 1) {
                BlankLinesWriter.this.writer.write("\n");
            }
        }
    }
}

