/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.dsl.PactDslJsonBody;
import au.com.dius.pact.model.Consumer;
import au.com.dius.pact.model.InvalidPactException;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.Provider;
import au.com.dius.pact.model.v3.messaging.Message;
import au.com.dius.pact.model.v3.messaging.MessagePact;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class MessagePactBuilder {
    private Consumer consumer;
    private Provider provider;
    private String providerState;
    private List<Message> messages;

    private MessagePactBuilder(String consumer) {
        this.consumer = new Consumer(consumer);
    }

    public static MessagePactBuilder consumer(String consumer) {
        return new MessagePactBuilder(consumer);
    }

    public MessagePactBuilder hasPactWith(String provider) {
        this.provider = new Provider(provider);
        return this;
    }

    public MessagePactBuilder given(String providerState) {
        this.providerState = providerState;
        return this;
    }

    public MessagePactBuilder expectsToReceive(String description) {
        Message message = new Message(description, this.providerState);
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        this.messages.add(message);
        return this;
    }

    public MessagePactBuilder withMetadata(Map<String, String> metadata) {
        if (this.messages == null || this.messages.isEmpty()) {
            throw new InvalidPactException("expectsToReceive is required before withMetaData");
        }
        this.messages.get(this.messages.size() - 1).setMetaData(metadata);
        return this;
    }

    public MessagePactBuilder withContent(PactDslJsonBody body) {
        if (this.messages == null || this.messages.isEmpty()) {
            throw new InvalidPactException("expectsToReceive is required before withMetaData");
        }
        Message message = this.messages.get(this.messages.size() - 1);
        HashMap<String, String> metadata = message.getMetaData();
        if (metadata == null) {
            metadata = new HashMap<String, String>(1);
            metadata.put("Content-Type", ContentType.APPLICATION_JSON.toString());
        } else if (!metadata.containsKey("Content-Type")) {
            metadata.put("Content-Type", ContentType.APPLICATION_JSON.toString());
        }
        message.setContents(OptionalBody.body((String)body.toString()));
        HashMap matchingRules = new HashMap();
        for (String matcherName : body.getMatchers().keySet()) {
            matchingRules.put("$.body" + matcherName, body.getMatchers().get(matcherName));
        }
        message.setMatchingRules(matchingRules);
        return this;
    }

    public MessagePact toPact() {
        MessagePact pact = new MessagePact();
        pact.setConsumer(this.consumer);
        pact.setProvider(this.provider);
        pact.setMessages(this.messages);
        return pact;
    }
}

