/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.ConsumerPactRunnerKt;
import au.com.dius.pact.consumer.MockServer;
import au.com.dius.pact.consumer.PactMismatchesException;
import au.com.dius.pact.consumer.PactVerificationResult;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.model.MockProviderConfig;
import au.com.dius.pact.model.PactSpecVersion;
import au.com.dius.pact.model.RequestResponsePact;
import java.io.IOException;
import org.junit.Test;

public abstract class ConsumerPactTestMk2 {
    protected abstract RequestResponsePact createPact(PactDslWithProvider var1);

    protected abstract String providerName();

    protected abstract String consumerName();

    protected abstract void runTest(MockServer var1) throws IOException;

    @Test
    public void testPact() throws Throwable {
        MockProviderConfig config;
        RequestResponsePact pact = this.createPact(ConsumerPactBuilder.consumer((String)this.consumerName()).hasPactWith(this.providerName()));
        PactVerificationResult result = ConsumerPactRunnerKt.runConsumerTest((RequestResponsePact)pact, (MockProviderConfig)(config = MockProviderConfig.createDefault((PactSpecVersion)this.getSpecificationVersion())), this::runTest);
        if (!result.equals(PactVerificationResult.Ok.INSTANCE)) {
            if (result instanceof PactVerificationResult.Error) {
                PactVerificationResult.Error error = (PactVerificationResult.Error)result;
                if (error.getMockServerState() != PactVerificationResult.Ok.INSTANCE) {
                    throw new AssertionError("Pact Test function failed with an exception, possibly due to " + error.getMockServerState(), ((PactVerificationResult.Error)result).getError());
                }
                throw new AssertionError("Pact Test function failed with an exception: " + error.getError().getMessage(), error.getError());
            }
            throw new PactMismatchesException(result);
        }
    }

    protected PactSpecVersion getSpecificationVersion() {
        return PactSpecVersion.V2;
    }
}

