/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslResponse;
import au.com.dius.pact.model.Consumer;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.Provider;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import nl.flotsam.xeger.Xeger;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;
import org.w3c.dom.Document;

public class PactDslRequestWithPath {
    private final ConsumerPactBuilder consumerPactBuilder;
    Consumer consumer;
    Provider provider;
    String state;
    String description;
    String path = "/";
    String requestMethod = "GET";
    Map<String, String> requestHeaders = new HashMap<String, String>();
    String query;
    OptionalBody requestBody = OptionalBody.missing();
    Map<String, Map<String, Object>> requestMatchers = new HashMap<String, Map<String, Object>>();

    public PactDslRequestWithPath(ConsumerPactBuilder consumerPactBuilder, String consumerName, String providerName, String state, String description, String path, String requestMethod, Map<String, String> requestHeaders, String query, OptionalBody requestBody, Map<String, Map<String, Object>> requestMatchers) {
        this.consumerPactBuilder = consumerPactBuilder;
        this.requestMatchers = requestMatchers;
        this.consumer = new Consumer(consumerName);
        this.provider = new Provider(providerName);
        this.state = state;
        this.description = description;
        this.path = path;
        this.requestMethod = requestMethod;
        this.requestHeaders = requestHeaders;
        this.query = query;
        this.requestBody = requestBody;
        this.requestMatchers = requestMatchers;
    }

    public PactDslRequestWithPath(ConsumerPactBuilder consumerPactBuilder, PactDslRequestWithPath existing, String description) {
        this.consumerPactBuilder = consumerPactBuilder;
        this.consumer = existing.consumer;
        this.provider = existing.provider;
        this.state = existing.state;
        this.description = description;
    }

    public PactDslRequestWithPath method(String method) {
        this.requestMethod = method;
        return this;
    }

    public PactDslRequestWithPath headers(Map<String, String> headers) {
        this.requestHeaders.putAll(headers);
        return this;
    }

    public PactDslRequestWithPath query(String query) {
        this.query = query;
        return this;
    }

    public PactDslRequestWithPath body(String body) {
        this.requestBody = OptionalBody.body((String)body);
        return this;
    }

    public PactDslRequestWithPath body(String body, String mimeType) {
        this.requestBody = OptionalBody.body((String)body);
        this.requestHeaders.put("Content-Type", mimeType);
        return this;
    }

    public PactDslRequestWithPath body(String body, ContentType mimeType) {
        return this.body(body, mimeType.toString());
    }

    public PactDslRequestWithPath body(JSONObject body) {
        this.requestBody = OptionalBody.body((String)body.toString());
        if (!this.requestHeaders.containsKey("Content-Type")) {
            this.requestHeaders.put("Content-Type", ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslRequestWithPath body(DslPart body) {
        for (String matcherName : body.matchers.keySet()) {
            this.requestMatchers.put("$.body" + matcherName, body.matchers.get(matcherName));
        }
        this.requestBody = OptionalBody.body((String)body.toString());
        if (!this.requestHeaders.containsKey("Content-Type")) {
            this.requestHeaders.put("Content-Type", ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslRequestWithPath body(Document body) throws TransformerException {
        this.requestBody = OptionalBody.body((String)ConsumerPactBuilder.xmlToString(body));
        if (!this.requestHeaders.containsKey("Content-Type")) {
            this.requestHeaders.put("Content-Type", ContentType.APPLICATION_XML.toString());
        }
        return this;
    }

    public PactDslRequestWithPath path(String path) {
        this.path = path;
        return this;
    }

    public PactDslRequestWithPath matchPath(String pathRegex) {
        return this.matchPath(pathRegex, new Xeger(pathRegex).generate());
    }

    public PactDslRequestWithPath matchPath(String pathRegex, String path) {
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("regex", pathRegex);
        this.requestMatchers.put("$.path", matcher);
        this.path = path;
        return this;
    }

    public PactDslRequestWithPath matchHeader(String header, String regex) {
        return this.matchHeader(header, regex, new Xeger(regex).generate());
    }

    public PactDslRequestWithPath matchHeader(String header, String regex, String headerExample) {
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("regex", regex);
        this.requestMatchers.put("$.headers." + header, matcher);
        this.requestHeaders.put(header, headerExample);
        return this;
    }

    public PactDslResponse willRespondWith() {
        return new PactDslResponse(this.consumerPactBuilder, this);
    }
}

