/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslJsonBody;
import java.util.HashMap;
import java.util.Map;

public abstract class DslPart {
    public static final String HEXADECIMAL = "[0-9a-fA-F]+";
    public static final String IP_ADDRESS = "(\\d{1,3}\\.)+\\d{1,3}";
    public static final String UUID_REGEX = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
    private static final String MATCH = "match";
    protected final DslPart parent;
    protected final String rootPath;
    protected final String rootName;
    protected Map<String, Map<String, Object>> matchers = new HashMap<String, Map<String, Object>>();
    protected boolean closed = false;

    public DslPart(DslPart parent, String rootPath, String rootName) {
        this.parent = parent;
        this.rootPath = rootPath;
        this.rootName = rootName;
    }

    public DslPart(String rootPath, String rootName) {
        this.parent = null;
        this.rootPath = rootPath;
        this.rootName = rootName;
    }

    protected abstract void putObject(DslPart var1);

    protected abstract void putArray(DslPart var1);

    public abstract Object getBody();

    public abstract PactDslJsonArray array(String var1);

    public abstract PactDslJsonArray array();

    public abstract DslPart closeArray();

    @Deprecated
    public abstract PactDslJsonBody arrayLike(String var1);

    @Deprecated
    public abstract PactDslJsonBody arrayLike();

    public abstract PactDslJsonBody eachLike(String var1);

    public abstract PactDslJsonBody eachLike();

    public abstract PactDslJsonBody eachLike(String var1, int var2);

    public abstract PactDslJsonBody eachLike(int var1);

    public abstract PactDslJsonBody minArrayLike(String var1, Integer var2);

    public abstract PactDslJsonBody minArrayLike(Integer var1);

    public abstract PactDslJsonBody minArrayLike(String var1, Integer var2, int var3);

    public abstract PactDslJsonBody minArrayLike(Integer var1, int var2);

    public abstract PactDslJsonBody maxArrayLike(String var1, Integer var2);

    public abstract PactDslJsonBody maxArrayLike(Integer var1);

    public abstract PactDslJsonBody maxArrayLike(String var1, Integer var2, int var3);

    public abstract PactDslJsonBody maxArrayLike(Integer var1, int var2);

    public abstract PactDslJsonArray eachArrayLike(String var1);

    public abstract PactDslJsonArray eachArrayLike();

    public abstract PactDslJsonArray eachArrayLike(String var1, int var2);

    public abstract PactDslJsonArray eachArrayLike(int var1);

    public abstract PactDslJsonArray eachArrayWithMaxLike(String var1, Integer var2);

    public abstract PactDslJsonArray eachArrayWithMaxLike(Integer var1);

    public abstract PactDslJsonArray eachArrayWithMaxLike(String var1, int var2, Integer var3);

    public abstract PactDslJsonArray eachArrayWithMaxLike(int var1, Integer var2);

    public abstract PactDslJsonArray eachArrayWithMinLike(String var1, Integer var2);

    public abstract PactDslJsonArray eachArrayWithMinLike(Integer var1);

    public abstract PactDslJsonArray eachArrayWithMinLike(String var1, int var2, Integer var3);

    public abstract PactDslJsonArray eachArrayWithMinLike(int var1, Integer var2);

    public abstract PactDslJsonBody object(String var1);

    public abstract PactDslJsonBody object();

    public abstract DslPart closeObject();

    public Map<String, Map<String, Object>> getMatchers() {
        HashMap<String, Map<String, Object>> matchersWithPrefix = new HashMap<String, Map<String, Object>>();
        for (String matcherName : this.matchers.keySet()) {
            matchersWithPrefix.put("$.body" + matcherName, this.matchers.get(matcherName));
        }
        return matchersWithPrefix;
    }

    public void setMatchers(Map<String, Map<String, Object>> matchers) {
        this.matchers = matchers;
    }

    protected Map<String, Object> matchType() {
        return this.matchType("type");
    }

    protected Map<String, Object> matchType(String type) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put(MATCH, type);
        return jsonObject;
    }

    protected Map<String, Object> regexp(String regex) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put(MATCH, "regex");
        jsonObject.put("regex", regex);
        return jsonObject;
    }

    protected Map<String, Object> matchTimestamp(String format) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put(MATCH, "timestamp");
        jsonObject.put("timestamp", format);
        return jsonObject;
    }

    protected Map<String, Object> matchDate(String format) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put(MATCH, "date");
        jsonObject.put("date", format);
        return jsonObject;
    }

    protected Map<String, Object> matchTime(String format) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put(MATCH, "time");
        jsonObject.put("time", format);
        return jsonObject;
    }

    protected Map<String, Object> matchMin(Integer min) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("min", min);
        jsonObject.put(MATCH, "type");
        return jsonObject;
    }

    protected Map<String, Object> matchMax(Integer max) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("max", max);
        jsonObject.put(MATCH, "type");
        return jsonObject;
    }

    public PactDslJsonBody asBody() {
        return (PactDslJsonBody)this;
    }

    public PactDslJsonArray asArray() {
        return (PactDslJsonArray)this;
    }

    public abstract DslPart close();
}

