/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.InvalidMatcherException;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonBody;
import au.com.dius.pact.consumer.dsl.PactDslJsonRootValue;
import com.mifmif.common.regex.Generex;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.json.JSONArray;
import org.json.JSONObject;

public class PactDslJsonArray
extends DslPart {
    private static final String EXAMPLE = "Example \"";
    private final JSONArray body;
    private boolean wildCard;
    private int numberExamples = 1;

    public PactDslJsonArray() {
        this("", "", null, false);
    }

    public PactDslJsonArray(String rootPath, String rootName, DslPart parent) {
        this(rootPath, rootName, parent, false);
    }

    public PactDslJsonArray(String rootPath, String rootName, DslPart parent, boolean wildCard) {
        super(parent, rootPath, rootName);
        this.wildCard = wildCard;
        this.body = new JSONArray();
    }

    @Override
    public DslPart closeArray() {
        if (this.parent != null) {
            this.parent.putArray(this);
        }
        this.closed = true;
        return this.parent;
    }

    @Override
    @Deprecated
    public PactDslJsonBody arrayLike(String name) {
        throw new UnsupportedOperationException("use the eachLike() form");
    }

    @Override
    @Deprecated
    public PactDslJsonBody arrayLike() {
        return this.eachLike();
    }

    @Override
    public PactDslJsonBody eachLike(String name) {
        throw new UnsupportedOperationException("use the eachLike() form");
    }

    @Override
    public PactDslJsonBody eachLike(String name, int numberExamples) {
        throw new UnsupportedOperationException("use the eachLike(numberExamples) form");
    }

    @Override
    public PactDslJsonBody eachLike() {
        return this.eachLike(1);
    }

    @Override
    public PactDslJsonBody eachLike(int numberExamples) {
        this.matchers.put(this.rootPath + this.appendArrayIndex(1), this.matchMin(0));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, this.rootName, this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonBody(".", "", parent);
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size) {
        throw new UnsupportedOperationException("use the minArrayLike(Integer size) form");
    }

    @Override
    public PactDslJsonBody minArrayLike(Integer size) {
        return this.minArrayLike(size, (int)size);
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size, int numberExamples) {
        throw new UnsupportedOperationException("use the minArrayLike(Integer size, int numberExamples) form");
    }

    @Override
    public PactDslJsonBody minArrayLike(Integer size, int numberExamples) {
        if (numberExamples < size) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, size));
        }
        this.matchers.put(this.rootPath + this.appendArrayIndex(1), this.matchMin(size));
        PactDslJsonArray parent = new PactDslJsonArray("", "", this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonBody(".", "", parent);
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size) {
        throw new UnsupportedOperationException("use the maxArrayLike(Integer size) form");
    }

    @Override
    public PactDslJsonBody maxArrayLike(Integer size) {
        return this.maxArrayLike(size, 1);
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size, int numberExamples) {
        throw new UnsupportedOperationException("use the maxArrayLike(Integer size, int numberExamples) form");
    }

    @Override
    public PactDslJsonBody maxArrayLike(Integer size, int numberExamples) {
        if (numberExamples > size) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, size));
        }
        this.matchers.put(this.rootPath + this.appendArrayIndex(1), this.matchMax(size));
        PactDslJsonArray parent = new PactDslJsonArray("", "", this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonBody(".", "", parent);
    }

    @Override
    protected void putObject(DslPart object) {
        for (String matcherName : object.matchers.keySet()) {
            this.matchers.put(this.rootPath + this.appendArrayIndex(1) + matcherName, object.matchers.get(matcherName));
        }
        for (int i = 0; i < this.getNumberExamples(); ++i) {
            this.body.put(object.getBody());
        }
    }

    @Override
    protected void putArray(DslPart object) {
        for (String matcherName : object.matchers.keySet()) {
            this.matchers.put(this.rootPath + this.appendArrayIndex(1) + matcherName, object.matchers.get(matcherName));
        }
        this.body.put(object.getBody());
    }

    @Override
    public Object getBody() {
        return this.body;
    }

    public PactDslJsonArray stringValue(String value) {
        if (value == null) {
            this.body.put(JSONObject.NULL);
        } else {
            this.body.put((Object)value);
        }
        return this;
    }

    public PactDslJsonArray string(String value) {
        return this.stringValue(value);
    }

    public PactDslJsonArray numberValue(Number value) {
        this.body.put((Object)value);
        return this;
    }

    public PactDslJsonArray number(Number value) {
        return this.numberValue(value);
    }

    public PactDslJsonArray booleanValue(Boolean value) {
        this.body.put((Object)value);
        return this;
    }

    public PactDslJsonArray stringType() {
        this.body.put((Object)RandomStringUtils.randomAlphabetic((int)20));
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchType());
        return this;
    }

    public PactDslJsonArray stringType(String example) {
        this.body.put((Object)example);
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchType());
        return this;
    }

    public PactDslJsonArray numberType() {
        return this.numberType(Long.parseLong(RandomStringUtils.randomNumeric((int)9)));
    }

    public PactDslJsonArray numberType(Number number) {
        this.body.put((Object)number);
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchType("type"));
        return this;
    }

    public PactDslJsonArray integerType() {
        return this.integerType(Long.parseLong(RandomStringUtils.randomNumeric((int)9)));
    }

    public PactDslJsonArray integerType(Long number) {
        this.body.put((Object)number);
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchType("integer"));
        return this;
    }

    @Deprecated
    public PactDslJsonArray realType() {
        return this.decimalType();
    }

    @Deprecated
    public PactDslJsonArray realType(Double number) {
        return this.decimalType(number);
    }

    public PactDslJsonArray decimalType() {
        return this.decimalType(new BigDecimal(RandomStringUtils.randomNumeric((int)10)));
    }

    public PactDslJsonArray decimalType(BigDecimal number) {
        this.body.put((Object)number);
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchType("decimal"));
        return this;
    }

    public PactDslJsonArray decimalType(Double number) {
        this.body.put((Object)number);
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchType("decimal"));
        return this;
    }

    public PactDslJsonArray booleanType() {
        this.body.put(true);
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchType());
        return this;
    }

    public PactDslJsonArray booleanType(Boolean example) {
        this.body.put((Object)example);
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchType());
        return this;
    }

    public PactDslJsonArray stringMatcher(String regex, String value) {
        if (!value.matches(regex)) {
            throw new InvalidMatcherException(EXAMPLE + value + "\" does not match regular expression \"" + regex + "\"");
        }
        this.body.put((Object)value);
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.regexp(regex));
        return this;
    }

    public PactDslJsonArray stringMatcher(String regex) {
        this.stringMatcher(regex, new Generex(regex).random());
        return this;
    }

    public PactDslJsonArray timestamp() {
        this.body.put((Object)DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date()));
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchTimestamp(DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonArray timestamp(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(new Date()));
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchTimestamp(format));
        return this;
    }

    public PactDslJsonArray timestamp(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(example));
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchTimestamp(format));
        return this;
    }

    public PactDslJsonArray date() {
        this.body.put((Object)DateFormatUtils.ISO_DATE_FORMAT.format(new Date()));
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchDate(DateFormatUtils.ISO_DATE_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonArray date(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(new Date()));
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchDate(format));
        return this;
    }

    public PactDslJsonArray date(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(example));
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchDate(format));
        return this;
    }

    public PactDslJsonArray time() {
        this.body.put((Object)DateFormatUtils.ISO_TIME_FORMAT.format(new Date()));
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchTime(DateFormatUtils.ISO_TIME_FORMAT.getPattern()));
        return this;
    }

    public PactDslJsonArray time(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(new Date()));
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchTime(format));
        return this;
    }

    public PactDslJsonArray time(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(example));
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchTime(format));
        return this;
    }

    public PactDslJsonArray ipAddress() {
        this.body.put((Object)"127.0.0.1");
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.regexp("(\\d{1,3}\\.)+\\d{1,3}"));
        return this;
    }

    @Override
    public PactDslJsonBody object(String name) {
        throw new UnsupportedOperationException("use the object() form");
    }

    @Override
    public PactDslJsonBody object() {
        return new PactDslJsonBody(".", "", this);
    }

    @Override
    public DslPart closeObject() {
        throw new UnsupportedOperationException("can't call closeObject on an Array");
    }

    @Override
    public DslPart close() {
        DslPart parentToReturn = this;
        if (!this.closed) {
            DslPart parent = this.closeArray();
            while (parent != null) {
                parentToReturn = parent;
                if (parent instanceof PactDslJsonArray) {
                    parent = parent.closeArray();
                    continue;
                }
                parent = parent.closeObject();
            }
        }
        return parentToReturn;
    }

    @Override
    public PactDslJsonArray array(String name) {
        throw new UnsupportedOperationException("use the array() form");
    }

    @Override
    public PactDslJsonArray array() {
        return new PactDslJsonArray("", "", this);
    }

    public PactDslJsonArray id() {
        this.body.put(Long.parseLong(RandomStringUtils.randomNumeric((int)10)));
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchType());
        return this;
    }

    public PactDslJsonArray id(Long id) {
        this.body.put((Object)id);
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.matchType());
        return this;
    }

    public PactDslJsonArray hexValue() {
        return this.hexValue(RandomStringUtils.random((int)10, (String)"0123456789abcdef"));
    }

    public PactDslJsonArray hexValue(String hexValue) {
        if (!hexValue.matches("[0-9a-fA-F]+")) {
            throw new InvalidMatcherException(EXAMPLE + hexValue + "\" is not a hexadecimal value");
        }
        this.body.put((Object)hexValue);
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.regexp("[0-9a-fA-F]+"));
        return this;
    }

    @Deprecated
    public PactDslJsonArray guid() {
        return this.uuid();
    }

    @Deprecated
    public PactDslJsonArray guid(String uuid) {
        return this.uuid(uuid);
    }

    public PactDslJsonArray uuid() {
        return this.uuid(UUID.randomUUID().toString());
    }

    public PactDslJsonArray uuid(String uuid) {
        if (!uuid.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}")) {
            throw new InvalidMatcherException(EXAMPLE + uuid + "\" is not an UUID");
        }
        this.body.put((Object)uuid);
        this.matchers.put(this.rootPath + this.appendArrayIndex(0), this.regexp("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
        return this;
    }

    public PactDslJsonArray template(DslPart template) {
        this.putObject(template);
        return this;
    }

    public PactDslJsonArray template(DslPart template, int occurrences) {
        for (int i = 0; i < occurrences; ++i) {
            this.template(template);
        }
        return this;
    }

    public String toString() {
        return this.body.toString();
    }

    private String appendArrayIndex(Integer offset) {
        String index = "*";
        if (!this.wildCard) {
            index = String.valueOf(this.body.length() - 1 + offset);
        }
        return "[" + index + "]";
    }

    public static PactDslJsonBody arrayEachLike() {
        return PactDslJsonArray.arrayEachLike(1);
    }

    public static PactDslJsonBody arrayEachLike(Integer numberExamples) {
        PactDslJsonArray parent = new PactDslJsonArray("", "", null, true);
        parent.setNumberExamples(numberExamples);
        parent.matchers.put("", parent.matchMin(0));
        return new PactDslJsonBody(".", "", parent);
    }

    public static PactDslJsonBody arrayMinLike(int minSize) {
        return PactDslJsonArray.arrayMinLike(minSize, minSize);
    }

    public static PactDslJsonBody arrayMinLike(int minSize, int numberExamples) {
        if (numberExamples < minSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, minSize));
        }
        PactDslJsonArray parent = new PactDslJsonArray("", "", null, true);
        parent.setNumberExamples(numberExamples);
        parent.matchers.put("", parent.matchMin(minSize));
        return new PactDslJsonBody(".", "", parent);
    }

    public static PactDslJsonBody arrayMaxLike(int maxSize) {
        return PactDslJsonArray.arrayMaxLike(maxSize, 1);
    }

    public static PactDslJsonBody arrayMaxLike(int maxSize, int numberExamples) {
        if (numberExamples > maxSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, maxSize));
        }
        PactDslJsonArray parent = new PactDslJsonArray("", "", null, true);
        parent.setNumberExamples(numberExamples);
        parent.matchers.put("", parent.matchMax(maxSize));
        return new PactDslJsonBody(".", "", parent);
    }

    public PactDslJsonArray nullValue() {
        this.body.put(JSONObject.NULL);
        return this;
    }

    public int getNumberExamples() {
        return this.numberExamples;
    }

    public void setNumberExamples(int numberExamples) {
        this.numberExamples = numberExamples;
    }

    @Override
    public PactDslJsonArray eachArrayLike(String name) {
        throw new UnsupportedOperationException("use the eachArrayLike() form");
    }

    @Override
    public PactDslJsonArray eachArrayLike(String name, int numberExamples) {
        throw new UnsupportedOperationException("use the eachArrayLike(numberExamples) form");
    }

    @Override
    public PactDslJsonArray eachArrayLike() {
        return this.eachArrayLike(1);
    }

    @Override
    public PactDslJsonArray eachArrayLike(int numberExamples) {
        this.matchers.put(this.rootPath + this.appendArrayIndex(1), this.matchMin(0));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonArray("", "", parent);
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(String name, Integer size) {
        throw new UnsupportedOperationException("use the eachArrayWithMaxLike() form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(String name, int numberExamples, Integer size) {
        throw new UnsupportedOperationException("use the eachArrayWithMaxLike(numberExamples) form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(Integer size) {
        return this.eachArrayWithMaxLike(1, size);
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(int numberExamples, Integer size) {
        if (numberExamples > size) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, size));
        }
        this.matchers.put(this.rootPath + this.appendArrayIndex(1), this.matchMax(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonArray("", "", parent);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(String name, Integer size) {
        throw new UnsupportedOperationException("use the eachArrayWithMinLike() form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(String name, int numberExamples, Integer size) {
        throw new UnsupportedOperationException("use the eachArrayWithMinLike(numberExamples) form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(Integer size) {
        return this.eachArrayWithMinLike(size, size);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(int numberExamples, Integer size) {
        if (numberExamples < size) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, size));
        }
        this.matchers.put(this.rootPath + this.appendArrayIndex(1), this.matchMin(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonArray("", "", parent);
    }

    public PactDslJsonArray eachLike(PactDslJsonRootValue value) {
        return this.eachLike(value, 1);
    }

    public PactDslJsonArray eachLike(PactDslJsonRootValue value, int numberExamples) {
        this.matchers.put(this.rootPath + this.appendArrayIndex(1), this.matchMin(0));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", this, true);
        parent.setNumberExamples(numberExamples);
        parent.putObject(value);
        return (PactDslJsonArray)parent.closeArray();
    }

    public PactDslJsonArray minArrayLike(Integer size, PactDslJsonRootValue value) {
        return this.minArrayLike(size, value, (int)size);
    }

    public PactDslJsonArray minArrayLike(Integer size, PactDslJsonRootValue value, int numberExamples) {
        if (numberExamples < size) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, size));
        }
        this.matchers.put(this.rootPath + this.appendArrayIndex(1), this.matchMin(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", this, true);
        parent.setNumberExamples(numberExamples);
        parent.putObject(value);
        return (PactDslJsonArray)parent.closeArray();
    }

    public PactDslJsonArray maxArrayLike(Integer size, PactDslJsonRootValue value) {
        return this.maxArrayLike(size, value, 1);
    }

    public PactDslJsonArray maxArrayLike(Integer size, PactDslJsonRootValue value, int numberExamples) {
        if (numberExamples > size) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, size));
        }
        this.matchers.put(this.rootPath + this.appendArrayIndex(1), this.matchMax(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", this, true);
        parent.setNumberExamples(numberExamples);
        parent.putObject(value);
        return (PactDslJsonArray)parent.closeArray();
    }
}

