/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslResponse;
import au.com.dius.pact.consumer.dsl.QuoteUtil;
import au.com.dius.pact.model.Consumer;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.model.Provider;
import au.com.dius.pact.model.ProviderState;
import au.com.dius.pact.model.generators.Generators;
import au.com.dius.pact.model.matchingrules.MatchingRule;
import au.com.dius.pact.model.matchingrules.MatchingRules;
import au.com.dius.pact.model.matchingrules.RegexMatcher;
import com.mifmif.common.regex.Generex;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.transform.TransformerException;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;
import org.w3c.dom.Document;

public class PactDslRequestWithPath {
    private static final String CONTENT_TYPE = "Content-Type";
    private final ConsumerPactBuilder consumerPactBuilder;
    Consumer consumer;
    Provider provider;
    List<ProviderState> state;
    String description;
    String path = "/";
    String requestMethod = "GET";
    Map<String, String> requestHeaders = new HashMap<String, String>();
    Map<String, List<String>> query = new HashMap<String, List<String>>();
    OptionalBody requestBody = OptionalBody.missing();
    MatchingRules requestMatchers = new MatchingRules();
    Generators requestGenerators = new Generators();

    PactDslRequestWithPath(ConsumerPactBuilder consumerPactBuilder, String consumerName, String providerName, List<ProviderState> state, String description2, String path, String requestMethod, Map<String, String> requestHeaders, Map<String, List<String>> query, OptionalBody requestBody, MatchingRules requestMatchers, Generators requestGenerators) {
        this.consumerPactBuilder = consumerPactBuilder;
        this.requestMatchers = requestMatchers;
        this.consumer = new Consumer(consumerName);
        this.provider = new Provider(providerName);
        this.state = state;
        this.description = description2;
        this.path = path;
        this.requestMethod = requestMethod;
        this.requestHeaders = requestHeaders;
        this.query = query;
        this.requestBody = requestBody;
        this.requestMatchers = requestMatchers;
        this.requestGenerators = requestGenerators;
    }

    PactDslRequestWithPath(ConsumerPactBuilder consumerPactBuilder, PactDslRequestWithPath existing, String description2) {
        this.consumerPactBuilder = consumerPactBuilder;
        this.consumer = existing.consumer;
        this.provider = existing.provider;
        this.state = existing.state;
        this.description = description2;
    }

    public PactDslRequestWithPath method(String method) {
        this.requestMethod = method;
        return this;
    }

    public PactDslRequestWithPath headers(String firstHeaderName, String firstHeaderValue, String ... headerNameValuePairs) {
        if (headerNameValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Pair key value should be provided, but there is one key without value.");
        }
        this.requestHeaders.put(firstHeaderName, firstHeaderValue);
        for (int i = 0; i < headerNameValuePairs.length; i += 2) {
            this.requestHeaders.put(headerNameValuePairs[i], headerNameValuePairs[i + 1]);
        }
        return this;
    }

    public PactDslRequestWithPath headers(Map<String, String> headers) {
        this.requestHeaders.putAll(headers);
        return this;
    }

    public PactDslRequestWithPath query(String query) {
        this.query = PactReader.queryStringToMap((String)query, (boolean)false);
        return this;
    }

    public PactDslRequestWithPath body(String body) {
        this.requestBody = OptionalBody.body((String)body);
        return this;
    }

    public PactDslRequestWithPath body(String body, String mimeType) {
        this.requestBody = OptionalBody.body((String)body);
        this.requestHeaders.put(CONTENT_TYPE, mimeType);
        return this;
    }

    public PactDslRequestWithPath body(String body, ContentType mimeType) {
        return this.body(body, mimeType.toString());
    }

    public PactDslRequestWithPath body(Supplier<String> body) {
        this.requestBody = OptionalBody.body((String)body.get());
        return this;
    }

    public PactDslRequestWithPath body(Supplier<String> body, String mimeType) {
        this.requestBody = OptionalBody.body((String)body.get());
        this.requestHeaders.put(CONTENT_TYPE, mimeType);
        return this;
    }

    public PactDslRequestWithPath body(Supplier<String> body, ContentType mimeType) {
        return this.body(body, mimeType.toString());
    }

    public PactDslRequestWithPath bodyWithSingleQuotes(String body) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body);
    }

    public PactDslRequestWithPath bodyWithSingleQuotes(String body, String mimeType) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body, mimeType);
    }

    public PactDslRequestWithPath bodyWithSingleQuotes(String body, ContentType mimeType) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body, mimeType);
    }

    public PactDslRequestWithPath body(JSONObject body) {
        this.requestBody = OptionalBody.body((String)body.toString());
        if (!this.requestHeaders.containsKey(CONTENT_TYPE)) {
            this.requestHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslRequestWithPath body(DslPart body) {
        DslPart parent = body.close();
        this.requestMatchers.addCategory(parent.getMatchers());
        this.requestGenerators.addGenerators(parent.generators);
        this.requestBody = OptionalBody.body((String)parent.toString());
        if (!this.requestHeaders.containsKey(CONTENT_TYPE)) {
            this.requestHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslRequestWithPath body(Document body) throws TransformerException {
        this.requestBody = OptionalBody.body((String)ConsumerPactBuilder.xmlToString(body));
        if (!this.requestHeaders.containsKey(CONTENT_TYPE)) {
            this.requestHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_XML.toString());
        }
        return this;
    }

    public PactDslRequestWithPath path(String path) {
        this.path = path;
        return this;
    }

    public PactDslRequestWithPath matchPath(String pathRegex) {
        return this.matchPath(pathRegex, new Generex(pathRegex).random());
    }

    public PactDslRequestWithPath matchPath(String pathRegex, String path) {
        this.requestMatchers.addCategory("path").addRule((MatchingRule)new RegexMatcher(pathRegex));
        this.path = path;
        return this;
    }

    public PactDslRequestWithPath matchHeader(String header, String regex) {
        return this.matchHeader(header, regex, new Generex(regex).random());
    }

    public PactDslRequestWithPath matchHeader(String header, String regex, String headerExample) {
        this.requestMatchers.addCategory("header").addRule(header, (MatchingRule)new RegexMatcher(regex));
        this.requestHeaders.put(header, headerExample);
        return this;
    }

    public PactDslResponse willRespondWith() {
        return new PactDslResponse(this.consumerPactBuilder, this);
    }

    public PactDslRequestWithPath matchQuery(String parameter, String regex) {
        return this.matchQuery(parameter, regex, new Generex(regex).random());
    }

    public PactDslRequestWithPath matchQuery(String parameter, String regex, String example) {
        this.requestMatchers.addCategory("query").addRule(parameter, (MatchingRule)new RegexMatcher(regex));
        this.query.put(parameter, Collections.singletonList(example));
        return this;
    }
}

