/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithPath;
import au.com.dius.pact.consumer.dsl.PactDslWithState;
import au.com.dius.pact.consumer.dsl.QuoteUtil;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.model.generators.Generators;
import au.com.dius.pact.model.matchingrules.MatchingRule;
import au.com.dius.pact.model.matchingrules.MatchingRules;
import au.com.dius.pact.model.matchingrules.RegexMatcher;
import com.mifmif.common.regex.Generex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.transform.TransformerException;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;
import org.w3c.dom.Document;

public class PactDslRequestWithoutPath {
    private static final String CONTENT_TYPE = "Content-Type";
    private final ConsumerPactBuilder consumerPactBuilder;
    private PactDslWithState pactDslWithState;
    private String description;
    private String requestMethod;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private Map<String, List<String>> query = new HashMap<String, List<String>>();
    private OptionalBody requestBody = OptionalBody.missing();
    private MatchingRules requestMatchers = new MatchingRules();
    private Generators requestGenerators = new Generators();
    private String consumerName;
    private String providerName;

    public PactDslRequestWithoutPath(ConsumerPactBuilder consumerPactBuilder, PactDslWithState pactDslWithState, String description2) {
        this.consumerPactBuilder = consumerPactBuilder;
        this.pactDslWithState = pactDslWithState;
        this.description = description2;
        this.consumerName = pactDslWithState.consumerName;
        this.providerName = pactDslWithState.providerName;
    }

    public PactDslRequestWithoutPath method(String method) {
        this.requestMethod = method;
        return this;
    }

    public PactDslRequestWithoutPath headers(Map<String, String> headers) {
        this.requestHeaders = new HashMap<String, String>(headers);
        return this;
    }

    public PactDslRequestWithoutPath headers(String firstHeaderName, String firstHeaderValue, String ... headerNameValuePairs) {
        if (headerNameValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Pair key value should be provided, but there is one key without value.");
        }
        this.requestHeaders.put(firstHeaderName, firstHeaderValue);
        for (int i = 0; i < headerNameValuePairs.length; i += 2) {
            this.requestHeaders.put(headerNameValuePairs[i], headerNameValuePairs[i + 1]);
        }
        return this;
    }

    public PactDslRequestWithoutPath query(String query) {
        this.query = PactReader.queryStringToMap((String)query, (boolean)false);
        return this;
    }

    public PactDslRequestWithoutPath body(String body) {
        this.requestBody = OptionalBody.body((String)body);
        return this;
    }

    public PactDslRequestWithoutPath body(String body, String mimeType) {
        this.requestBody = OptionalBody.body((String)body);
        this.requestHeaders.put(CONTENT_TYPE, mimeType);
        return this;
    }

    public PactDslRequestWithoutPath body(String body, ContentType mimeType) {
        return this.body(body, mimeType.toString());
    }

    public PactDslRequestWithoutPath body(Supplier<String> body) {
        this.requestBody = OptionalBody.body((String)body.get());
        return this;
    }

    public PactDslRequestWithoutPath body(Supplier<String> body, String mimeType) {
        this.requestBody = OptionalBody.body((String)body.get());
        this.requestHeaders.put(CONTENT_TYPE, mimeType);
        return this;
    }

    public PactDslRequestWithoutPath body(Supplier<String> body, ContentType mimeType) {
        return this.body(body, mimeType.toString());
    }

    public PactDslRequestWithoutPath bodyWithSingleQuotes(String body) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body);
    }

    public PactDslRequestWithoutPath bodyWithSingleQuotes(String body, String mimeType) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body, mimeType);
    }

    public PactDslRequestWithoutPath bodyWithSingleQuotes(String body, ContentType mimeType) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body, mimeType);
    }

    public PactDslRequestWithoutPath body(JSONObject body) {
        this.requestBody = OptionalBody.body((String)body.toString());
        if (!this.requestHeaders.containsKey(CONTENT_TYPE)) {
            this.requestHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslRequestWithoutPath body(DslPart body) {
        DslPart parent = body.close();
        this.requestMatchers.addCategory(parent.matchers);
        this.requestGenerators.addGenerators(parent.generators);
        this.requestBody = OptionalBody.body((String)parent.toString());
        if (!this.requestHeaders.containsKey(CONTENT_TYPE)) {
            this.requestHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslRequestWithoutPath body(Document body) throws TransformerException {
        this.requestBody = OptionalBody.body((String)ConsumerPactBuilder.xmlToString(body));
        if (!this.requestHeaders.containsKey(CONTENT_TYPE)) {
            this.requestHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_XML.toString());
        }
        return this;
    }

    public PactDslRequestWithPath path(String path) {
        return new PactDslRequestWithPath(this.consumerPactBuilder, this.consumerName, this.providerName, this.pactDslWithState.state, this.description, path, this.requestMethod, this.requestHeaders, this.query, this.requestBody, this.requestMatchers, this.requestGenerators);
    }

    public PactDslRequestWithPath matchPath(String pathRegex) {
        return this.matchPath(pathRegex, new Generex(pathRegex).random());
    }

    public PactDslRequestWithPath matchPath(String pathRegex, String path) {
        this.requestMatchers.addCategory("path").addRule((MatchingRule)new RegexMatcher(pathRegex));
        return new PactDslRequestWithPath(this.consumerPactBuilder, this.consumerName, this.providerName, this.pactDslWithState.state, this.description, path, this.requestMethod, this.requestHeaders, this.query, this.requestBody, this.requestMatchers, this.requestGenerators);
    }
}

