/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.model.Consumer;
import au.com.dius.pact.model.InvalidPactException;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.Provider;
import au.com.dius.pact.model.ProviderState;
import au.com.dius.pact.model.v3.messaging.Message;
import au.com.dius.pact.model.v3.messaging.MessagePact;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class MessagePactBuilder {
    private static final String CONTENT_TYPE = "Content-Type";
    private Consumer consumer;
    private Provider provider;
    private List<ProviderState> providerStates = new ArrayList<ProviderState>();
    private List<Message> messages;

    private MessagePactBuilder(String consumer) {
        this.consumer = new Consumer(consumer);
    }

    public static MessagePactBuilder consumer(String consumer) {
        return new MessagePactBuilder(consumer);
    }

    public MessagePactBuilder hasPactWith(String provider) {
        this.provider = new Provider(provider);
        return this;
    }

    public MessagePactBuilder given(String providerState) {
        this.providerStates.add(new ProviderState(providerState));
        return this;
    }

    public MessagePactBuilder expectsToReceive(String description) {
        Message message = new Message(description, this.providerStates);
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        this.messages.add(message);
        return this;
    }

    public MessagePactBuilder withMetadata(Map<String, String> metadata) {
        if (this.messages == null || this.messages.isEmpty()) {
            throw new InvalidPactException("expectsToReceive is required before withMetaData");
        }
        this.messages.get(this.messages.size() - 1).setMetaData(metadata);
        return this;
    }

    public MessagePactBuilder withContent(DslPart body) {
        if (this.messages == null || this.messages.isEmpty()) {
            throw new InvalidPactException("expectsToReceive is required before withMetaData");
        }
        Message message = this.messages.get(this.messages.size() - 1);
        HashMap<String, String> metadata = message.getMetaData();
        if (metadata == null) {
            metadata = new HashMap<String, String>(1);
            metadata.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        } else if (!metadata.containsKey(CONTENT_TYPE)) {
            metadata.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        }
        DslPart parent = body.close();
        message.setContents(OptionalBody.body((byte[])parent.toString().getBytes()));
        message.getMatchingRules().addCategory(parent.getMatchers());
        return this;
    }

    public MessagePact toPact() {
        return new MessagePact(this.provider, this.consumer, this.messages);
    }
}

