/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.model;

import au.com.dius.pact.model.BrokerUrlSource;
import au.com.dius.pact.model.ClosurePactSource;
import au.com.dius.pact.model.Consumer;
import au.com.dius.pact.model.FileSource;
import au.com.dius.pact.model.InputStreamPactSource;
import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactReaderKt;
import au.com.dius.pact.model.PactSource;
import au.com.dius.pact.model.Provider;
import au.com.dius.pact.model.ProviderState;
import au.com.dius.pact.model.ReaderPactSource;
import au.com.dius.pact.model.Request;
import au.com.dius.pact.model.RequestResponseInteraction;
import au.com.dius.pact.model.RequestResponsePact;
import au.com.dius.pact.model.Response;
import au.com.dius.pact.model.S3PactSource;
import au.com.dius.pact.model.UnknownPactSource;
import au.com.dius.pact.model.UrlPactSource;
import au.com.dius.pact.model.UrlSource;
import au.com.dius.pact.model.v3.messaging.MessagePact;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3URI;
import com.github.zafarkhaja.semver.Version;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v7.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactReader
implements GroovyObject {
    private static final String CLASSPATH_URI_START = "classpath:";
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public PactReader() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Pact<? extends Interaction> loadPact(Map options, Object source) {
        CallSite pactInfo = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadFile", 0, PactReader.class, source, options));
        Object version = "2.0.0";
        CallSite metadata = IndyInterface.bootstrap("getProperty", "metadata", 0, IndyInterface.bootstrap("getProperty", "first", 0, pactInfo));
        CallSite callSite = IndyInterface.bootstrap("getProperty", "pactSpecification", 1, metadata);
        CallSite specification = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("getProperty", "pact-specification", 1, metadata);
        if (specification instanceof Map && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "version", 0, specification))) {
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "version", 0, specification);
            version = callSite2;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)version, (Object)"3.0")) {
            String string = "3.0.0";
            version = string;
        }
        CallSite specVersion = IndyInterface.bootstrap("invoke", "valueOf", 0, Version.class, version);
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "majorVersion", 0, specVersion);
        if (ScriptBytecodeAdapter.isCase((Object)callSite3, (Object)3)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadV3Pact", 0, PactReader.class, IndyInterface.bootstrap("getProperty", "second", 0, pactInfo), IndyInterface.bootstrap("getProperty", "first", 0, pactInfo)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadV2Pact", 0, PactReader.class, IndyInterface.bootstrap("getProperty", "second", 0, pactInfo), IndyInterface.bootstrap("getProperty", "first", 0, pactInfo)));
    }

    public static Pact<? extends Interaction> loadV3Pact(Object source, Object pactJson) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "messages", 0, pactJson)) != false) {
            CallSite pact = IndyInterface.bootstrap("invoke", "fromMap", 0, MessagePact.class, pactJson);
            Object object = source;
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)pact, (String)"source");
            return IndyInterface.bootstrap("cast", "()", 0, pact);
        }
        CallSite transformedJson = IndyInterface.bootstrap("invoke", "transformJson", 0, PactReader.class, pactJson);
        CallSite provider = IndyInterface.bootstrap("invoke", "fromMap", 0, Provider.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "provider", 0, transformedJson), Map.class))), Map.class));
        CallSite consumer = IndyInterface.bootstrap("invoke", "fromMap", 0, Consumer.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "consumer", 0, transformedJson), Map.class))), Map.class));
        public class _loadV3Pact_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadV3Pact_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object i) {
                CallSite request = IndyInterface.bootstrap("invoke", "extractRequest", 2, this, IndyInterface.bootstrap("getProperty", "request", 0, i));
                CallSite response = IndyInterface.bootstrap("invoke", "extractResponse", 2, this, IndyInterface.bootstrap("getProperty", "response", 0, i));
                Object providerStates = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "providerStates", 0, i)) != false) {
                    public class _closure6
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure6(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "fromMap", 0, ProviderState.class, it);
                        }

                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure6.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    CallSite callSite = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "providerStates", 0, i), new _closure6((Object)this, this.getThisObject()));
                    providerStates = callSite;
                } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "providerState", 0, i)) != false) {
                    IndyInterface.bootstrap("invoke", "leftShift", 0, providerStates, IndyInterface.bootstrap("init", "<init>", 0, ProviderState.class, IndyInterface.bootstrap("getProperty", "providerState", 0, i)));
                }
                return IndyInterface.bootstrap("init", "<init>", 0, RequestResponseInteraction.class, IndyInterface.bootstrap("getProperty", "description", 0, i), providerStates, request, response);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadV3Pact_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        CallSite interactions = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "interactions", 0, transformedJson), new _loadV3Pact_closure1(PactReader.class, PactReader.class));
        CallSite pact = IndyInterface.bootstrap("init", "<init>", 0, RequestResponsePact.class, provider, consumer, interactions);
        Object object = source;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)pact, (String)"source");
        return IndyInterface.bootstrap("cast", "()", 0, pact);
    }

    public static Pact<? extends Interaction> loadV2Pact(Object source, Object pactJson) {
        CallSite transformedJson = IndyInterface.bootstrap("invoke", "transformJson", 0, PactReader.class, pactJson);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "provider", 0, transformedJson);
        CallSite provider = IndyInterface.bootstrap("invoke", "fromMap", 0, Provider.class, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "consumer", 0, transformedJson);
        CallSite consumer = IndyInterface.bootstrap("invoke", "fromMap", 0, Consumer.class, IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        public class _loadV2Pact_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadV2Pact_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object i) {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "request", 0, i);
                CallSite request = IndyInterface.bootstrap("invoke", "extractRequest", 2, this, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "response", 0, i);
                CallSite response = IndyInterface.bootstrap("invoke", "extractResponse", 2, this, IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                return IndyInterface.bootstrap("init", "<init>", 0, RequestResponseInteraction.class, IndyInterface.bootstrap("getProperty", "description", 0, i), IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "providerState", 0, i)) != false ? ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("init", "<init>", 0, ProviderState.class, IndyInterface.bootstrap("getProperty", "providerState", 0, i))}) : ScriptBytecodeAdapter.createList((Object[])new Object[0]), request, response);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadV2Pact_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        CallSite interactions = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "interactions", 0, transformedJson), new _loadV2Pact_closure2(PactReader.class, PactReader.class));
        CallSite pact = IndyInterface.bootstrap("init", "<init>", 0, RequestResponsePact.class, provider, consumer, interactions);
        Object object = source;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)pact, (String)"source");
        return IndyInterface.bootstrap("cast", "()", 0, pact);
    }

    public static Response extractResponse(Object responseJson) {
        IndyInterface.bootstrap("invoke", "extractBody", 0, PactReader.class, responseJson);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fromMap", 0, Response.class, responseJson));
    }

    public static Request extractRequest(Object requestJson) {
        IndyInterface.bootstrap("invoke", "extractBody", 0, PactReader.class, requestJson);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fromMap", 0, Request.class, requestJson));
    }

    public static void extractBody(Object json) {
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsKey", 0, json, "body")) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "body", 0, json), null) && !(IndyInterface.bootstrap("getProperty", "body", 0, json) instanceof String)) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "toJson", 0, JsonOutput.class, IndyInterface.bootstrap("getProperty", "body", 0, json));
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)json, (String)"body");
        }
    }

    public static Object transformJson(Object pactJson) {
        public class _transformJson_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _transformJson_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object i) {
                public class _closure7
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure7(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object k, Object v) {
                        List entry;
                        block1: {
                            List list;
                            Object object;
                            block2: {
                                List list2;
                                block0: {
                                    List list3;
                                    entry = ScriptBytecodeAdapter.createList((Object[])new Object[]{k, v});
                                    object = k;
                                    if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"provider_state")) break block0;
                                    entry = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"providerState", v});
                                    break block1;
                                }
                                if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"request")) break block2;
                                entry = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"request", IndyInterface.bootstrap("invoke", "transformRequestResponseJson", 2, this, v)});
                                break block1;
                            }
                            if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"response")) break block1;
                            entry = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"response", IndyInterface.bootstrap("invoke", "transformRequestResponseJson", 2, this, v)});
                        }
                        return entry;
                    }

                    public Object call(Object k, Object v) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                CallSite interaction = IndyInterface.bootstrap("invoke", "collectEntries", 0, i, new _closure7((Object)this, this.getThisObject()));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "providerState", 0, i)) != false) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "providerState", 0, i);
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)interaction, (String)"providerState");
                }
                return interaction;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _transformJson_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "interactions", 0, pactJson), new _transformJson_closure3(PactReader.class, PactReader.class));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)pactJson, (String)"interactions");
        return pactJson;
    }

    public static Object transformRequestResponseJson(Object requestJson) {
        public class _transformRequestResponseJson_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _transformRequestResponseJson_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                List entry;
                block1: {
                    List list;
                    Object object;
                    block2: {
                        List list2;
                        block0: {
                            List list3;
                            entry = ScriptBytecodeAdapter.createList((Object[])new Object[]{k, v});
                            object = k;
                            if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"responseMatchingRules")) break block0;
                            entry = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"matchingRules", v});
                            break block1;
                        }
                        if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"requestMatchingRules")) break block2;
                        entry = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"matchingRules", v});
                        break block1;
                    }
                    if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"method")) break block1;
                    entry = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"method", IndyInterface.bootstrap("cast", "()", 0, v) != false ? IndyInterface.bootstrap("invoke", "toUpperCase", 0, IndyInterface.bootstrap("invoke", "toString", 0, v)) : v});
                }
                return entry;
            }

            public Object call(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _transformRequestResponseJson_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("invoke", "collectEntries", 0, requestJson, new _transformRequestResponseJson_closure4(PactReader.class, PactReader.class));
    }

    private static Pair<Object, PactSource> loadFile(Object source, Map options) {
        if (source instanceof ClosurePactSource) {
            return PactReader.loadFile(((ClosurePactSource)source).getClosure().get(), options);
        }
        if (source instanceof FileSource) {
            return new Pair(new JsonSlurper().parse(((FileSource)source).getFile()), source);
        }
        if (source instanceof InputStream || source instanceof Reader || source instanceof File) {
            return PactReader.loadPactFromFile(source);
        }
        if (source instanceof BrokerUrlSource) {
            return PactReaderKt.loadPactFromUrl((UrlPactSource)((Object)IndyInterface.bootstrap("cast", "()", 0, source)), options, null);
        }
        if (source instanceof URL || source instanceof UrlPactSource) {
            UrlPactSource urlSource = source instanceof URL ? new UrlSource(DefaultGroovyMethods.toString((Object)source)) : (UrlPactSource)((Object)IndyInterface.bootstrap("invoke", "asType", 0, source, UrlPactSource.class));
            return PactReaderKt.loadPactFromUrl(urlSource, options, PactReaderKt.newHttpClient(urlSource.getUrl(), options));
        }
        if (source instanceof String && ScriptBytecodeAdapter.matchRegex((Object)((String)source).toLowerCase(), (Object)"(https?|file)://?.*")) {
            UrlSource urlSource = new UrlSource((String)((Object)IndyInterface.bootstrap("cast", "()", 0, source)));
            return PactReaderKt.loadPactFromUrl(urlSource, options, PactReaderKt.newHttpClient(urlSource.getUrl(), options));
        }
        if (source instanceof String && ScriptBytecodeAdapter.matchRegex((Object)((String)source).toLowerCase(), (Object)"s3://.*")) {
            return PactReader.loadPactFromS3Bucket((String)((Object)IndyInterface.bootstrap("cast", "()", 0, source)), options);
        }
        if (source instanceof String && ((String)source).startsWith(CLASSPATH_URI_START)) {
            return PactReader.loadPactFromClasspath(StringGroovyMethods.minus((CharSequence)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, source, String.class))), (Object)CLASSPATH_URI_START));
        }
        if (source instanceof String && PactReader.fileExists((String)((Object)IndyInterface.bootstrap("cast", "()", 0, source)))) {
            File file = (File)((Object)IndyInterface.bootstrap("invoke", "asType", 0, source, File.class));
            return new Pair(new JsonSlurper().parse(file), new FileSource(file));
        }
        Pair pair = new Pair(new JsonSlurper().parseText(DefaultGroovyMethods.toString((Object)source)), (Object)UnknownPactSource.INSTANCE);
        try {
            return pair;
        }
        catch (Exception e) {
            throw (Throwable)new UnsupportedOperationException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{source}, new String[]{"Unable to load pact file from '", "' as it is neither a json document, file, input stream, "}).plus("reader or an URL"))), (Throwable)((Object)IndyInterface.bootstrap("cast", "()", 0, e)));
        }
    }

    public static Pair<Object, PactSource> loadPactFromFile(Object source) {
        CallSite pactData = IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, JsonSlurper.class), source);
        if (source instanceof InputStream) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Pair.class, pactData, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, InputStreamPactSource.class)));
        }
        if (source instanceof Reader) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Pair.class, pactData, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ReaderPactSource.class)));
        }
        if (source instanceof File) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Pair.class, pactData, IndyInterface.bootstrap("init", "<init>", 0, FileSource.class, source)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Pair.class, pactData, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, UnknownPactSource.class)));
    }

    private static Pair<Object, PactSource> loadPactFromS3Bucket(String source, Map options) {
        CallSite s3Uri = IndyInterface.bootstrap("init", "<init>", 0, AmazonS3URI.class, source);
        CallSite client = IndyInterface.bootstrap("invoke", "s3Client", 0, PactReader.class);
        CallSite s3Pact = IndyInterface.bootstrap("invoke", "getObject", 0, client, IndyInterface.bootstrap("getProperty", "bucket", 0, s3Uri), IndyInterface.bootstrap("getProperty", "key", 0, s3Uri));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Pair.class, IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, JsonSlurper.class), IndyInterface.bootstrap("getProperty", "objectContent", 0, s3Pact)), IndyInterface.bootstrap("init", "<init>", 0, S3PactSource.class, source)));
    }

    private static Pair<Object, PactSource> loadPactFromClasspath(String source) {
        CallSite inputStream = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "contextClassLoader", 0, IndyInterface.bootstrap("invoke", "currentThread", 0, Thread.class)), source));
        if (ScriptBytecodeAdapter.compareEqual((Object)inputStream, null)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{source}, new String[]{"not found on classpath: ", ""})));
        }
        public class _loadPactFromClasspath_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadPactFromClasspath_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "loadPactFromFile", 2, this, it);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadPactFromClasspath_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withCloseable", 0, inputStream, new _loadPactFromClasspath_closure5(PactReader.class, PactReader.class)));
    }

    private static boolean fileExists(String path) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "exists", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, path)));
    }

    private static Object s3Client() {
        return IndyInterface.bootstrap("init", "<init>", 0, AmazonS3Client.class);
    }

    public static Pact<? extends Interaction> loadPact(Object source) {
        return PactReader.loadPact(ScriptBytecodeAdapter.createMap((Object[])new Object[0]), source);
    }

    private static Pair<Object, PactSource> loadFile(Object source) {
        return PactReader.loadFile(source, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PactReader.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "au.com.dius.pact.model.PactReader");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

