/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.model;

import au.com.dius.pact.model.Consumer;
import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.Provider;
import au.com.dius.pact.model.Request;
import au.com.dius.pact.model.RequestResponseInteraction;
import au.com.dius.pact.model.RequestResponsePact;
import au.com.dius.pact.model.Response;
import au.com.dius.pact.model.v3.messaging.MessagePact;
import com.github.zafarkhaja.semver.Version;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovyx.net.http.RESTClient;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v7.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactReader
implements GroovyObject {
    private static final String JSON = "application/json";
    private static final Map ACCEPT_JSON;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public PactReader() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Pact loadPact(Map options, Object source) {
        CallSite pact = IndyInterface.bootstrap("invoke", "loadFile", 0, PactReader.class, source, options);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "version", 1, IndyInterface.bootstrap("getProperty", "pact-specification", 1, IndyInterface.bootstrap("getProperty", "metadata", 0, pact)));
        Object version = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "2.0.0";
        if (ScriptBytecodeAdapter.compareEqual((Object)version, (Object)"3.0")) {
            String string = "3.0.0";
            version = string;
        }
        CallSite specVersion = IndyInterface.bootstrap("invoke", "valueOf", 0, Version.class, version);
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "majorVersion", 0, specVersion);
        if (ScriptBytecodeAdapter.isCase((Object)callSite2, (Object)3)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadV3Pact", 0, PactReader.class, source, pact));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadV2Pact", 0, PactReader.class, source, pact));
    }

    public static Pact loadV3Pact(Object source, Object pactJson) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "messages", 0, pactJson)) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fromMap", 0, MessagePact.class, pactJson));
        }
        CallSite transformedJson = IndyInterface.bootstrap("invoke", "transformJson", 0, PactReader.class, pactJson);
        Provider provider = (Provider)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "provider", 0, transformedJson), Provider.class));
        Consumer consumer = (Consumer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "consumer", 0, transformedJson), Consumer.class));
        public class _loadV3Pact_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadV3Pact_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object i) {
                CallSite request = IndyInterface.bootstrap("invoke", "extractRequestV3", 2, this, IndyInterface.bootstrap("getProperty", "request", 0, i));
                CallSite response = IndyInterface.bootstrap("invoke", "extractResponse", 2, this, IndyInterface.bootstrap("getProperty", "response", 0, i));
                return IndyInterface.bootstrap("init", "<init>", 0, RequestResponseInteraction.class, IndyInterface.bootstrap("getProperty", "description", 0, i), IndyInterface.bootstrap("getProperty", "providerState", 0, i), request, response);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadV3Pact_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        CallSite interactions = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "interactions", 0, transformedJson), new _loadV3Pact_closure1(PactReader.class, PactReader.class));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, RequestResponsePact.class, provider, consumer, interactions));
    }

    public static Pact loadV2Pact(Object source, Object pactJson) {
        CallSite transformedJson = IndyInterface.bootstrap("invoke", "transformJson", 0, PactReader.class, pactJson);
        Provider provider = (Provider)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "provider", 0, transformedJson), Provider.class));
        Consumer consumer = (Consumer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "consumer", 0, transformedJson), Consumer.class));
        public class _loadV2Pact_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadV2Pact_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object i) {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "request", 0, i);
                CallSite request = IndyInterface.bootstrap("invoke", "extractRequestV2", 2, this, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "response", 0, i);
                CallSite response = IndyInterface.bootstrap("invoke", "extractResponse", 2, this, IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                return IndyInterface.bootstrap("init", "<init>", 0, RequestResponseInteraction.class, IndyInterface.bootstrap("getProperty", "description", 0, i), IndyInterface.bootstrap("getProperty", "providerState", 0, i), request, response);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadV2Pact_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        CallSite interactions = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "interactions", 0, transformedJson), new _loadV2Pact_closure2(PactReader.class, PactReader.class));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, RequestResponsePact.class, provider, consumer, interactions));
    }

    public static Response extractResponse(Object responseJson) {
        IndyInterface.bootstrap("invoke", "extractBody", 0, PactReader.class, responseJson);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fromMap", 0, Response.class, responseJson));
    }

    public static Request extractRequestV2(Object requestJson) {
        IndyInterface.bootstrap("invoke", "extractBody", 0, PactReader.class, requestJson);
        CallSite callSite = IndyInterface.bootstrap("invoke", "queryStringToMap", 0, PactReader.class, IndyInterface.bootstrap("getProperty", "query", 0, requestJson));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)requestJson, (String)"query");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fromMap", 0, Request.class, requestJson));
    }

    public static Map<String, List<String>> queryStringToMap(String query, boolean decode) {
        Reference decode2 = new Reference((Object)decode);
        if (IndyInterface.bootstrap("cast", "()", 0, query) != false) {
            public class _queryStringToMap_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference decode;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _queryStringToMap_closure3(Object _outerInstance, Object _thisObject, Reference decode) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.decode = reference = decode;
                }

                public Object doCall(Map map, String ... nameAndValue) {
                    CallSite name = IndyInterface.bootstrap("cast", "()", 0, this.decode.get()) != false ? IndyInterface.bootstrap("invoke", "decode", 0, URLDecoder.class, IndyInterface.bootstrap("invoke", "first", 0, nameAndValue), "UTF-8") : IndyInterface.bootstrap("invoke", "first", 0, nameAndValue);
                    CallSite value = IndyInterface.bootstrap("cast", "()", 0, this.decode.get()) != false ? IndyInterface.bootstrap("invoke", "decode", 0, URLDecoder.class, IndyInterface.bootstrap("invoke", "last", 0, nameAndValue), "UTF-8") : IndyInterface.bootstrap("invoke", "last", 0, nameAndValue);
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, map, name)) != false) {
                        IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("invoke", "getAt", 0, map, name), value);
                    } else {
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{value});
                        IndyInterface.bootstrap("invoke", "putAt", 0, map, name, list);
                    }
                    return map;
                }

                public Object call(Map map, String ... nameAndValue) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, map, nameAndValue);
                }

                public boolean getDecode() {
                    return DefaultTypeTransformation.booleanUnbox((Object)this.decode.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _queryStringToMap_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "inject", 0, ScriptBytecodeAdapter.invokeMethodNSpreadSafe(PactReader.class, (Object)IndyInterface.bootstrap("invoke", "split", 0, query, "&"), (String)"split", (Object[])new Object[]{"=", 2}), ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _queryStringToMap_closure3(PactReader.class, PactReader.class, decode2)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public static Request extractRequestV3(Object requestJson) {
        IndyInterface.bootstrap("invoke", "extractBody", 0, PactReader.class, requestJson);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fromMap", 0, Request.class, requestJson));
    }

    public static void extractBody(Object json) {
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsKey", 0, json, "body")) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "body", 0, json), null) && !(IndyInterface.bootstrap("getProperty", "body", 0, json) instanceof String)) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "toJson", 0, JsonOutput.class, IndyInterface.bootstrap("getProperty", "body", 0, json));
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)json, (String)"body");
        }
    }

    public static Object transformJson(Object pactJson) {
        public class _transformJson_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _transformJson_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                List entry;
                block1: {
                    List list;
                    Object object;
                    block2: {
                        List list2;
                        block0: {
                            List list3;
                            entry = ScriptBytecodeAdapter.createList((Object[])new Object[]{k, v});
                            object = k;
                            if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"provider_state")) break block0;
                            entry = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"providerState", v});
                            break block1;
                        }
                        if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"request")) break block2;
                        entry = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"request", IndyInterface.bootstrap("invoke", "transformRequestResponseJson", 2, this, v)});
                        break block1;
                    }
                    if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"response")) break block1;
                    entry = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"response", IndyInterface.bootstrap("invoke", "transformRequestResponseJson", 2, this, v)});
                }
                return entry;
            }

            public Object call(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _transformJson_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Object object = ScriptBytecodeAdapter.invokeMethodNSpreadSafe(PactReader.class, (Object)IndyInterface.bootstrap("getProperty", "interactions", 0, pactJson), (String)"collectEntries", (Object[])new Object[]{new _transformJson_closure4(PactReader.class, PactReader.class)});
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)pactJson, (String)"interactions");
        return pactJson;
    }

    public static Object transformRequestResponseJson(Object requestJson) {
        public class _transformRequestResponseJson_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _transformRequestResponseJson_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                List entry;
                block1: {
                    List list;
                    Object object;
                    block2: {
                        List list2;
                        block0: {
                            List list3;
                            entry = ScriptBytecodeAdapter.createList((Object[])new Object[]{k, v});
                            object = k;
                            if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"responseMatchingRules")) break block0;
                            entry = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"matchingRules", v});
                            break block1;
                        }
                        if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"requestMatchingRules")) break block2;
                        entry = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"matchingRules", v});
                        break block1;
                    }
                    if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"method")) break block1;
                    entry = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"method", IndyInterface.bootstrap("cast", "()", 0, v) != false ? IndyInterface.bootstrap("invoke", "toUpperCase", 0, IndyInterface.bootstrap("invoke", "toString", 0, v)) : v});
                }
                return entry;
            }

            public Object call(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _transformRequestResponseJson_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("invoke", "collectEntries", 0, requestJson, new _transformRequestResponseJson_closure5(PactReader.class, PactReader.class));
    }

    private static Object loadFile(Object source, Map options) {
        if (source instanceof InputStream || source instanceof Reader || source instanceof File) {
            return IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, JsonSlurper.class), source);
        }
        if (source instanceof URL) {
            return IndyInterface.bootstrap("invoke", "loadPactFromUrl", 0, PactReader.class, source, options);
        }
        if (source instanceof String && ScriptBytecodeAdapter.matchRegex((Object)source, (Object)"(https?|file)://.*")) {
            return IndyInterface.bootstrap("invoke", "loadPactFromUrl", 0, PactReader.class, IndyInterface.bootstrap("init", "<init>", 0, URL.class, source), options);
        }
        if (source instanceof String && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "fileExists", 0, PactReader.class, source))) {
            return IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, JsonSlurper.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((File)((Object)IndyInterface.bootstrap("invoke", "asType", 0, source, File.class))), File.class));
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "parseText", 0, IndyInterface.bootstrap("init", "<init>", 0, JsonSlurper.class), source);
        try {
            return callSite;
        }
        catch (Exception e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, UnsupportedOperationException.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{source}, new String[]{"Unable to load pact file from '", "' as it is neither a json document, file, input stream, "}), "reader or an URL"), e));
        }
    }

    private static Object loadPactFromUrl(URL source, Map options) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "authentication", 0, options)) != false) {
            CallSite http = IndyInterface.bootstrap("invoke", "newHttpClient", 0, PactReader.class, source);
            CallSite callSite = IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("invoke", "first", 0, IndyInterface.bootstrap("getProperty", "authentication", 0, options)));
            if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"basic")) {
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "authentication", 0, options)), (Object)2)) {
                    IndyInterface.bootstrap("invoke", "basic", 0, IndyInterface.bootstrap("getProperty", "auth", 0, http), IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "authentication", 0, options), true)), IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "authentication", 0, options), 2)));
                } else {
                    IndyInterface.bootstrap("invoke", "warn", 0, log, "Basic authentication requires a username and password, ignoring.");
                }
            }
            return IndyInterface.bootstrap("getProperty", "data", 0, IndyInterface.bootstrap("invoke", "get", 0, http, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"headers", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Accept", JSON})})));
        }
        return IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, JsonSlurper.class), source, ACCEPT_JSON);
    }

    private static Object newHttpClient(URL source) {
        return IndyInterface.bootstrap("init", "<init>", 0, RESTClient.class, source);
    }

    private static boolean fileExists(String path) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "exists", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, path)));
    }

    public static Pact loadPact(Object source) {
        return PactReader.loadPact(ScriptBytecodeAdapter.createMap((Object[])new Object[0]), source);
    }

    public static Map<String, List<String>> queryStringToMap(String query) {
        return PactReader.queryStringToMap(query, true);
    }

    private static Object loadFile(Object source) {
        return PactReader.loadFile(source, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PactReader.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Map map;
        ACCEPT_JSON = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"requestProperties", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Accept", JSON})});
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "au.com.dius.pact.model.PactReader");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

