/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit5;

import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.ProviderState;
import au.com.dius.pact.provider.DefaultVerificationReporter;
import au.com.dius.pact.provider.VerificationReporter;
import au.com.dius.pact.provider.junit5.TestResultAccumulator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\r\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0010J\u0014\u0010\u0014\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0006\u0010\u0015\u001a\u00020\u0016J$\u0010\u0017\u001a\u00020\u00182\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0006R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lau/com/dius/pact/provider/junit5/TestResultAccumulator;", "Lmu/KLogging;", "()V", "testResults", "", "", "", "verificationReporter", "Lau/com/dius/pact/provider/VerificationReporter;", "getVerificationReporter", "()Lau/com/dius/pact/provider/VerificationReporter;", "setVerificationReporter", "(Lau/com/dius/pact/provider/VerificationReporter;)V", "allInteractionsVerified", "pact", "Lau/com/dius/pact/model/Pact;", "Lau/com/dius/pact/model/Interaction;", "results", "calculateInteractionHash", "interaction", "calculatePactHash", "lookupProviderVersion", "", "updateTestResult", "", "testExecutionResult", "pact-jvm-provider-junit5_2.12"})
public final class TestResultAccumulator
extends KLogging {
    private static final Map<Integer, Map<Integer, Boolean>> testResults;
    @NotNull
    private static VerificationReporter verificationReporter;
    public static final TestResultAccumulator INSTANCE;

    @NotNull
    public final VerificationReporter getVerificationReporter() {
        return verificationReporter;
    }

    public final void setVerificationReporter(@NotNull VerificationReporter verificationReporter) {
        Intrinsics.checkParameterIsNotNull((Object)verificationReporter, (String)"<set-?>");
        TestResultAccumulator.verificationReporter = verificationReporter;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTestResult(@NotNull Pact<Interaction> pact, @NotNull Interaction interaction, boolean testExecutionResult) {
        Object object;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        this.getLogger().debug((Function0)new Function0<String>(testExecutionResult, pact, interaction){
            final /* synthetic */ boolean $testExecutionResult;
            final /* synthetic */ Pact $pact;
            final /* synthetic */ Interaction $interaction;

            @NotNull
            public final String invoke() {
                return "Received test result '" + this.$testExecutionResult + "' for Pact " + this.$pact.getProvider().getName() + '-' + this.$pact.getConsumer().getName() + ' ' + "and " + this.$interaction.getDescription();
            }
            {
                this.$testExecutionResult = bl;
                this.$pact = pact;
                this.$interaction = interaction;
                super(0);
            }
        });
        int pactHash = this.calculatePactHash(pact);
        Map<Integer, Map<Integer, Boolean>> map = testResults;
        Integer key$iv = pactHash;
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Map interactionResults = (Map)object;
        int interactionHash = this.calculateInteractionHash(interaction);
        Map map2 = interactionResults;
        Integer n = interactionHash;
        Boolean bl = testExecutionResult;
        map2.put(n, bl);
        if (this.allInteractionsVerified(pact, interactionResults)) {
            this.getLogger().debug((Function0)new Function0<String>(pact){
                final /* synthetic */ Pact $pact;

                @NotNull
                public final String invoke() {
                    return "All interactions for Pact " + this.$pact.getProvider().getName() + '-' + this.$pact.getConsumer().getName() + " are verified";
                }
                {
                    this.$pact = pact;
                    super(0);
                }
            });
            if (verificationReporter.publishingResultsDisabled()) {
                this.getLogger().warn((Function0)updateTestResult.3.INSTANCE);
            } else {
                VerificationReporter.DefaultImpls.reportResults$default((VerificationReporter)verificationReporter, pact, (boolean)true, (String)this.lookupProviderVersion(), null, (int)8, null);
            }
        }
    }

    public final int calculateInteractionHash(@NotNull Interaction interaction) {
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        HashCodeBuilder builder = new HashCodeBuilder().append((Object)interaction.getDescription());
        Iterable $receiver$iv = interaction.getProviderStates();
        for (Object element$iv : $receiver$iv) {
            ProviderState it = (ProviderState)element$iv;
            boolean bl = false;
            builder.append((Object)it.getName());
        }
        return builder.toHashCode();
    }

    public final int calculatePactHash(@NotNull Pact<Interaction> pact) {
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        return new HashCodeBuilder().append((Object)pact.getConsumer().getName()).append((Object)pact.getProvider().getName()).toHashCode();
    }

    @NotNull
    public final String lookupProviderVersion() {
        String string;
        String version = System.getProperty("pact.provider.version");
        CharSequence charSequence = version;
        if (charSequence == null || charSequence.length() == 0) {
            this.getLogger().warn((Function0)lookupProviderVersion.1.INSTANCE);
            string = "0.0.0";
        } else {
            string = version;
        }
        return string;
    }

    public final boolean allInteractionsVerified(@NotNull Pact<Interaction> pact, @NotNull Map<Integer, Boolean> results) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
            Intrinsics.checkParameterIsNotNull(results, (String)"results");
            Iterable $receiver$iv = pact.getInteractions();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Interaction it = (Interaction)element$iv;
                    boolean bl2 = false;
                    if (results.getOrDefault(INSTANCE.calculateInteractionHash(it), false).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private TestResultAccumulator() {
    }

    static {
        TestResultAccumulator testResultAccumulator;
        INSTANCE = testResultAccumulator = new TestResultAccumulator();
        testResults = new LinkedHashMap();
        verificationReporter = (VerificationReporter)DefaultVerificationReporter.INSTANCE;
    }
}

