/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.loader;

import au.com.dius.pact.model.Consumer;
import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactBrokerSource;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.model.PactSource;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.broker.PactBrokerClient;
import au.com.dius.pact.provider.junit.loader.NoPactsFoundException;
import au.com.dius.pact.provider.junit.loader.PactBroker;
import au.com.dius.pact.provider.junit.loader.PactBrokerAuth;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import au.com.dius.pact.provider.junit.sysprops.PactRunnerExpressionParser;
import au.com.dius.pact.provider.junit.sysprops.SystemPropertyResolver;
import au.com.dius.pact.provider.junit.sysprops.ValueResolver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactBrokerLoader
implements PactLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PactBrokerLoader.class);
    private static final String LATEST = "latest";
    private final String pactBrokerHost;
    private final String pactBrokerPort;
    private final String pactBrokerProtocol;
    private final List<String> pactBrokerTags;
    private boolean failIfNoPactsFound;
    private PactBrokerAuth authentication;
    private PactBrokerSource pactSource;
    private Class<? extends ValueResolver> valueResolver;

    public PactBrokerLoader(String pactBrokerHost, String pactBrokerPort, String pactBrokerProtocol) {
        this(pactBrokerHost, pactBrokerPort, pactBrokerProtocol, Collections.singletonList(LATEST));
    }

    public PactBrokerLoader(String pactBrokerHost, String pactBrokerPort, String pactBrokerProtocol, List<String> tags) {
        this.pactBrokerHost = pactBrokerHost;
        this.pactBrokerPort = pactBrokerPort;
        this.pactBrokerProtocol = pactBrokerProtocol;
        this.pactBrokerTags = tags.stream().flatMap(tag -> PactRunnerExpressionParser.parseListExpression(tag).stream()).collect(Collectors.toList());
        this.failIfNoPactsFound = true;
        this.pactSource = new PactBrokerSource(this.pactBrokerHost, this.pactBrokerPort);
    }

    public PactBrokerLoader(PactBroker pactBroker) {
        this(pactBroker.host(), pactBroker.port(), pactBroker.protocol(), Arrays.asList(pactBroker.tags()));
        this.failIfNoPactsFound = pactBroker.failIfNoPactsFound();
        this.authentication = pactBroker.authentication();
        this.valueResolver = pactBroker.valueResolver();
    }

    @Override
    public List<Pact> load(String providerName) throws IOException {
        ArrayList<Pact> pacts = new ArrayList<Pact>();
        if (this.pactBrokerTags == null || this.pactBrokerTags.isEmpty()) {
            pacts.addAll(this.loadPactsForProvider(providerName, null));
        } else {
            for (String tag : this.pactBrokerTags) {
                pacts.addAll(this.loadPactsForProvider(providerName, tag));
            }
        }
        return pacts;
    }

    @Override
    public PactSource getPactSource() {
        return this.pactSource;
    }

    private List<Pact> loadPactsForProvider(String providerName, String tag) throws IOException {
        LOGGER.debug("Loading pacts from pact broker for provider " + providerName + " and tag " + tag);
        ValueResolver resolver = new SystemPropertyResolver();
        if (this.valueResolver != null) {
            try {
                resolver = this.valueResolver.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.warn("Failed to instantiate the value resolver, using the default", (Throwable)e);
            }
        }
        String protocol = PactRunnerExpressionParser.parseExpression(this.pactBrokerProtocol, resolver);
        String host = PactRunnerExpressionParser.parseExpression(this.pactBrokerHost, resolver);
        String port = PactRunnerExpressionParser.parseExpression(this.pactBrokerPort, resolver);
        if (!port.matches("^[0-9]+")) {
            throw new IllegalArgumentException(String.format("Invalid pact broker port specified ('%s'). Please provide a valid port number or specify the system property 'pactbroker.port'.", this.pactBrokerPort));
        }
        URIBuilder uriBuilder = new URIBuilder().setScheme(protocol).setHost(PactRunnerExpressionParser.parseExpression(host, resolver)).setPort(Integer.parseInt(port));
        try {
            PactBrokerClient pactBrokerClient = this.newPactBrokerClient(uriBuilder.build());
            List consumers = StringUtils.isEmpty((CharSequence)tag) || tag.equals(LATEST) ? pactBrokerClient.fetchConsumers(providerName).stream().map(ConsumerInfo::from).collect(Collectors.toList()) : pactBrokerClient.fetchConsumersWithTag(providerName, tag).stream().map(ConsumerInfo::from).collect(Collectors.toList());
            if (this.failIfNoPactsFound && consumers.isEmpty()) {
                throw new NoPactsFoundException("No consumer pacts were found for provider '" + providerName + "' and tag '" + tag + "'. (URL " + this.getUrlForProvider(providerName, tag, pactBrokerClient) + ")");
            }
            return consumers.stream().map(consumer -> this.loadPact((ConsumerInfo)consumer, pactBrokerClient.getOptions())).collect(Collectors.toList());
        }
        catch (URISyntaxException e) {
            throw new IOException("Was not able load pacts from broker as the broker URL was invalid", e);
        }
    }

    private String getUrlForProvider(String providerName, String tag, PactBrokerClient pactBrokerClient) {
        try {
            return pactBrokerClient.getUrlForProvider(providerName, tag);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to get provider URL from the pact broker", (Throwable)e);
            return "Unknown";
        }
    }

    Pact loadPact(ConsumerInfo consumer, Map options) {
        Pact pact = PactReader.loadPact((Map)options, (Object)consumer.getPactSource());
        Map pacts = this.pactSource.getPacts();
        Consumer pactConsumer = consumer.toPactConsumer();
        List pactList = pacts.getOrDefault(pactConsumer, new ArrayList());
        pactList.add(pact);
        pacts.put(pactConsumer, pactList);
        return pact;
    }

    PactBrokerClient newPactBrokerClient(URI url) throws URISyntaxException {
        HashMap<String, List<String>> options = new HashMap<String, List<String>>();
        if (this.authentication != null && !this.authentication.scheme().equalsIgnoreCase("none")) {
            options.put("authentication", Arrays.asList(PactRunnerExpressionParser.parseExpression(this.authentication.scheme()), PactRunnerExpressionParser.parseExpression(this.authentication.username()), PactRunnerExpressionParser.parseExpression(this.authentication.password())));
        }
        return new PactBrokerClient(url.toString(), options);
    }

    public boolean isFailIfNoPactsFound() {
        return this.failIfNoPactsFound;
    }

    public void setFailIfNoPactsFound(boolean failIfNoPactsFound) {
        this.failIfNoPactsFound = failIfNoPactsFound;
    }
}

