/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.target;

import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.PactSource;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.ProviderVerifier;
import au.com.dius.pact.provider.junit.JUnitProviderTestSupport;
import au.com.dius.pact.provider.junit.VerificationReports;
import au.com.dius.pact.provider.junit.sysprops.SystemPropertyResolver;
import au.com.dius.pact.provider.junit.sysprops.ValueResolver;
import au.com.dius.pact.provider.junit.target.TestClassAwareTarget;
import au.com.dius.pact.provider.reporters.ReporterManager;
import au.com.dius.pact.provider.reporters.VerifierReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jooq.lambda.Seq;
import org.junit.runners.model.TestClass;

public abstract class BaseTarget
implements TestClassAwareTarget {
    protected TestClass testClass;
    protected Object testTarget;
    protected ValueResolver valueResolver = new SystemPropertyResolver();
    private List<BiConsumer<Boolean, ProviderVerifier>> callbacks = new ArrayList<BiConsumer<Boolean, ProviderVerifier>>();

    @Override
    public abstract void testInteraction(String var1, Interaction var2, PactSource var3);

    protected abstract ProviderInfo getProviderInfo(PactSource var1);

    protected abstract ProviderVerifier setupVerifier(Interaction var1, ProviderInfo var2, ConsumerInfo var3);

    protected void setupReporters(ProviderVerifier verifier, String name, String description) {
        String reportDirectory = "target/pact/reports";
        Object[] reports = new String[]{};
        boolean reportingEnabled = false;
        VerificationReports verificationReports = (VerificationReports)this.testClass.getAnnotation(VerificationReports.class);
        if (verificationReports != null) {
            reportingEnabled = true;
            reportDirectory = verificationReports.reportDir();
            reports = verificationReports.value();
        } else if (this.valueResolver.propertyDefined("pact.verification.reports")) {
            reportingEnabled = true;
            reportDirectory = this.valueResolver.resolveValue("pact.verification.reportDir:" + reportDirectory);
            reports = this.valueResolver.resolveValue("pact.verification.reports:").split(",");
        }
        if (reportingEnabled) {
            File reportDir = new File(reportDirectory);
            reportDir.mkdirs();
            verifier.setReporters(Seq.of((Object[])reports).filter(r -> !r.isEmpty()).map(r -> {
                VerifierReporter reporter = ReporterManager.createReporter((String)r.trim());
                reporter.setReportDir(reportDir);
                reporter.setReportFile(new File(reportDir, name + " - " + description + reporter.getExt()));
                return reporter;
            }).toList());
        }
    }

    protected AssertionError getAssertionError(Map<String, Object> mismatches) {
        return new AssertionError((Object)JUnitProviderTestSupport.generateErrorStringFromMismatches(mismatches));
    }

    @Override
    public void setTestClass(TestClass testClass, Object testTarget) {
        this.testClass = testClass;
        this.testTarget = testTarget;
    }

    public ValueResolver getValueResolver() {
        return this.valueResolver;
    }

    public void setValueResolver(ValueResolver valueResolver) {
        this.valueResolver = valueResolver;
    }

    @Override
    public void addResultCallback(BiConsumer<Boolean, ProviderVerifier> callback) {
        this.callbacks.add(callback);
    }

    protected void reportTestResult(Boolean result, ProviderVerifier verifier) {
        this.callbacks.forEach(callback -> callback.accept(result, verifier));
    }
}

