/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit;

import au.com.dius.pact.model.FilteredPact;
import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactSource;
import au.com.dius.pact.model.ProviderState;
import au.com.dius.pact.provider.ProviderVerifier;
import au.com.dius.pact.provider.ProviderVerifierKt;
import au.com.dius.pact.provider.junit.MissingStateChangeMethod;
import au.com.dius.pact.provider.junit.RunStateChanges;
import au.com.dius.pact.provider.junit.State;
import au.com.dius.pact.provider.junit.TargetRequestFilter;
import au.com.dius.pact.provider.junit.target.Target;
import au.com.dius.pact.provider.junit.target.TestClassAwareTarget;
import au.com.dius.pact.provider.junit.target.TestTarget;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.HttpRequest;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.rules.RuleMemberValidator;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractionRunner
extends Runner {
    private static final Logger LOGGER = LoggerFactory.getLogger(InteractionRunner.class);
    private final TestClass testClass;
    private final Pact<? extends Interaction> pact;
    private final PactSource pactSource;
    private final Map<Interaction, Pair<Boolean, ProviderVerifier>> results = new HashMap<Interaction, Pair<Boolean, ProviderVerifier>>();
    private final ConcurrentHashMap<Interaction, Description> childDescriptions = new ConcurrentHashMap();

    public InteractionRunner(TestClass testClass, Pact<? extends Interaction> pact, PactSource pactSource) throws InitializationError {
        this.testClass = testClass;
        this.pact = pact;
        this.pactSource = pactSource;
        this.validate();
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription((Class)this.testClass.getJavaClass());
        for (Interaction i : this.pact.getInteractions()) {
            description.addChild(this.describeChild(i));
        }
        return description;
    }

    protected Description describeChild(Interaction interaction) {
        if (!this.childDescriptions.containsKey(interaction)) {
            this.childDescriptions.put(interaction, Description.createTestDescription((Class)this.testClass.getJavaClass(), (String)(this.pact.getConsumer().getName() + " - " + interaction.getDescription())));
        }
        return this.childDescriptions.get(interaction);
    }

    protected void validate() throws InitializationError {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        InteractionRunner.validateStateChangeMethods(this.testClass, errors);
        this.validateConstructor(errors);
        this.validateTestTarget(errors);
        this.validateRules(errors);
        this.validateTargetRequestFilters(errors);
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
    }

    private static void validateStateChangeMethods(TestClass testClass, List<Throwable> errors) {
        InteractionRunner.getAnnotatedMethods(testClass, State.class).forEach(method -> {
            method.validatePublicVoid(false, errors);
            if (method.getMethod().getParameterCount() == 1 && !Map.class.isAssignableFrom(method.getMethod().getParameterTypes()[0])) {
                errors.add(new Exception("Method " + method.getName() + " should take only a single Map parameter"));
            } else if (method.getMethod().getParameterCount() > 1) {
                errors.add(new Exception("Method " + method.getName() + " should either take no parameters or a single Map parameter"));
            }
        });
    }

    private void validateTargetRequestFilters(List<Throwable> errors) {
        this.testClass.getAnnotatedMethods(TargetRequestFilter.class).forEach(method -> {
            method.validatePublicVoid(false, errors);
            if (method.getMethod().getParameterTypes().length != 1) {
                errors.add(new Exception("Method " + method.getName() + " should take only a single HttpRequest parameter"));
            } else if (!HttpRequest.class.isAssignableFrom(method.getMethod().getParameterTypes()[0])) {
                errors.add(new Exception("Method " + method.getName() + " should take only a single HttpRequest parameter"));
            }
        });
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        this.testClass.getAnnotatedMethods(annotation).forEach(method -> method.validatePublicVoidNoArg(isStatic, errors));
    }

    protected void validateConstructor(List<Throwable> errors) {
        if (!this.hasOneConstructor()) {
            errors.add(new Exception("Test class should have exactly one public constructor"));
        }
        if (!this.testClass.isANonStaticInnerClass() && this.hasOneConstructor() && this.testClass.getOnlyConstructor().getParameterTypes().length != 0) {
            errors.add(new Exception("Test class should have exactly one public zero-argument constructor"));
        }
    }

    protected boolean hasOneConstructor() {
        return this.testClass.getJavaClass().getConstructors().length == 1;
    }

    protected void validateTestTarget(List<Throwable> errors) {
        List annotatedFields = this.testClass.getAnnotatedFields(TestTarget.class);
        if (annotatedFields.size() != 1) {
            errors.add(new Exception("Test class should have exactly one field annotated with " + TestTarget.class.getName()));
        } else if (!Target.class.isAssignableFrom(((FrameworkField)annotatedFields.get(0)).getType())) {
            errors.add(new Exception("Field annotated with " + TestTarget.class.getName() + " should implement " + Target.class.getName() + " interface"));
        }
    }

    protected void validateRules(List<Throwable> errors) {
        RuleMemberValidator.RULE_VALIDATOR.validate(this.testClass, errors);
        RuleMemberValidator.RULE_METHOD_VALIDATOR.validate(this.testClass, errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        boolean allPassed = true;
        for (Interaction interaction : this.pact.getInteractions()) {
            Description description = this.describeChild(interaction);
            notifier.fireTestStarted(description);
            try {
                this.interactionBlock(interaction, this.pactSource).evaluate();
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(description, e));
                allPassed = false;
            }
            finally {
                notifier.fireTestFinished(description);
            }
        }
        boolean publishingDisabled = this.results.values().stream().anyMatch(pair -> ((ProviderVerifier)pair.getSecond()).publishingResultsDisabled());
        if (!(publishingDisabled || this.pact instanceof FilteredPact && !((FilteredPact)this.pact).isNotFiltered())) {
            this.reportVerificationResults(allPassed);
        } else if (publishingDisabled) {
            LOGGER.warn("Skipping publishing of verification results (pact.verifier.publishResults is not set to 'true')");
        } else {
            LOGGER.warn("Skipping publishing of verification results as the interactions have been filtered");
        }
    }

    public void reportVerificationResults(Boolean allPassed) {
        ProviderVerifierKt.reportVerificationResults(this.pact, (boolean)allPassed, (String)this.providerVersion());
    }

    private String providerVersion() {
        String version = System.getProperty("pact.provider.version");
        if (version != null) {
            return version;
        }
        LOGGER.warn("Set the provider version using the 'pact.provider.version' property. Defaulting to '0.0.0'");
        return "0.0.0";
    }

    protected Object createTest() throws Exception {
        return this.testClass.getOnlyConstructor().newInstance(new Object[0]);
    }

    protected Statement interactionBlock(final Interaction interaction, final PactSource source) {
        Object testInstance;
        try {
            testInstance = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return InteractionRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        final Target target = this.lookupTarget(testInstance);
        Statement statement = new Statement(){

            public void evaluate() throws Throwable {
                InteractionRunner.this.setupTargetForInteraction(target);
                target.addResultCallback((result, verifier) -> InteractionRunner.this.results.put(interaction, new Pair(result, verifier)));
                InteractionRunner.this.surrogateTestMethod();
                target.testInteraction(InteractionRunner.this.pact.getConsumer().getName(), interaction, source);
            }
        };
        statement = this.withStateChanges(interaction, testInstance, statement);
        statement = this.withBefores(interaction, testInstance, statement);
        statement = this.withRules(interaction, testInstance, statement);
        statement = this.withAfters(interaction, testInstance, statement);
        return statement;
    }

    public void surrogateTestMethod() {
    }

    protected void setupTargetForInteraction(Target target) {
    }

    protected Target lookupTarget(Object testInstance) {
        Target target = (Target)this.testClass.getAnnotatedFieldValues(testInstance, TestTarget.class, Target.class).get(0);
        if (target instanceof TestClassAwareTarget) {
            ((TestClassAwareTarget)target).setTestClass(this.testClass, testInstance);
        }
        return target;
    }

    protected Statement withStateChanges(Interaction interaction, Object target, Statement prevStatement) {
        if (!interaction.getProviderStates().isEmpty()) {
            Statement stateChange = prevStatement;
            for (ProviderState state : interaction.getProviderStates()) {
                List<Pair<FrameworkMethod, State>> methods = InteractionRunner.getAnnotatedMethods(this.testClass, State.class).stream().map(method -> {
                    State annotation = (State)method.getAnnotation(State.class);
                    return new Pair(method, (Object)annotation);
                }).filter(method -> ArrayUtils.contains((Object[])((State)method.getSecond()).value(), (Object)state.getName())).collect(Collectors.toList());
                if (methods.isEmpty()) {
                    return new Fail((Throwable)new MissingStateChangeMethod("MissingStateChangeMethod: Did not find a test class method annotated with @State(\"" + state.getName() + "\")"));
                }
                stateChange = new RunStateChanges(stateChange, methods, target, state);
            }
            return stateChange;
        }
        return prevStatement;
    }

    private static List<FrameworkMethod> getAnnotatedMethods(TestClass testClass, Class<? extends Annotation> annotation) {
        List methodsFromTestClass = testClass.getAnnotatedMethods(annotation);
        ArrayList<FrameworkMethod> allMethods = new ArrayList<FrameworkMethod>();
        allMethods.addAll(methodsFromTestClass);
        allMethods.addAll(InteractionRunner.getAnnotatedMethodsFromInterfaces(testClass, annotation));
        return allMethods;
    }

    private static List<FrameworkMethod> getAnnotatedMethodsFromInterfaces(TestClass testClass, Class<? extends Annotation> annotation) {
        Class<?>[] interfaces;
        ArrayList<FrameworkMethod> stateMethods = new ArrayList<FrameworkMethod>();
        for (Class<?> interfaceClass : interfaces = testClass.getJavaClass().getInterfaces()) {
            for (Method method : interfaceClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotation)) continue;
                stateMethods.add(new FrameworkMethod(method));
            }
        }
        return stateMethods;
    }

    protected Statement withBefores(Interaction interaction, Object target, Statement statement) {
        List befores = this.testClass.getAnnotatedMethods(Before.class);
        return befores.isEmpty() ? statement : new RunBefores(statement, befores, target);
    }

    protected Statement withAfters(Interaction interaction, Object target, Statement statement) {
        List afters = this.testClass.getAnnotatedMethods(After.class);
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, target);
    }

    protected Statement withRules(Interaction interaction, Object target, Statement statement) {
        List testRules = this.testClass.getAnnotatedMethodValues(target, Rule.class, TestRule.class);
        testRules.addAll(this.testClass.getAnnotatedFieldValues(target, Rule.class, TestRule.class));
        return testRules.isEmpty() ? statement : new RunRules(statement, (Iterable)testRules, this.describeChild(interaction));
    }
}

