/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit;

import au.com.dius.pact.model.ProviderState;
import au.com.dius.pact.provider.junit.State;
import au.com.dius.pact.provider.junit.StateChangeAction;
import java.util.List;
import kotlin.Pair;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class RunStateChanges
extends Statement {
    private final Statement next;
    private final Object target;
    private final List<Pair<FrameworkMethod, State>> methods;
    private final ProviderState providerState;

    public RunStateChanges(Statement next, List<Pair<FrameworkMethod, State>> methods, Object target, ProviderState providerState) {
        this.next = next;
        this.methods = methods;
        this.target = target;
        this.providerState = providerState;
    }

    public void evaluate() throws Throwable {
        this.invokeStateChangeMethods(StateChangeAction.SETUP);
        this.next.evaluate();
        this.invokeStateChangeMethods(StateChangeAction.TEARDOWN);
    }

    private void invokeStateChangeMethods(StateChangeAction action) throws Throwable {
        for (Pair<FrameworkMethod, State> pair : this.methods) {
            if (((State)pair.getSecond()).action() != action) continue;
            if (((FrameworkMethod)pair.getFirst()).getMethod().getParameterCount() == 1) {
                ((FrameworkMethod)pair.getFirst()).invokeExplosively(this.target, new Object[]{this.providerState.getParams()});
                continue;
            }
            ((FrameworkMethod)pair.getFirst()).invokeExplosively(this.target, new Object[0]);
        }
    }
}

