/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.loader;

import au.com.dius.pact.model.DirectorySource;
import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.model.PactSource;
import au.com.dius.pact.provider.junit.loader.PactFolder;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PactFolderLoader
implements PactLoader {
    private final File path;
    private DirectorySource pactSource;

    public PactFolderLoader(File path) {
        this.path = path;
        this.pactSource = new DirectorySource(path);
    }

    public PactFolderLoader(String path) {
        this(new File(path));
    }

    @Deprecated
    public PactFolderLoader(URL path) {
        this(path == null ? "" : path.getPath());
    }

    public PactFolderLoader(PactFolder pactFolder) {
        this(pactFolder.value());
    }

    @Override
    public List<Pact> load(String providerName) {
        ArrayList<Pact> pacts = new ArrayList<Pact>();
        File pactFolder = this.resolvePath();
        File[] files = pactFolder.listFiles((dir, name) -> name.endsWith(".json"));
        if (files != null) {
            for (File file : files) {
                Pact pact = PactReader.loadPact((Object)file);
                if (!pact.getProvider().getName().equals(providerName)) continue;
                pacts.add(pact);
                this.pactSource.getPacts().put(file, pact);
            }
        }
        return pacts;
    }

    @Override
    public PactSource getPactSource() {
        return this.pactSource;
    }

    public Map<Pact, File> loadPactsWithFiles(String providerName) throws IOException {
        return this.pactSource.getPacts().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    private File resolvePath() {
        File file = this.path;
        URL resourcePath = PactFolderLoader.class.getClassLoader().getResource(this.path.getPath());
        if (resourcePath != null) {
            file = new File(resourcePath.getPath());
        }
        return file;
    }
}

