/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.ProviderState;
import au.com.dius.pact.model.Request;
import au.com.dius.pact.provider.IHttpClientFactory;
import au.com.dius.pact.provider.IProviderInfo;
import groovy.json.JsonBuilder;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.Closeable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.commons.collections4.Closure;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scala.Function1;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J4\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010#\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010$\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006("}, d2={"Lau/com/dius/pact/provider/ProviderClient;", "", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "httpClientFactory", "Lau/com/dius/pact/provider/IHttpClientFactory;", "(Lau/com/dius/pact/provider/IProviderInfo;Lau/com/dius/pact/provider/IHttpClientFactory;)V", "getProvider", "()Lau/com/dius/pact/provider/IProviderInfo;", "executeRequestFilter", "", "method", "Lorg/apache/http/HttpRequest;", "handleResponse", "", "", "httpResponse", "Lorg/apache/http/HttpResponse;", "invokeJavaFunctionalInterface", "functionalInterface", "httpRequest", "makeRequest", "request", "Lau/com/dius/pact/model/Request;", "makeStateChangeRequest", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "stateChangeUrl", "state", "Lau/com/dius/pact/model/ProviderState;", "postStateInBody", "", "isSetup", "stateChangeTeardown", "newRequest", "Lorg/apache/http/client/methods/HttpUriRequest;", "setupBody", "setupHeaders", "systemPropertySet", "property", "Companion", "pact-jvm-provider_2.12"})
public class ProviderClient {
    @NotNull
    private final IProviderInfo provider;
    private final IHttpClientFactory httpClientFactory;
    @NotNull
    public static final String CONTENT_TYPE = "Content-Type";
    @NotNull
    public static final String UTF8 = "UTF-8";
    @NotNull
    public static final String REQUEST = "request";
    @NotNull
    public static final String ACTION = "action";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, Object> makeRequest(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        Companion.getLogger().debug((Function0)new Function0<String>(this){
            final /* synthetic */ ProviderClient this$0;

            @NotNull
            public final String invoke() {
                return "Making request for provider " + this.this$0.getProvider() + ':';
            }
            {
                this.this$0 = providerClient;
                super(0);
            }
        });
        Companion.getLogger().debug((Function0)new Function0<String>(request){
            final /* synthetic */ Request $request;

            @NotNull
            public final String invoke() {
                return this.$request.toString();
            }
            {
                this.$request = request;
                super(0);
            }
        });
        CloseableHttpClient httpclient = this.httpClientFactory.newClient(this.provider);
        HttpUriRequest method = this.newRequest(request);
        this.setupHeaders(request, (HttpRequest)method);
        this.setupBody(request, (HttpRequest)method);
        this.executeRequestFilter((HttpRequest)method);
        Closeable closeable = (Closeable)httpclient.execute(method);
        Throwable throwable = null;
        try {
            CloseableHttpResponse it;
            CloseableHttpResponse closeableHttpResponse = it = (CloseableHttpResponse)closeable;
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
            Map<String, Object> map = this.handleResponse((HttpResponse)closeableHttpResponse);
            return map;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void executeRequestFilter(@NotNull HttpRequest method) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Object requestFilter = this.provider.getRequestFilter();
        if (requestFilter != null) {
            Object object = requestFilter;
            if (object instanceof groovy.lang.Closure) {
                ((groovy.lang.Closure)requestFilter).call((Object)method);
            } else if (object instanceof Function1) {
                ((Function1)requestFilter).apply((Object)method);
            } else if (object instanceof Closure) {
                ((Closure)requestFilter).execute((Object)method);
            } else if (ProviderClient.Companion.isFunctionalInterface(requestFilter)) {
                this.invokeJavaFunctionalInterface(requestFilter, method);
            } else {
                Binding binding = new Binding();
                binding.setVariable(REQUEST, (Object)method);
                GroovyShell shell = new GroovyShell(binding);
                shell.evaluate((String)requestFilter);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void invokeJavaFunctionalInterface(Object functionalInterface, HttpRequest httpRequest) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Method[] methodArray = functionalInterface.getClass().getDeclaredMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"functionalInterface::class.java.declaredMethods");
        Object[] objectArray = $receiver$iv = (Object[])methodArray;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            Method it;
            void element$iv$iv = $receiver$iv$iv[i];
            Method method = it = (Method)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"it");
            if (!Modifier.isPublic(method.getModifiers())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List invokableMethods = (List)destination$iv$iv;
        if (invokableMethods.size() == 1) {
            Object[] params;
            Object[] objectArray2;
            Method method;
            Method method2 = method = (Method)CollectionsKt.first((List)invokableMethods);
            Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
            Object[] objectArray3 = objectArray2 = (params = new Object[method2.getParameterCount()]);
            if (!(objectArray3.length == 0)) {
                params[0] = httpRequest;
            }
            method.setAccessible(true);
            method.invoke(functionalInterface, Arrays.copyOf(params, params.length));
            return;
        }
        throw (Throwable)new IllegalArgumentException("Java request filters must be either a Consumer or Function that takes at least one HttpRequest parameter");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void setupBody(@NotNull Request request, @NotNull HttpRequest method) {
        void $receiver$iv$iv;
        Map $receiver$iv;
        block9: {
            block8: {
                Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
                Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                if (!(method instanceof HttpEntityEnclosingRequest)) return;
                if (!Companion.urlEncodedFormPost(request) || request.getQuery() == null) break block8;
                Map map = request.getQuery();
                Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"request.query");
                Map map2 = map;
                if (!map2.isEmpty()) break block9;
            }
            if (request.getBody() == null) return;
            OptionalBody optionalBody = request.getBody();
            if (optionalBody == null) {
                Intrinsics.throwNpe();
            }
            if (!optionalBody.isPresent()) return;
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)method;
            OptionalBody optionalBody2 = request.getBody();
            if (optionalBody2 == null) {
                Intrinsics.throwNpe();
            }
            httpEntityEnclosingRequest.setEntity((HttpEntity)new StringEntity(optionalBody2.orElse("")));
            return;
        }
        Charset charset = Consts.UTF_8;
        Map map = request.getQuery();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"request.query");
        Map map3 = $receiver$iv = map;
        Collection destination$iv$iv = new ArrayList();
        void var8_7 = $receiver$iv$iv;
        Iterator iterator = var8_7.entrySet().iterator();
        while (true) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            Map.Entry element$iv$iv;
            if (!iterator.hasNext()) {
                List parameters = (List)destination$iv$iv;
                ((HttpEntityEnclosingRequest)method).setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)parameters, charset));
                return;
            }
            Map.Entry entry = element$iv$iv = iterator.next();
            Object v = entry.getValue();
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"entry.value");
            Iterable iterable = $receiver$iv2 = (Iterable)v;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                BasicNameValuePair basicNameValuePair = new BasicNameValuePair((String)entry.getKey(), (String)it);
                collection.add(basicNameValuePair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
    }

    public void setupHeaders(@NotNull Request request, @NotNull HttpRequest method) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Map headers = request.getHeaders();
        if (headers != null && !(map = headers).isEmpty()) {
            headers.forEach((BiConsumer)new BiConsumer<String, String>(method){
                final /* synthetic */ HttpRequest $method;

                public final void accept(@NotNull String key, @NotNull String value) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                    this.$method.addHeader(key, value);
                }
                {
                    this.$method = httpRequest;
                }
            });
            if (!method.containsHeader(CONTENT_TYPE)) {
                method.addHeader(CONTENT_TYPE, "application/json");
            }
        }
    }

    @Nullable
    public CloseableHttpResponse makeStateChangeRequest(@Nullable Object stateChangeUrl, @NotNull ProviderState state, boolean postStateInBody, boolean isSetup, boolean stateChangeTeardown) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (stateChangeUrl != null) {
            HttpPost method;
            URIBuilder urlBuilder;
            CloseableHttpClient httpclient = this.httpClientFactory.newClient(this.provider);
            URIBuilder uRIBuilder = urlBuilder = stateChangeUrl instanceof URI ? new URIBuilder((URI)stateChangeUrl) : new URIBuilder(stateChangeUrl.toString());
            if (postStateInBody) {
                Object object;
                String string;
                method = new HttpPost(urlBuilder.build());
                Map map = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"state", (Object)state.getName())});
                Map map2 = state.getParams();
                if (!map2.isEmpty()) {
                    map2 = map;
                    string = "params";
                    object = state.getParams();
                    map2.put(string, object);
                }
                if (stateChangeTeardown) {
                    map2 = map;
                    string = ACTION;
                    object = isSetup ? "setup" : "teardown";
                    map2.put(string, object);
                }
                method.setEntity((HttpEntity)new StringEntity(new JsonBuilder((Object)map).toPrettyString(), ContentType.APPLICATION_JSON));
            } else {
                urlBuilder.setParameter("state", state.getName());
                state.getParams().forEach((BiConsumer)new BiConsumer<String, Object>(urlBuilder){
                    final /* synthetic */ URIBuilder $urlBuilder;

                    public final void accept(@NotNull String k, @NotNull Object v) {
                        Intrinsics.checkParameterIsNotNull((Object)k, (String)"k");
                        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                        this.$urlBuilder.setParameter(k, v.toString());
                    }
                    {
                        this.$urlBuilder = uRIBuilder;
                    }
                });
                if (stateChangeTeardown) {
                    if (isSetup) {
                        urlBuilder.setParameter(ACTION, "setup");
                    } else {
                        urlBuilder.setParameter(ACTION, "teardown");
                    }
                }
                method = new HttpPost(urlBuilder.build());
            }
            if (this.provider.getStateChangeRequestFilter() != null) {
                if (this.provider.getStateChangeRequestFilter() instanceof groovy.lang.Closure) {
                    Object object = this.provider.getStateChangeRequestFilter();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type groovy.lang.Closure<*>");
                    }
                    ((groovy.lang.Closure)object).call((Object)method);
                } else if (this.provider.getStateChangeRequestFilter() instanceof Function1) {
                    Object object = this.provider.getStateChangeRequestFilter();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type scala.Function1<kotlin.Any, kotlin.Any>");
                    }
                    ((Function1)object).apply((Object)method);
                } else {
                    Binding binding = new Binding();
                    binding.setVariable(REQUEST, (Object)method);
                    GroovyShell shell = new GroovyShell(binding);
                    shell.evaluate(String.valueOf(this.provider.getStateChangeRequestFilter()));
                }
            }
            return httpclient.execute((HttpUriRequest)method);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> handleResponse(HttpResponse httpResponse) {
        void $receiver$iv$iv;
        Map response;
        Companion.getLogger().debug((Function0)new Function0<String>(httpResponse){
            final /* synthetic */ HttpResponse $httpResponse;

            @NotNull
            public final String invoke() {
                return "Received response: " + this.$httpResponse.getStatusLine();
            }
            {
                this.$httpResponse = httpResponse;
                super(0);
            }
        });
        Pair[] pairArray = new Pair[1];
        StatusLine statusLine = httpResponse.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"httpResponse.statusLine");
        pairArray[0] = TuplesKt.to((Object)"statusCode", (Object)statusLine.getStatusCode());
        Map map = response = MapsKt.mutableMapOf((Pair[])pairArray);
        String string = "headers";
        Header[] headerArray = httpResponse.getAllHeaders();
        Intrinsics.checkExpressionValueIsNotNull((Object)headerArray, (String)"httpResponse.allHeaders");
        ContentType $receiver$iv = (ContentType)headerArray;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((Object[])$receiver$iv).length), (int)16);
        Object object = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            Header header;
            void element$iv$iv = $receiver$iv$iv[i];
            Map map2 = destination$iv$iv;
            Header header2 = header = (Header)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)header2, (String)"header");
            Pair pair = TuplesKt.to((Object)header2.getName(), (Object)header.getValue());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map3 = destination$iv$iv;
        map.put(string, map3);
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            ContentType contentType;
            if (entity.getContentType() != null) {
                Header header = entity.getContentType();
                Intrinsics.checkExpressionValueIsNotNull((Object)header, (String)"entity.contentType");
                contentType = ContentType.parse((String)header.getValue());
            } else {
                contentType = ContentType.APPLICATION_JSON;
            }
            ContentType contentType2 = contentType;
            map3 = response;
            String string2 = "contentType";
            ContentType contentType3 = contentType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType3, (String)"contentType");
            object = contentType3;
            map3.put(string2, object);
            map3 = response;
            string2 = "data";
            Object object2 = contentType2.getCharset();
            if (object2 == null || (object2 = ((Charset)object2).name()) == null) {
                object2 = UTF8;
            }
            String string3 = EntityUtils.toString((HttpEntity)entity, (String)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"EntityUtils.toString(ent\u2026.charset?.name() ?: UTF8)");
            object = string3;
            map3.put(string2, object);
        }
        Companion.getLogger().debug((Function0)new Function0<String>(response){
            final /* synthetic */ Map $response;

            @NotNull
            public final String invoke() {
                return "Response: " + this.$response;
            }
            {
                this.$response = map;
                super(0);
            }
        });
        return response;
    }

    @NotNull
    public HttpUriRequest newRequest(@NotNull Request request) {
        HttpUriRequest httpUriRequest;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        String scheme = this.provider.getProtocol();
        Object host = ProviderClient.Companion.invokeIfClosure(this.provider.getHost());
        int port = ProviderClient.Companion.convertToInteger(ProviderClient.Companion.invokeIfClosure(this.provider.getPort()));
        String path = ProviderClient.Companion.stripTrailingSlash(this.provider.getPath());
        URIBuilder urlBuilder = new URIBuilder();
        if (this.systemPropertySet("pact.verifier.disableUrlPathDecoding")) {
            path = path + request.getPath();
            urlBuilder = new URIBuilder("" + scheme + "://" + host + ':' + port + "" + path);
        } else {
            path = path + URLDecoder.decode(request.getPath(), UTF8);
            urlBuilder.setScheme(this.provider.getProtocol());
            Object object2 = ProviderClient.Companion.invokeIfClosure(this.provider.getHost());
            urlBuilder.setHost(object2 != null ? object2.toString() : null);
            urlBuilder.setPort(ProviderClient.Companion.convertToInteger(ProviderClient.Companion.invokeIfClosure(this.provider.getPort())));
            urlBuilder.setPath(path);
        }
        if (request.getQuery() != null && !Companion.urlEncodedFormPost(request)) {
            Map map = request.getQuery();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"request.query");
            Map $receiver$iv = map;
            Object object3 = $receiver$iv;
            object = object3.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                Object v = entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"entry.value");
                Iterable $receiver$iv2 = (Iterable)v;
                for (Object element$iv2 : $receiver$iv2) {
                    String it = (String)element$iv2;
                    urlBuilder.addParameter((String)entry.getKey(), it);
                }
            }
        }
        String url = urlBuilder.build().toString();
        String string = request.getMethod();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.method");
        object = string;
        String string2 = object;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        switch (string3) {
            case "post": {
                httpUriRequest = (HttpUriRequest)new HttpPost(url);
                break;
            }
            case "put": {
                httpUriRequest = (HttpUriRequest)new HttpPut(url);
                break;
            }
            case "options": {
                httpUriRequest = (HttpUriRequest)new HttpOptions(url);
                break;
            }
            case "delete": {
                httpUriRequest = (HttpUriRequest)new HttpDelete(url);
                break;
            }
            case "head": {
                httpUriRequest = (HttpUriRequest)new HttpHead(url);
                break;
            }
            case "patch": {
                httpUriRequest = (HttpUriRequest)new HttpPatch(url);
                break;
            }
            case "trace": {
                httpUriRequest = (HttpUriRequest)new HttpTrace(url);
                break;
            }
            default: {
                httpUriRequest = (HttpUriRequest)new HttpGet(url);
            }
        }
        return httpUriRequest;
    }

    public boolean systemPropertySet(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        return Boolean.getBoolean(property);
    }

    @NotNull
    public final IProviderInfo getProvider() {
        return this.provider;
    }

    public ProviderClient(@NotNull IProviderInfo provider, @NotNull IHttpClientFactory httpClientFactory) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)httpClientFactory, (String)"httpClientFactory");
        this.provider = provider;
        this.httpClientFactory = httpClientFactory;
    }

    @JvmStatic
    public static final boolean urlEncodedFormPost(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        return Companion.urlEncodedFormPost(request);
    }

    @JvmStatic
    private static final String stripTrailingSlash(String basePath) {
        return ProviderClient.Companion.stripTrailingSlash(basePath);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0003J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lau/com/dius/pact/provider/ProviderClient$Companion;", "Lmu/KLogging;", "()V", "ACTION", "", "CONTENT_TYPE", "REQUEST", "UTF8", "convertToInteger", "", "port", "", "invokeIfClosure", "property", "isFunctionalInterface", "", "requestFilter", "stripTrailingSlash", "basePath", "urlEncodedFormPost", "request", "Lau/com/dius/pact/model/Request;", "pact-jvm-provider_2.12"})
    public static final class Companion
    extends KLogging {
        private final Object invokeIfClosure(Object property) {
            return property instanceof groovy.lang.Closure ? ((groovy.lang.Closure)property).call() : property;
        }

        private final int convertToInteger(Object port) {
            return port instanceof Number ? ((Number)port).intValue() : Integer.parseInt(String.valueOf(port));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean urlEncodedFormPost(@NotNull Request request) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)request, (String)ProviderClient.REQUEST);
            String string2 = request.getMethod();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"request.method");
            String string3 = string = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            if (!Intrinsics.areEqual((Object)string4, (Object)"post")) return false;
            String string5 = request.mimeType();
            ContentType contentType = ContentType.APPLICATION_FORM_URLENCODED;
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType, (String)"ContentType.APPLICATION_FORM_URLENCODED");
            if (!Intrinsics.areEqual((Object)string5, (Object)contentType.getMimeType())) return false;
            return true;
        }

        private final boolean isFunctionalInterface(Object requestFilter) {
            boolean bl;
            block1: {
                Class<?>[] classArray = requestFilter.getClass().getInterfaces();
                Intrinsics.checkExpressionValueIsNotNull(classArray, (String)"requestFilter::class.java.interfaces");
                Object[] $receiver$iv = classArray;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    Class it = (Class)element$iv;
                    if (!it.isAnnotationPresent(FunctionalInterface.class)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        private final String stripTrailingSlash(String basePath) {
            String string;
            if (Intrinsics.areEqual((Object)basePath, (Object)"/")) {
                string = "";
            } else {
                CharSequence charSequence = basePath;
                if (charSequence.length() > 0 && StringsKt.last((CharSequence)basePath) == '/') {
                    charSequence = basePath;
                    int n = 0;
                    int n2 = basePath.length() - 1;
                    CharSequence charSequence2 = charSequence;
                    if (charSequence2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = ((String)charSequence2).substring(n, n2);
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = basePath;
                }
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

