/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.OptionalBodyKt;
import au.com.dius.pact.model.ProviderState;
import au.com.dius.pact.model.Request;
import au.com.dius.pact.provider.IHttpClientFactory;
import au.com.dius.pact.provider.IProviderInfo;
import groovy.json.JsonBuilder;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.Closeable;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.commons.collections4.Closure;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scala.Function1;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\rJ\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J4\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#H\u0016J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010(\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\u0018\u0010)\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006."}, d2={"Lau/com/dius/pact/provider/ProviderClient;", "", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "httpClientFactory", "Lau/com/dius/pact/provider/IHttpClientFactory;", "(Lau/com/dius/pact/provider/IProviderInfo;Lau/com/dius/pact/provider/IHttpClientFactory;)V", "getProvider", "()Lau/com/dius/pact/provider/IProviderInfo;", "executeRequest", "", "", "httpclient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "method", "Lorg/apache/http/client/methods/HttpUriRequest;", "executeRequestFilter", "", "Lorg/apache/http/HttpRequest;", "getHttpClient", "handleResponse", "httpResponse", "Lorg/apache/http/HttpResponse;", "invokeJavaFunctionalInterface", "functionalInterface", "httpRequest", "makeRequest", "request", "Lau/com/dius/pact/model/Request;", "makeStateChangeRequest", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "stateChangeUrl", "state", "Lau/com/dius/pact/model/ProviderState;", "postStateInBody", "", "isSetup", "stateChangeTeardown", "newRequest", "prepareRequest", "setupBody", "setupHeaders", "systemPropertySet", "property", "Companion", "HttpDeleteWithEntity", "pact-jvm-provider_2.12"})
public class ProviderClient {
    @NotNull
    private final IProviderInfo provider;
    private final IHttpClientFactory httpClientFactory;
    @NotNull
    public static final String CONTENT_TYPE = "Content-Type";
    @NotNull
    public static final String UTF8 = "UTF-8";
    @NotNull
    public static final String REQUEST = "request";
    @NotNull
    public static final String ACTION = "action";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Map<String, Object> makeRequest(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpUriRequest method = this.prepareRequest(request);
        return this.executeRequest(httpclient, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, Object> executeRequest(@NotNull CloseableHttpClient httpclient, @NotNull HttpUriRequest method) {
        Map<String, Object> map2;
        Intrinsics.checkParameterIsNotNull((Object)httpclient, (String)"httpclient");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Closeable closeable = (Closeable)httpclient.execute(method);
        Throwable throwable = null;
        try {
            CloseableHttpResponse it = (CloseableHttpResponse)closeable;
            boolean bl = false;
            CloseableHttpResponse closeableHttpResponse = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
            map2 = this.handleResponse((HttpResponse)closeableHttpResponse);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return map2;
    }

    @NotNull
    public HttpUriRequest prepareRequest(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        Companion.getLogger().debug((Function0)new Function0<String>(this){
            final /* synthetic */ ProviderClient this$0;

            @NotNull
            public final String invoke() {
                return "Making request for provider " + this.this$0.getProvider() + ':';
            }
            {
                this.this$0 = providerClient;
                super(0);
            }
        });
        Companion.getLogger().debug((Function0)new Function0<String>(request){
            final /* synthetic */ Request $request;

            @NotNull
            public final String invoke() {
                return this.$request.toString();
            }
            {
                this.$request = request;
                super(0);
            }
        });
        HttpUriRequest method = this.newRequest(request);
        this.setupHeaders(request, (HttpRequest)method);
        this.setupBody(request, (HttpRequest)method);
        this.executeRequestFilter((HttpRequest)method);
        return method;
    }

    public void executeRequestFilter(@NotNull HttpRequest method) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Object requestFilter = this.provider.getRequestFilter();
        if (requestFilter != null) {
            Object object = requestFilter;
            if (object instanceof groovy.lang.Closure) {
                ((groovy.lang.Closure)requestFilter).call((Object)method);
            } else if (object instanceof Function1) {
                ((Function1)requestFilter).apply((Object)method);
            } else if (object instanceof Closure) {
                ((Closure)requestFilter).execute((Object)method);
            } else if (ProviderClient.Companion.isFunctionalInterface(requestFilter)) {
                this.invokeJavaFunctionalInterface(requestFilter, method);
            } else {
                Binding binding = new Binding();
                binding.setVariable(REQUEST, (Object)method);
                GroovyShell shell = new GroovyShell(binding);
                shell.evaluate((String)requestFilter);
            }
        }
    }

    private final void invokeJavaFunctionalInterface(Object functionalInterface, HttpRequest httpRequest) {
        Object object = functionalInterface;
        if (object instanceof Consumer) {
            Object object2 = functionalInterface;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.function.Consumer<org.apache.http.HttpRequest>");
            }
            ((Consumer)object2).accept(httpRequest);
        } else if (object instanceof Function) {
            Object object3 = functionalInterface;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.function.Function<org.apache.http.HttpRequest, kotlin.Any?>");
            }
            ((Function)object3).apply(httpRequest);
        } else if (object instanceof Callable) {
            Object object4 = functionalInterface;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.concurrent.Callable<org.apache.http.HttpRequest>");
            }
            ((Callable)object4).call();
        } else {
            throw (Throwable)new IllegalArgumentException("Java request filters must be either a Consumer or Function that takes at least one HttpRequest parameter");
        }
    }

    public void setupBody(@NotNull Request request, @NotNull HttpRequest method) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (method instanceof HttpEntityEnclosingRequest && request.getBody() != null) {
            OptionalBody optionalBody = request.getBody();
            if (optionalBody == null) {
                Intrinsics.throwNpe();
            }
            if (optionalBody.isPresent()) {
                ((HttpEntityEnclosingRequest)method).setEntity((HttpEntity)new StringEntity(OptionalBodyKt.valueAsString((OptionalBody)request.getBody())));
            }
        }
    }

    public void setupHeaders(@NotNull Request request, @NotNull HttpRequest method) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Map headers = request.getHeaders();
        if (headers != null && !(map2 = headers).isEmpty()) {
            headers.forEach((BiConsumer)new BiConsumer<String, List<? extends String>>(method){
                final /* synthetic */ HttpRequest $method;

                public final void accept(@NotNull String key, @NotNull List<String> value) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    Intrinsics.checkParameterIsNotNull(value, (String)"value");
                    this.$method.addHeader(key, CollectionsKt.joinToString$default((Iterable)value, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
                }
                {
                    this.$method = httpRequest;
                }
            });
        }
        if (!method.containsHeader(CONTENT_TYPE)) {
            OptionalBody optionalBody = request.getBody();
            if (optionalBody != null) {
                if (optionalBody.isPresent()) {
                    method.addHeader(CONTENT_TYPE, "application/json");
                }
            }
        }
    }

    @Nullable
    public CloseableHttpResponse makeStateChangeRequest(@Nullable Object stateChangeUrl, @NotNull ProviderState state, boolean postStateInBody, boolean isSetup, boolean stateChangeTeardown) {
        CloseableHttpResponse closeableHttpResponse;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (stateChangeUrl != null) {
            CloseableHttpClient httpclient = this.getHttpClient();
            URIBuilder urlBuilder = stateChangeUrl instanceof URI ? new URIBuilder((URI)stateChangeUrl) : new URIBuilder(stateChangeUrl.toString());
            HttpPost method = null;
            if (postStateInBody) {
                Object object;
                String string;
                method = new HttpPost(urlBuilder.build());
                Map map2 = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"state", (Object)state.getName())});
                Map map3 = state.getParams();
                if (!map3.isEmpty()) {
                    map3 = map2;
                    string = "params";
                    object = state.getParams();
                    map3.put(string, object);
                }
                if (stateChangeTeardown) {
                    map3 = map2;
                    string = ACTION;
                    object = isSetup ? "setup" : "teardown";
                    map3.put(string, object);
                }
                method.setEntity((HttpEntity)new StringEntity(new JsonBuilder((Object)map2).toPrettyString(), ContentType.APPLICATION_JSON));
            } else {
                urlBuilder.setParameter("state", state.getName());
                state.getParams().forEach((BiConsumer)new BiConsumer<String, Object>(urlBuilder){
                    final /* synthetic */ URIBuilder $urlBuilder;

                    public final void accept(@NotNull String k, @NotNull Object v) {
                        Intrinsics.checkParameterIsNotNull((Object)k, (String)"k");
                        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                        this.$urlBuilder.setParameter(k, v.toString());
                    }
                    {
                        this.$urlBuilder = uRIBuilder;
                    }
                });
                if (stateChangeTeardown) {
                    if (isSetup) {
                        urlBuilder.setParameter(ACTION, "setup");
                    } else {
                        urlBuilder.setParameter(ACTION, "teardown");
                    }
                }
                method = new HttpPost(urlBuilder.build());
            }
            if (this.provider.getStateChangeRequestFilter() != null) {
                if (this.provider.getStateChangeRequestFilter() instanceof groovy.lang.Closure) {
                    Object object = this.provider.getStateChangeRequestFilter();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type groovy.lang.Closure<*>");
                    }
                    ((groovy.lang.Closure)object).call((Object)method);
                } else if (this.provider.getStateChangeRequestFilter() instanceof Function1) {
                    Object object = this.provider.getStateChangeRequestFilter();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type scala.Function1<kotlin.Any, kotlin.Any>");
                    }
                    ((Function1)object).apply((Object)method);
                } else {
                    Binding binding = new Binding();
                    binding.setVariable(REQUEST, (Object)method);
                    GroovyShell shell = new GroovyShell(binding);
                    shell.evaluate(String.valueOf(this.provider.getStateChangeRequestFilter()));
                }
            }
            closeableHttpResponse = httpclient.execute((HttpUriRequest)method);
        } else {
            closeableHttpResponse = null;
        }
        return closeableHttpResponse;
    }

    @NotNull
    public final CloseableHttpClient getHttpClient() {
        return this.httpClientFactory.newClient(this.provider);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> handleResponse(@NotNull HttpResponse httpResponse) {
        void $receiver$iv$iv;
        Header[] $receiver$iv;
        Map response;
        Intrinsics.checkParameterIsNotNull((Object)httpResponse, (String)"httpResponse");
        Companion.getLogger().debug((Function0)new Function0<String>(httpResponse){
            final /* synthetic */ HttpResponse $httpResponse;

            @NotNull
            public final String invoke() {
                return "Received response: " + this.$httpResponse.getStatusLine();
            }
            {
                this.$httpResponse = httpResponse;
                super(0);
            }
        });
        Pair[] pairArray = new Pair[1];
        StatusLine statusLine = httpResponse.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"httpResponse.statusLine");
        pairArray[0] = TuplesKt.to((Object)"statusCode", (Object)statusLine.getStatusCode());
        Map map2 = response = MapsKt.mutableMapOf((Pair[])pairArray);
        String string = "headers";
        Header[] headerArray = httpResponse.getAllHeaders();
        Intrinsics.checkExpressionValueIsNotNull((Object)headerArray, (String)"httpResponse.allHeaders");
        Object object = $receiver$iv = headerArray;
        Map destination$iv$iv = new LinkedHashMap();
        void var8_8 = $receiver$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            Object object2;
            void element$iv$iv;
            void header = element$iv$iv = var8_8[i];
            boolean bl = false;
            void v3 = header;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"header");
            String key$iv$iv = v3.getName();
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            header = element$iv$iv;
            List list = list$iv$iv;
            boolean bl2 = false;
            void v5 = header;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"header");
            String string2 = v5.getValue();
            list.add(string2);
        }
        Map map3 = destination$iv$iv;
        map2.put(string, map3);
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            ContentType contentType;
            if (entity.getContentType() != null) {
                Header header = entity.getContentType();
                Intrinsics.checkExpressionValueIsNotNull((Object)header, (String)"entity.contentType");
                contentType = ContentType.parse((String)header.getValue());
            } else {
                contentType = ContentType.APPLICATION_JSON;
            }
            ContentType contentType2 = contentType;
            map3 = response;
            object = "contentType";
            ContentType contentType3 = contentType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType3, (String)"contentType");
            Object object3 = contentType3;
            map3.put(object, object3);
            map3 = response;
            object = "data";
            Object object4 = contentType2.getCharset();
            if (object4 == null || (object4 = ((Charset)object4).name()) == null) {
                object4 = UTF8;
            }
            String string3 = EntityUtils.toString((HttpEntity)entity, (String)object4);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"EntityUtils.toString(ent\u2026.charset?.name() ?: UTF8)");
            object3 = string3;
            map3.put(object, object3);
        }
        Companion.getLogger().debug((Function0)new Function0<String>(response){
            final /* synthetic */ Map $response;

            @NotNull
            public final String invoke() {
                return "Response: " + this.$response;
            }
            {
                this.$response = map2;
                super(0);
            }
        });
        return response;
    }

    @NotNull
    public HttpUriRequest newRequest(@NotNull Request request) {
        HttpUriRequest httpUriRequest;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)REQUEST);
        String scheme = this.provider.getProtocol();
        Object host = ProviderClient.Companion.invokeIfClosure(this.provider.getHost());
        int port = ProviderClient.Companion.convertToInteger(ProviderClient.Companion.invokeIfClosure(this.provider.getPort()));
        String path = ProviderClient.Companion.stripTrailingSlash(this.provider.getPath());
        URIBuilder urlBuilder = new URIBuilder();
        if (this.systemPropertySet("pact.verifier.disableUrlPathDecoding")) {
            path = path + request.getPath();
            urlBuilder = new URIBuilder(scheme + "://" + host + ':' + port + path);
        } else {
            path = path + URLDecoder.decode(request.getPath(), UTF8);
            urlBuilder.setScheme(this.provider.getProtocol());
            Object object2 = ProviderClient.Companion.invokeIfClosure(this.provider.getHost());
            urlBuilder.setHost(object2 != null ? object2.toString() : null);
            urlBuilder.setPort(ProviderClient.Companion.convertToInteger(ProviderClient.Companion.invokeIfClosure(this.provider.getPort())));
            urlBuilder.setPath(path);
        }
        if (request.getQuery() != null) {
            Map map2 = request.getQuery();
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"request.query");
            Map $receiver$iv = map2;
            object = $receiver$iv;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Object v = entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"entry.value");
                Iterable $receiver$iv2 = (Iterable)v;
                for (Object element$iv2 : $receiver$iv2) {
                    String it = (String)element$iv2;
                    boolean bl2 = false;
                    urlBuilder.addParameter((String)entry.getKey(), it);
                }
            }
        }
        String string = urlBuilder.build().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"urlBuilder.build().toString()");
        String url = string;
        String string2 = request.getMethod();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"request.method");
        Object object3 = object = string2;
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)object3).toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        switch (string3) {
            case "post": {
                httpUriRequest = (HttpUriRequest)new HttpPost(url);
                break;
            }
            case "put": {
                httpUriRequest = (HttpUriRequest)new HttpPut(url);
                break;
            }
            case "options": {
                httpUriRequest = (HttpUriRequest)new HttpOptions(url);
                break;
            }
            case "delete": {
                httpUriRequest = (HttpUriRequest)new HttpDeleteWithEntity(url);
                break;
            }
            case "head": {
                httpUriRequest = (HttpUriRequest)new HttpHead(url);
                break;
            }
            case "patch": {
                httpUriRequest = (HttpUriRequest)new HttpPatch(url);
                break;
            }
            case "trace": {
                httpUriRequest = (HttpUriRequest)new HttpTrace(url);
                break;
            }
            default: {
                httpUriRequest = (HttpUriRequest)new HttpGet(url);
            }
        }
        return httpUriRequest;
    }

    public boolean systemPropertySet(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        return Boolean.getBoolean(property);
    }

    @NotNull
    public final IProviderInfo getProvider() {
        return this.provider;
    }

    public ProviderClient(@NotNull IProviderInfo provider, @NotNull IHttpClientFactory httpClientFactory) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)httpClientFactory, (String)"httpClientFactory");
        this.provider = provider;
        this.httpClientFactory = httpClientFactory;
    }

    @JvmStatic
    public static final boolean urlEncodedFormPost(@NotNull Request request) {
        return Companion.urlEncodedFormPost(request);
    }

    @JvmStatic
    private static final String stripTrailingSlash(String basePath) {
        return ProviderClient.Companion.stripTrailingSlash(basePath);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016\u00a8\u0006\u0006"}, d2={"Lau/com/dius/pact/provider/ProviderClient$HttpDeleteWithEntity;", "Lorg/apache/http/client/methods/HttpEntityEnclosingRequestBase;", "uri", "", "(Ljava/lang/String;)V", "getMethod", "pact-jvm-provider_2.12"})
    public static final class HttpDeleteWithEntity
    extends HttpEntityEnclosingRequestBase {
        @NotNull
        public String getMethod() {
            return "DELETE";
        }

        public HttpDeleteWithEntity(@NotNull String uri) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            this.setURI(URI.create(uri));
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0003J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lau/com/dius/pact/provider/ProviderClient$Companion;", "Lmu/KLogging;", "()V", "ACTION", "", "CONTENT_TYPE", "REQUEST", "UTF8", "convertToInteger", "", "port", "", "invokeIfClosure", "property", "isFunctionalInterface", "", "requestFilter", "stripTrailingSlash", "basePath", "urlEncodedFormPost", "request", "Lau/com/dius/pact/model/Request;", "pact-jvm-provider_2.12"})
    public static final class Companion
    extends KLogging {
        private final Object invokeIfClosure(Object property) {
            return property instanceof groovy.lang.Closure ? ((groovy.lang.Closure)property).call() : property;
        }

        private final int convertToInteger(Object port) {
            return port instanceof Number ? ((Number)port).intValue() : Integer.parseInt(String.valueOf(port));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean urlEncodedFormPost(@NotNull Request request) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)request, (String)ProviderClient.REQUEST);
            String string2 = request.getMethod();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"request.method");
            String string3 = string = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            if (!Intrinsics.areEqual((Object)string4, (Object)"post")) return false;
            String string5 = request.mimeType();
            ContentType contentType = ContentType.APPLICATION_FORM_URLENCODED;
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType, (String)"ContentType.APPLICATION_FORM_URLENCODED");
            if (!Intrinsics.areEqual((Object)string5, (Object)contentType.getMimeType())) return false;
            return true;
        }

        private final boolean isFunctionalInterface(Object requestFilter) {
            boolean bl;
            block1: {
                Class<?>[] $receiver$iv;
                Class<?>[] classArray = requestFilter.getClass().getInterfaces();
                Intrinsics.checkExpressionValueIsNotNull(classArray, (String)"requestFilter::class.java.interfaces");
                Class<?>[] classArray2 = $receiver$iv = classArray;
                int n = classArray2.length;
                for (int i = 0; i < n; ++i) {
                    Class<?> element$iv;
                    Class<?> it = element$iv = classArray2[i];
                    boolean bl2 = false;
                    if (!it.isAnnotationPresent(FunctionalInterface.class)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        private final String stripTrailingSlash(String basePath) {
            String string;
            if (Intrinsics.areEqual((Object)basePath, (Object)"/")) {
                string = "";
            } else {
                CharSequence charSequence = basePath;
                if (charSequence.length() > 0 && StringsKt.last((CharSequence)basePath) == '/') {
                    charSequence = basePath;
                    int n = 0;
                    int n2 = basePath.length() - 1;
                    CharSequence charSequence2 = charSequence;
                    if (charSequence2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = ((String)charSequence2).substring(n, n2);
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = basePath;
                }
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

