/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.com.github.michaelbull.result.Err;
import au.com.dius.pact.com.github.michaelbull.result.Ok;
import au.com.dius.pact.com.github.michaelbull.result.Result;
import au.com.dius.pact.com.github.michaelbull.result.UnwrapKt;
import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.ProviderState;
import au.com.dius.pact.provider.IConsumerInfo;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.IProviderVerifier;
import au.com.dius.pact.provider.ProviderClient;
import au.com.dius.pact.provider.StateChangeResult;
import au.com.dius.pact.provider.reporters.VerifierReporter;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\\\u0010\u0003\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\u0012\u00060\bj\u0002`\t0\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JL\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J0\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J.\u0010!\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\u0012\u00060\bj\u0002`\t0\u00042\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002JT\u0010$\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\u0012\u00060\bj\u0002`\t0\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a8\u0006%"}, d2={"Lau/com/dius/pact/provider/StateChange;", "Lmu/KLogging;", "()V", "executeHttpStateChangeRequest", "Lau/com/dius/pact/com/github/michaelbull/result/Result;", "", "", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "verifier", "Lau/com/dius/pact/provider/IProviderVerifier;", "stateChangeHandler", "useBody", "", "state", "Lau/com/dius/pact/model/ProviderState;", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "isSetup", "providerClient", "Lau/com/dius/pact/provider/ProviderClient;", "executeStateChange", "Lau/com/dius/pact/provider/StateChangeResult;", "consumer", "Lau/com/dius/pact/provider/IConsumerInfo;", "interaction", "Lau/com/dius/pact/model/Interaction;", "interactionMessage", "failures", "", "executeStateChangeTeardown", "", "parseJsonResponse", "entity", "Lorg/apache/http/HttpEntity;", "stateChange", "pact-jvm-provider_2.12"})
public final class StateChange
extends KLogging {
    public static final StateChange INSTANCE;

    @JvmStatic
    @NotNull
    public static final StateChangeResult executeStateChange(@NotNull IProviderVerifier verifier, @NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer, @NotNull Interaction interaction, @NotNull String interactionMessage, @NotNull Map<String, Object> failures, @NotNull ProviderClient providerClient) {
        Intrinsics.checkParameterIsNotNull((Object)verifier, (String)"verifier");
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        Intrinsics.checkParameterIsNotNull((Object)interactionMessage, (String)"interactionMessage");
        Intrinsics.checkParameterIsNotNull(failures, (String)"failures");
        Intrinsics.checkParameterIsNotNull((Object)providerClient, (String)"providerClient");
        String message = interactionMessage;
        Result stateChangeResult = (Result)new Ok((Object)MapsKt.emptyMap());
        Collection collection = interaction.getProviderStates();
        if (!collection.isEmpty()) {
            Iterator iterator = interaction.getProviderStates().iterator();
            boolean first = true;
            while (stateChangeResult instanceof Ok && iterator.hasNext()) {
                Result result;
                Result result2;
                Object object;
                Object it;
                ProviderState providerState = (ProviderState)iterator.next();
                Result<Map<String, Object>, Exception> result3 = StateChange.stateChange(verifier, providerState, provider, consumer, true, providerClient);
                INSTANCE.getLogger().debug((Function0)new Function0<String>(providerState, result3){
                    final /* synthetic */ ProviderState $providerState;
                    final /* synthetic */ Result $result;

                    @NotNull
                    public final String invoke() {
                        return "State Change: \"" + this.$providerState + "\" -> " + this.$result;
                    }
                    {
                        this.$providerState = providerState;
                        this.$result = result;
                        super(0);
                    }
                });
                Result<Map<String, Object>, Exception> $receiver$iv = result3;
                boolean $i$f$mapEither = false;
                Result<Map<String, Object>, Exception> result4 = $receiver$iv;
                if (result4 instanceof Ok) {
                    it = (Map)((Ok)$receiver$iv).getValue();
                    boolean bl = false;
                    if (first) {
                        message = message + " Given " + providerState.getName();
                        first = false;
                    } else {
                        message = message + " And " + providerState.getName();
                    }
                    Object object2 = object = MapsKt.plus((Map)((Map)UnwrapKt.unwrap((Result)stateChangeResult)), (Map)it);
                    result2 = (Result)new Ok(object2);
                } else if (result4 instanceof Err) {
                    it = (Exception)((Err)$receiver$iv).getError();
                    boolean bl = false;
                    Map<String, Object> map2 = failures;
                    String string = message;
                    String string2 = String.valueOf(((Throwable)it).getMessage());
                    map2.put(string, string2);
                    Object object3 = object = it;
                    result2 = (Result)new Err(object3);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                stateChangeResult = result = result2;
            }
        }
        return new StateChangeResult((Result<? extends Map<String, ? extends Object>, ? extends Exception>)stateChangeResult, message);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Result<Map<String, Object>, Exception> stateChange(@NotNull IProviderVerifier verifier, @NotNull ProviderState state, @NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer, boolean isSetup, @NotNull ProviderClient providerClient) {
        Intrinsics.checkParameterIsNotNull((Object)verifier, (String)"verifier");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        Intrinsics.checkParameterIsNotNull((Object)providerClient, (String)"providerClient");
        verifier.reportStateForInteraction(state.getName(), provider, consumer, isSetup);
        try {
            void stateChangeHandler;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = consumer.getStateChange();
            boolean stateChangeUsesBody = consumer.getStateChangeUsesBody();
            if (stateChangeHandler.element == null) {
                stateChangeHandler.element = provider.getStateChangeUrl();
                stateChangeUsesBody = provider.getStateChangeUsesBody();
            }
            if (stateChangeHandler.element == null || stateChangeHandler.element instanceof String && StringsKt.isBlank((CharSequence)((CharSequence)stateChangeHandler.element))) {
                Iterable $receiver$iv = verifier.getReporters();
                for (Object element$iv : $receiver$iv) {
                    VerifierReporter it = (VerifierReporter)element$iv;
                    boolean bl = false;
                    it.warnStateChangeIgnored(state.getName(), provider, consumer);
                }
                return (Result)new Ok((Object)MapsKt.emptyMap());
            }
            Boolean bl = verifier.getCheckBuildSpecificTask().apply(stateChangeHandler.element);
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"verifier.checkBuildSpeci\u2026apply(stateChangeHandler)");
            if (bl.booleanValue()) {
                INSTANCE.getLogger().debug((Function0)new Function0<String>((Ref.ObjectRef)stateChangeHandler){
                    final /* synthetic */ Ref.ObjectRef $stateChangeHandler;

                    @NotNull
                    public final String invoke() {
                        return "Invoking build specific task " + this.$stateChangeHandler.element;
                    }
                    {
                        this.$stateChangeHandler = objectRef;
                        super(0);
                    }
                });
                verifier.getExecuteBuildSpecificTask().accept(stateChangeHandler.element, state);
                return (Result)new Ok((Object)MapsKt.emptyMap());
            }
            if (stateChangeHandler.element instanceof Closure) {
                Object result = provider.getStateChangeTeardown() ? ((Closure)stateChangeHandler.element).call(new Object[]{state, isSetup ? "setup" : "teardown"}) : ((Closure)stateChangeHandler.element).call((Object)state);
                INSTANCE.getLogger().debug((Function0)new Function0<String>(result){
                    final /* synthetic */ Object $result;

                    @NotNull
                    public final String invoke() {
                        return "Invoked state change closure -> " + this.$result;
                    }
                    {
                        this.$result = object;
                        super(0);
                    }
                });
                if (!(result instanceof URL)) {
                    return (Result)new Ok((Object)(result instanceof Map ? (Map)result : MapsKt.emptyMap()));
                }
                stateChangeHandler.element = result;
            }
            return INSTANCE.executeHttpStateChangeRequest(verifier, stateChangeHandler.element, stateChangeUsesBody, state, provider, isSetup, providerClient);
        }
        catch (Exception e) {
            Iterable $receiver$iv = verifier.getReporters();
            for (Object element$iv : $receiver$iv) {
                VerifierReporter it = (VerifierReporter)element$iv;
                boolean bl = false;
                String string = state.getName();
                Boolean bl2 = verifier.getProjectHasProperty().apply("pact.showStacktrace");
                Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"verifier.projectHasPrope\u2026ase.PACT_SHOW_STACKTRACE)");
                it.stateChangeRequestFailedWithException(string, provider, consumer, isSetup, e, bl2);
            }
            return (Result)new Err((Object)e);
        }
    }

    @JvmStatic
    public static final void executeStateChangeTeardown(@NotNull IProviderVerifier verifier, @NotNull Interaction interaction, @NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer, @NotNull ProviderClient providerClient) {
        Intrinsics.checkParameterIsNotNull((Object)verifier, (String)"verifier");
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        Intrinsics.checkParameterIsNotNull((Object)providerClient, (String)"providerClient");
        Iterable $receiver$iv = interaction.getProviderStates();
        for (Object element$iv : $receiver$iv) {
            ProviderState it = (ProviderState)element$iv;
            boolean bl = false;
            StateChange.stateChange(verifier, it, provider, consumer, false, providerClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Result<Map<String, Object>, Exception> executeHttpStateChangeRequest(IProviderVerifier verifier, Object stateChangeHandler, boolean useBody, ProviderState state, IProviderInfo provider, boolean isSetup, ProviderClient providerClient) {
        Result result;
        try {
            Result result2;
            block18: {
                block17: {
                    Result result3;
                    URI uRI;
                    Object object = stateChangeHandler;
                    if (!(object instanceof URI)) {
                        object = null;
                    }
                    if ((uRI = (URI)object) == null) {
                        uRI = new URI(stateChangeHandler.toString());
                    }
                    URI url = uRI;
                    Result response = providerClient.makeStateChangeRequest(url, state, useBody, isSetup, provider.getStateChangeTeardown());
                    this.getLogger().debug((Function0)new Function0<String>(url, (CloseableHttpResponse)response){
                        final /* synthetic */ URI $url;
                        final /* synthetic */ CloseableHttpResponse $response;

                        @NotNull
                        public final String invoke() {
                            CloseableHttpResponse closeableHttpResponse = this.$response;
                            return "Invoked state change " + this.$url + " -> " + (closeableHttpResponse != null ? closeableHttpResponse.getStatusLine() : null);
                        }
                        {
                            this.$url = uRI;
                            this.$response = closeableHttpResponse;
                            super(0);
                        }
                    });
                    result2 = response;
                    if (result2 == null) break block17;
                    Closeable closeable = (Closeable)result2;
                    Throwable throwable = null;
                    try {
                        Result result4;
                        Result it = (Result)closeable;
                        boolean bl = false;
                        StatusLine statusLine = response.getStatusLine();
                        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
                        if (statusLine.getStatusCode() >= 400) {
                            Iterable $receiver$iv = verifier.getReporters();
                            for (Object element$iv : $receiver$iv) {
                                VerifierReporter it2 = (VerifierReporter)element$iv;
                                boolean bl2 = false;
                                it2.stateChangeRequestFailed(state.getName(), provider, isSetup, response.getStatusLine().toString());
                            }
                            result4 = (Result)new Err((Object)new Exception("State Change Request Failed - " + response.getStatusLine()));
                        } else {
                            result4 = INSTANCE.parseJsonResponse(response.getEntity());
                        }
                        it = result4;
                        result3 = it;
                    }
                    catch (Throwable it) {
                        throwable = it;
                        throw it;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    result2 = result3;
                    if (result3 != null) break block18;
                }
                result2 = (Result)new Ok((Object)MapsKt.emptyMap());
            }
            result = result2;
        }
        catch (URISyntaxException ex) {
            Iterable $receiver$iv = verifier.getReporters();
            for (Object element$iv : $receiver$iv) {
                VerifierReporter it = (VerifierReporter)element$iv;
                boolean bl = false;
                it.warnStateChangeIgnoredDueToInvalidUrl(state.getName(), provider, isSetup, stateChangeHandler);
            }
            result = (Result)new Ok((Object)MapsKt.emptyMap());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Result<Map<String, Object>, Exception> parseJsonResponse(HttpEntity entity) {
        Result result;
        if (entity != null) {
            ContentType contentType = ContentType.get((HttpEntity)entity);
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType, (String)"ContentType.get(entity)");
            String string = contentType.getMimeType();
            ContentType contentType2 = ContentType.APPLICATION_JSON;
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType2, (String)"ContentType.APPLICATION_JSON");
            if (Intrinsics.areEqual((Object)string, (Object)contentType2.getMimeType())) {
                String body = EntityUtils.toString((HttpEntity)entity);
                Object object = new JsonSlurper().parseText(body);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                result = (Result)new Ok((Object)((Map)object));
                return result;
            }
        }
        result = (Result)new Ok((Object)MapsKt.emptyMap());
        return result;
    }

    private StateChange() {
    }

    static {
        StateChange stateChange2;
        INSTANCE = stateChange2 = new StateChange();
    }
}

