/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.dsl.PactDslJsonBody;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.core.model.RequestResponseInteraction;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class ConsumerPactBuilder {
    private String consumerName;
    private List<RequestResponseInteraction> interactions = new ArrayList<RequestResponseInteraction>();

    public ConsumerPactBuilder(String consumer) {
        this.consumerName = consumer;
    }

    public static ConsumerPactBuilder consumer(String consumer) {
        return new ConsumerPactBuilder(consumer);
    }

    public PactDslWithProvider hasPactWith(String provider) {
        return new PactDslWithProvider(this, provider);
    }

    public static PactDslJsonBody jsonBody() {
        return new PactDslJsonBody();
    }

    public static String xmlToString(Document body) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(body);
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public List<RequestResponseInteraction> getInteractions() {
        return this.interactions;
    }
}

