/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.AbstractBaseMockServer;
import au.com.dius.pact.consumer.BaseMockServer;
import au.com.dius.pact.consumer.PactTestExecutionContext;
import au.com.dius.pact.consumer.PactTestRun;
import au.com.dius.pact.consumer.PactVerificationResult;
import au.com.dius.pact.consumer.model.MockProviderConfig;
import au.com.dius.pact.core.matchers.DefaultResponseGenerator;
import au.com.dius.pact.core.matchers.FullRequestMatch;
import au.com.dius.pact.core.matchers.PartialRequestMatch;
import au.com.dius.pact.core.matchers.RequestMatch;
import au.com.dius.pact.core.matchers.RequestMatchResult;
import au.com.dius.pact.core.matchers.RequestMatching;
import au.com.dius.pact.core.matchers.generators.ArrayContainsJsonGenerator;
import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.DefaultPactWriter;
import au.com.dius.pact.core.model.IRequest;
import au.com.dius.pact.core.model.IResponse;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.Response;
import au.com.dius.pact.core.model.SynchronousRequestResponse;
import au.com.dius.pact.core.model.generators.GeneratorTestMode;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import com.github.michaelbull.result.Result;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import mu.KLogging;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0004J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J,\u0010\u0018\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001dH\u0016J\u0012\u0010\u001e\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J1\u0010!\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u001f\u001a\u0002H\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020&H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lau/com/dius/pact/consumer/BaseMockServer;", "Lau/com/dius/pact/consumer/AbstractBaseMockServer;", "pact", "Lau/com/dius/pact/core/model/BasePact;", "config", "Lau/com/dius/pact/consumer/model/MockProviderConfig;", "(Lau/com/dius/pact/core/model/BasePact;Lau/com/dius/pact/consumer/model/MockProviderConfig;)V", "getConfig", "()Lau/com/dius/pact/consumer/model/MockProviderConfig;", "matchedRequests", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lau/com/dius/pact/core/model/IRequest;", "mismatchedRequests", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lau/com/dius/pact/consumer/PactVerificationResult;", "getPact", "()Lau/com/dius/pact/core/model/BasePact;", "requestMatcher", "Lau/com/dius/pact/core/matchers/RequestMatching;", "generatePactResponse", "Lau/com/dius/pact/core/model/IResponse;", "request", "invalidResponse", "runAndWritePact", "R", "pactVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "testFn", "Lau/com/dius/pact/consumer/PactTestRun;", "validateMockServerState", "testResult", "", "verifyResultAndWritePact", "context", "Lau/com/dius/pact/consumer/PactTestExecutionContext;", "(Ljava/lang/Object;Lau/com/dius/pact/consumer/PactTestExecutionContext;Lau/com/dius/pact/core/model/BasePact;Lau/com/dius/pact/core/model/PactSpecVersion;)Lau/com/dius/pact/consumer/PactVerificationResult;", "waitForServer", "", "Companion", "consumer"})
public abstract class BaseMockServer
extends AbstractBaseMockServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BasePact pact;
    @NotNull
    private final MockProviderConfig config;
    @NotNull
    private final ConcurrentHashMap<IRequest, List<PactVerificationResult>> mismatchedRequests;
    @NotNull
    private final ConcurrentLinkedQueue<IRequest> matchedRequests;
    @NotNull
    private final RequestMatching requestMatcher;

    public BaseMockServer(@NotNull BasePact pact, @NotNull MockProviderConfig config) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.pact = pact;
        this.config = config;
        this.mismatchedRequests = new ConcurrentHashMap();
        this.matchedRequests = new ConcurrentLinkedQueue();
        this.requestMatcher = new RequestMatching((Pact)this.pact);
    }

    @NotNull
    public final BasePact getPact() {
        return this.pact;
    }

    @NotNull
    public final MockProviderConfig getConfig() {
        return this.config;
    }

    @Override
    public void waitForServer() {
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(sslcontext).build();
        CloseableHttpClient httpclient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build())).setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(5, TimeValue.ofMilliseconds((long)500L))).build();
        HttpOptions httpOptions = new HttpOptions(this.getUrl());
        httpOptions.addHeader("X-PACT-BOOTCHECK", (Object)"true");
        httpclient.execute((ClassicHttpRequest)httpOptions).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <R> PactVerificationResult runAndWritePact(@NotNull BasePact pact, @NotNull PactSpecVersion pactVersion, @NotNull PactTestRun<R> testFn) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)pactVersion, (String)"pactVersion");
        Intrinsics.checkNotNullParameter(testFn, (String)"testFn");
        this.start();
        this.waitForServer();
        PactTestExecutionContext context = new PactTestExecutionContext(null, 1, null);
        R testResult = null;
        try {
            testResult = testFn.run(this, context);
            Thread.sleep(100L);
        }
        catch (Throwable e) {
            Companion.getLogger().debug(e, (Function0)runAndWritePact.1.INSTANCE);
            PactVerificationResult pactVerificationResult = new PactVerificationResult.Error(e, this.validateMockServerState(null));
            return pactVerificationResult;
        }
        finally {
            this.stop();
        }
        return this.verifyResultAndWritePact(testResult, context, pact, pactVersion);
    }

    @NotNull
    public final <R> PactVerificationResult verifyResultAndWritePact(R testResult, @NotNull PactTestExecutionContext context, @NotNull BasePact pact, @NotNull PactSpecVersion pactVersion) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)pactVersion, (String)"pactVersion");
        PactVerificationResult result = this.validateMockServerState(testResult);
        if (result instanceof PactVerificationResult.Ok) {
            String pactDirectory = context.getPactFolder();
            File pactFile = pact.fileForPact(pactDirectory);
            Companion.getLogger().debug((Function0)new Function0<Object>(pact, pactFile){
                final /* synthetic */ BasePact $pact;
                final /* synthetic */ File $pactFile;
                {
                    this.$pact = $pact;
                    this.$pactFile = $pactFile;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Writing pact " + this.$pact.getConsumer().getName() + " -> " + this.$pact.getProvider().getName() + " to file " + this.$pactFile;
                }
            });
            BasePact pactToWrite = pactVersion == PactSpecVersion.V4 ? (BasePact)KotlinLanguageSupportKt.unwrap((Result)pact.asV4Pact()) : pact;
            DefaultPactWriter.INSTANCE.writePact(pactFile, (Pact)pactToWrite, pactVersion);
        }
        return result;
    }

    @Override
    @NotNull
    public PactVerificationResult validateMockServerState(@Nullable Object testResult) {
        Object object = this.mismatchedRequests;
        boolean bl = false;
        if (!object.isEmpty()) {
            object = this.mismatchedRequests.values();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mismatchedRequests.values");
            return new PactVerificationResult.Mismatches(CollectionsKt.flatten((Iterable)((Iterable)object)));
        }
        List expectedRequests2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.pact.getInteractions()), (Function1)validateMockServerState.expectedRequests.1.INSTANCE), (Function1)validateMockServerState.expectedRequests.2.INSTANCE), (Function1)((Function1)new Function1<IRequest, Boolean>(this){
            final /* synthetic */ BaseMockServer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !BaseMockServer.access$getMatchedRequests$p(this.this$0).contains(it);
            }
        })));
        Collection collection = expectedRequests2;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            return new PactVerificationResult.ExpectedButNotReceived(expectedRequests2);
        }
        return new PactVerificationResult.Ok(testResult);
    }

    @NotNull
    protected final IResponse generatePactResponse(@NotNull IRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        RequestMatch matchResult = this.requestMatcher.matchInteraction(request);
        if (matchResult instanceof FullRequestMatch) {
            SynchronousRequestResponse interaction = ((FullRequestMatch)matchResult).getInteraction();
            this.matchedRequests.add(interaction.getRequest());
            Pair[] pairArray = new Pair[2];
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"href", (Object)this.getUrl()), TuplesKt.to((Object)"port", (Object)this.getPort())};
            pairArray[0] = TuplesKt.to((Object)"mockServer", (Object)MapsKt.mapOf((Pair[])pairArray2));
            pairArray[1] = TuplesKt.to((Object)"ArrayContainsJsonGenerator", (Object)ArrayContainsJsonGenerator.INSTANCE);
            return DefaultResponseGenerator.INSTANCE.generateResponse(interaction.getResponse(), MapsKt.mutableMapOf((Pair[])pairArray), GeneratorTestMode.Consumer);
        }
        if (matchResult instanceof PartialRequestMatch) {
            SynchronousRequestResponse synchronousRequestResponse = ((Interaction)CollectionsKt.first((Iterable)((PartialRequestMatch)matchResult).getProblems().keySet())).asSynchronousRequestResponse();
            Intrinsics.checkNotNull((Object)synchronousRequestResponse);
            SynchronousRequestResponse interaction = synchronousRequestResponse;
            boolean bl = false;
            this.mismatchedRequests.putIfAbsent(interaction.getRequest(), new ArrayList());
            List<PactVerificationResult> list = this.mismatchedRequests.get(interaction.getRequest());
            if (list != null) {
                Object v = ((PartialRequestMatch)matchResult).getProblems().get(interaction);
                Intrinsics.checkNotNull(v);
                list.add(new PactVerificationResult.PartialMismatch(((RequestMatchResult)v).getMismatches()));
            }
        } else {
            boolean bl = false;
            this.mismatchedRequests.putIfAbsent(request, new ArrayList());
            List<PactVerificationResult> list = this.mismatchedRequests.get(request);
            if (list != null) {
                list.add(new PactVerificationResult.UnexpectedRequest(request));
            }
        }
        return this.invalidResponse(request);
    }

    private final IResponse invalidResponse(IRequest request) {
        String body = "{ \"error\": \"Unexpected request : " + StringEscapeUtils.escapeJson((String)request.toString()) + "\" }";
        Object object = new Pair[]{TuplesKt.to((Object)"Access-Control-Allow-Origin", (Object)CollectionsKt.listOf((Object)"*")), TuplesKt.to((Object)"Content-Type", (Object)CollectionsKt.listOf((Object)"application/json")), TuplesKt.to((Object)"X-Pact-Unexpected-Request", (Object)CollectionsKt.listOf((Object)"1"))};
        Map map = MapsKt.mutableMapOf((Pair[])object);
        object = body;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = ((String)object2).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return (IResponse)new Response(500, map, OptionalBody.Companion.body(byArray, ContentType.Companion.getJSON()), null, null, 24, null);
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getMatchedRequests$p(BaseMockServer $this) {
        return $this.matchedRequests;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lau/com/dius/pact/consumer/BaseMockServer$Companion;", "Lmu/KLogging;", "()V", "consumer"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

