/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.BaseMockServer;
import au.com.dius.pact.consumer.ConsumerPactRunnerKt;
import au.com.dius.pact.consumer.MessagePactTestRun;
import au.com.dius.pact.consumer.MockHttpServerKt;
import au.com.dius.pact.consumer.PactTestExecutionContext;
import au.com.dius.pact.consumer.PactTestRun;
import au.com.dius.pact.consumer.PactVerificationResult;
import au.com.dius.pact.consumer.model.MockProviderConfig;
import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.InvalidPactException;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.messaging.MessagePact;
import au.com.dius.pact.core.support.V4PactFeaturesException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\b\u001a,\u0010\t\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\u00a8\u0006\u000f"}, d2={"runConsumerTest", "Lau/com/dius/pact/consumer/PactVerificationResult;", "R", "pact", "Lau/com/dius/pact/core/model/BasePact;", "config", "Lau/com/dius/pact/consumer/model/MockProviderConfig;", "test", "Lau/com/dius/pact/consumer/PactTestRun;", "runMessageConsumerTest", "Lau/com/dius/pact/core/model/Pact;", "pactVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "testFunc", "Lau/com/dius/pact/consumer/MessagePactTestRun;", "consumer"})
public final class ConsumerPactRunnerKt {
    @NotNull
    public static final <R> PactVerificationResult runConsumerTest(@NotNull BasePact pact, @NotNull MockProviderConfig config, @NotNull PactTestRun<R> test) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(test, (String)"test");
        List errors = pact.validateForVersion(config.getPactVersion());
        if (!((Collection)errors).isEmpty()) {
            return new PactVerificationResult.Error((Throwable)new V4PactFeaturesException("Pact specification V4 features can not be used with version " + config.getPactVersion() + " - " + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)), new PactVerificationResult.Ok(null, 1, null));
        }
        if (!pact.isRequestResponsePact()) {
            throw new InvalidPactException("Expected an HTTP Request/Response Pact");
        }
        BaseMockServer server2 = MockHttpServerKt.mockServer(pact, config);
        return server2.runAndWritePact(pact, config.getPactVersion(), test);
    }

    @NotNull
    public static final <R> PactVerificationResult runMessageConsumerTest(@NotNull Pact pact, @NotNull PactSpecVersion pactVersion, @NotNull MessagePactTestRun<R> testFunc) {
        PactVerificationResult pactVerificationResult;
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)pactVersion, (String)"pactVersion");
        Intrinsics.checkNotNullParameter(testFunc, (String)"testFunc");
        List errors = pact.validateForVersion(pactVersion);
        if (!((Collection)errors).isEmpty()) {
            return new PactVerificationResult.Error((Throwable)new V4PactFeaturesException("Pact specification V4 features can not be used with version " + pactVersion + " - " + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)), new PactVerificationResult.Ok(null, 1, null));
        }
        try {
            PactTestExecutionContext context = new PactTestExecutionContext(null, 1, null);
            MessagePact messagePact2 = (MessagePact)pact.asMessagePact().expect((Function0)runMessageConsumerTest.messagePact.1.INSTANCE);
            R result = testFunc.run(messagePact2.getMessages(), context);
            pact.write(context.getPactFolder(), pactVersion).expect((Function0)runMessageConsumerTest.1.INSTANCE);
            pactVerificationResult = new PactVerificationResult.Ok(result);
        }
        catch (Throwable e) {
            pactVerificationResult = new PactVerificationResult.Error(e, new PactVerificationResult.Ok(null, 1, null));
        }
        return pactVerificationResult;
    }

    public static /* synthetic */ PactVerificationResult runMessageConsumerTest$default(Pact pact, PactSpecVersion pactSpecVersion, MessagePactTestRun messagePactTestRun, int n, Object object) {
        if ((n & 2) != 0) {
            pactSpecVersion = PactSpecVersion.V3;
        }
        return ConsumerPactRunnerKt.runMessageConsumerTest(pact, pactSpecVersion, messagePactTestRun);
    }
}

