/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.InvalidMatcherException;
import au.com.dius.pact.consumer.dsl.BodyBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslRequestBase;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithoutPath;
import au.com.dius.pact.consumer.dsl.PactDslResponse;
import au.com.dius.pact.consumer.dsl.QuoteUtil;
import au.com.dius.pact.consumer.xml.PactXmlBuilder;
import au.com.dius.pact.core.model.Consumer;
import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.PactReaderKt;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.Provider;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.Generators;
import au.com.dius.pact.core.model.generators.ProviderStateGenerator;
import au.com.dius.pact.core.model.matchingrules.ContentTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleCategory;
import au.com.dius.pact.core.model.matchingrules.MatchingRules;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.support.Random;
import au.com.dius.pact.core.support.expressions.DataType;
import au.com.dius.pact.core.support.json.JsonValue;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.transform.TransformerException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.w3c.dom.Document;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010$\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u00d7\u0001\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u000e\u0012\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\b0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u0012\u0014\b\u0002\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001f0\u000e\u00a2\u0006\u0002\u0010 Bc\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010!\u001a\u00020\u0000\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u0012\u0014\b\u0002\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001f0\u000e\u00a2\u0006\u0002\u0010\"J\u0016\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u001fJ\u0016\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u000200J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010.\u001a\u000201J\u000e\u0010.\u001a\u00020\u00002\u0006\u00102\u001a\u000203J\u0014\u0010.\u001a\u00020\u00002\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000504J\u001c\u0010.\u001a\u00020\u00002\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u0005042\u0006\u00105\u001a\u00020\u0005J\u001c\u0010.\u001a\u00020\u00002\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u0005042\u0006\u00105\u001a\u000206J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0005J\u0016\u0010.\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005J\u0016\u0010.\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00052\u0006\u00105\u001a\u000206J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010.\u001a\u000207H\u0016J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010.\u001a\u000208J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010.\u001a\u000209J\u0018\u0010:\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u0005H\u0016J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0005J\u0016\u0010<\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005J\u0016\u0010<\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00052\u0006\u00105\u001a\u000206J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0005J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005J/\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u00052\u0006\u0010E\u001a\u00020\u00052\u0012\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050G\"\u00020\u0005\u00a2\u0006\u0002\u0010HJ\u001a\u0010C\u001a\u00020\u00002\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050IJ\"\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u00052\b\b\u0002\u0010M\u001a\u00020\u0005H\u0007J\u001a\u0010N\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u0007J\"\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u00052\b\b\u0002\u0010B\u001a\u00020\u0005H\u0007J$\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u00052\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050\bJ\u000e\u0010R\u001a\u00020\u00002\u0006\u0010R\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010S\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010T\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u0005J\u001e\u0010T\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005J\u0016\u0010W\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u0005J\u001e\u0010W\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005J\u001c\u0010X\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00052\n\b\u0002\u0010B\u001a\u0004\u0018\u00010\u0005H\u0007J\u001c\u0010Y\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00052\n\b\u0002\u0010B\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010Z\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00052\b\u0010B\u001a\u0004\u0018\u00010\u0005J\u000e\u0010[\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u0005J\u0016\u0010[\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u0005J\u001e\u0010[\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005J\u001e\u0010\\\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005J\u0006\u0010]\u001a\u00020\u0019J\u001f\u0010]\u001a\u00020\u00192\u0017\u0010^\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190_\u00a2\u0006\u0002\b`J\u0016\u0010a\u001a\u00020\u00002\u0006\u0010B\u001a\u00020b2\u0006\u00105\u001a\u00020\u0005J(\u0010c\u001a\u00020\u00002\u0006\u0010d\u001a\u00020\u00052\u0006\u0010e\u001a\u00020\u00052\b\u0010f\u001a\u0004\u0018\u00010\u00052\u0006\u0010g\u001a\u00020bR\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00020$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0012\u0010)\u001a\u00020*8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lau/com/dius/pact/consumer/dsl/PactDslRequestWithPath;", "Lau/com/dius/pact/consumer/dsl/PactDslRequestBase;", "consumerPactBuilder", "Lau/com/dius/pact/consumer/ConsumerPactBuilder;", "consumerName", "", "providerName", "state", "", "Lau/com/dius/pact/core/model/ProviderState;", "description", "path", "requestMethod", "requestHeaders", "", "query", "requestBody", "Lau/com/dius/pact/core/model/OptionalBody;", "requestMatchers", "Lau/com/dius/pact/core/model/matchingrules/MatchingRules;", "requestGenerators", "Lau/com/dius/pact/core/model/generators/Generators;", "defaultRequestValues", "Lau/com/dius/pact/consumer/dsl/PactDslRequestWithoutPath;", "defaultResponseValues", "Lau/com/dius/pact/consumer/dsl/PactDslResponse;", "comments", "", "version", "Lau/com/dius/pact/core/model/PactSpecVersion;", "additionalMetadata", "Lau/com/dius/pact/core/support/json/JsonValue;", "(Lau/com/dius/pact/consumer/ConsumerPactBuilder;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Lau/com/dius/pact/core/model/OptionalBody;Lau/com/dius/pact/core/model/matchingrules/MatchingRules;Lau/com/dius/pact/core/model/generators/Generators;Lau/com/dius/pact/consumer/dsl/PactDslRequestWithoutPath;Lau/com/dius/pact/consumer/dsl/PactDslResponse;Ljava/util/List;Lau/com/dius/pact/core/model/PactSpecVersion;Ljava/util/Map;)V", "existing", "(Lau/com/dius/pact/consumer/ConsumerPactBuilder;Lau/com/dius/pact/consumer/dsl/PactDslRequestWithPath;Ljava/lang/String;Lau/com/dius/pact/consumer/dsl/PactDslRequestWithoutPath;Lau/com/dius/pact/consumer/dsl/PactDslResponse;Ljava/util/List;Lau/com/dius/pact/core/model/PactSpecVersion;Ljava/util/Map;)V", "consumer", "Lau/com/dius/pact/core/model/Consumer;", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "provider", "Lau/com/dius/pact/core/model/Provider;", "addMetadataValue", "key", "value", "body", "builder", "Lau/com/dius/pact/consumer/dsl/BodyBuilder;", "Lau/com/dius/pact/consumer/dsl/DslPart;", "xmlBuilder", "Lau/com/dius/pact/consumer/xml/PactXmlBuilder;", "Ljava/util/function/Supplier;", "contentType", "Lorg/apache/hc/core5/http/ContentType;", "Lorg/apache/hc/client5/http/entity/mime/MultipartEntityBuilder;", "Lorg/json/JSONObject;", "Lorg/w3c/dom/Document;", "bodyMatchingContentType", "exampleContents", "bodyWithSingleQuotes", "comment", "encodedQuery", "headerFromProviderState", "name", "expression", "example", "headers", "firstHeaderName", "firstHeaderValue", "headerNameValuePairs", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lau/com/dius/pact/consumer/dsl/PactDslRequestWithPath;", "", "matchHeader", "header", "regex", "headerExample", "matchPath", "pathRegex", "matchQuery", "parameter", "method", "pathFromProviderState", "queryMatchingDate", "field", "pattern", "queryMatchingDatetime", "queryMatchingISODate", "queryMatchingISODatetime", "queryMatchingISOTime", "queryMatchingTime", "queryParameterFromProviderState", "willRespondWith", "addResponseMatchers", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withBinaryData", "", "withFileUpload", "partName", "fileName", "fileContentType", "data"})
public class PactDslRequestWithPath
extends PactDslRequestBase {
    @NotNull
    private final ConsumerPactBuilder consumerPactBuilder;
    @JvmField
    @NotNull
    public Consumer consumer;
    @JvmField
    @NotNull
    public Provider provider;
    @JvmField
    @NotNull
    public List<ProviderState> state;
    @JvmField
    @NotNull
    public String description;
    @NotNull
    private String path;
    @Nullable
    private final PactDslResponse defaultResponseValues;
    @NotNull
    private Map<String, JsonValue> additionalMetadata;

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @JvmOverloads
    public PactDslRequestWithPath(@NotNull ConsumerPactBuilder consumerPactBuilder, @NotNull String consumerName, @NotNull String providerName, @NotNull List<ProviderState> state, @NotNull String description, @NotNull String path, @NotNull String requestMethod, @NotNull Map<String, List<String>> requestHeaders, @NotNull Map<String, List<String>> query, @NotNull OptionalBody requestBody, @NotNull MatchingRules requestMatchers, @NotNull Generators requestGenerators, @Nullable PactDslRequestWithoutPath defaultRequestValues, @Nullable PactDslResponse defaultResponseValues, @NotNull List<String> comments, @NotNull PactSpecVersion version, @NotNull Map<String, JsonValue> additionalMetadata) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        Intrinsics.checkNotNullParameter((Object)consumerName, (String)"consumerName");
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)requestMatchers, (String)"requestMatchers");
        Intrinsics.checkNotNullParameter((Object)requestGenerators, (String)"requestGenerators");
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(additionalMetadata, (String)"additionalMetadata");
        super(defaultRequestValues, comments, version);
        this.path = "/";
        this.additionalMetadata = new LinkedHashMap();
        this.consumerPactBuilder = consumerPactBuilder;
        this.requestMatchers = requestMatchers;
        this.consumer = new Consumer(consumerName);
        this.provider = new Provider(providerName);
        this.state = state;
        this.description = description;
        this.path = path;
        this.requestMethod = requestMethod;
        this.requestHeaders = requestHeaders;
        this.query = query;
        this.requestBody = requestBody;
        this.requestMatchers = requestMatchers;
        this.requestGenerators = requestGenerators;
        this.defaultResponseValues = defaultResponseValues;
        this.setComments(comments);
        this.additionalMetadata = additionalMetadata;
        this.setupDefaultValues();
    }

    public /* synthetic */ PactDslRequestWithPath(ConsumerPactBuilder consumerPactBuilder, String string, String string2, List list, String string3, String string4, String string5, Map map, Map map2, OptionalBody optionalBody, MatchingRules matchingRules, Generators generators, PactDslRequestWithoutPath pactDslRequestWithoutPath, PactDslResponse pactDslResponse, List list2, PactSpecVersion pactSpecVersion, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x4000) != 0) {
            list2 = new ArrayList();
        }
        if ((n & 0x8000) != 0) {
            pactSpecVersion = PactSpecVersion.V3;
        }
        if ((n & 0x10000) != 0) {
            map3 = new LinkedHashMap();
        }
        this(consumerPactBuilder, string, string2, list, string3, string4, string5, map, map2, optionalBody, matchingRules, generators, pactDslRequestWithoutPath, pactDslResponse, list2, pactSpecVersion, map3);
    }

    @JvmOverloads
    public PactDslRequestWithPath(@NotNull ConsumerPactBuilder consumerPactBuilder, @NotNull PactDslRequestWithPath existing, @NotNull String description, @Nullable PactDslRequestWithoutPath defaultRequestValues, @Nullable PactDslResponse defaultResponseValues, @NotNull List<String> comments, @NotNull PactSpecVersion version, @NotNull Map<String, JsonValue> additionalMetadata) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(additionalMetadata, (String)"additionalMetadata");
        super(defaultRequestValues, comments, version);
        this.path = "/";
        this.additionalMetadata = new LinkedHashMap();
        this.requestMethod = "GET";
        this.consumerPactBuilder = consumerPactBuilder;
        this.consumer = existing.consumer;
        this.provider = existing.provider;
        this.state = new ArrayList();
        this.description = description;
        this.defaultResponseValues = defaultResponseValues;
        this.path = existing.path;
        this.additionalMetadata = additionalMetadata;
        this.setupDefaultValues();
    }

    public /* synthetic */ PactDslRequestWithPath(ConsumerPactBuilder consumerPactBuilder, PactDslRequestWithPath pactDslRequestWithPath, String string, PactDslRequestWithoutPath pactDslRequestWithoutPath, PactDslResponse pactDslResponse, List list, PactSpecVersion pactSpecVersion, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            list = new ArrayList();
        }
        if ((n & 0x40) != 0) {
            pactSpecVersion = PactSpecVersion.V3;
        }
        if ((n & 0x80) != 0) {
            map = new LinkedHashMap();
        }
        this(consumerPactBuilder, pactDslRequestWithPath, string, pactDslRequestWithoutPath, pactDslResponse, list, pactSpecVersion, map);
    }

    @NotNull
    public final PactDslRequestWithPath method(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.requestMethod = method;
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath headers(@NotNull String firstHeaderName, @NotNull String firstHeaderValue, String ... headerNameValuePairs) {
        Intrinsics.checkNotNullParameter((Object)firstHeaderName, (String)"firstHeaderName");
        Intrinsics.checkNotNullParameter((Object)firstHeaderValue, (String)"firstHeaderValue");
        Intrinsics.checkNotNullParameter((Object)headerNameValuePairs, (String)"headerNameValuePairs");
        if (!(headerNameValuePairs.length % 2 == 0)) {
            boolean bl = false;
            String string = "Pair key value should be provided, but there is one key without value.";
            throw new IllegalArgumentException(string.toString());
        }
        this.requestHeaders.put(firstHeaderName, CollectionsKt.listOf((Object)firstHeaderValue));
        for (int i = 0; i < headerNameValuePairs.length; i += 2) {
            this.requestHeaders.put(headerNameValuePairs[i], CollectionsKt.listOf((Object)headerNameValuePairs[i + 1]));
        }
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath headers(@NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.requestHeaders.put(key, CollectionsKt.listOf((Object)value));
        }
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath query(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.query = MapsKt.toMutableMap((Map)PactReaderKt.queryStringToMap((String)query, (boolean)false));
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath encodedQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.query = MapsKt.toMutableMap((Map)PactReaderKt.queryStringToMap((String)query, (boolean)true));
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath body(@NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        String string = body;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.requestBody = OptionalBody.Companion.body(byArray);
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath body(@NotNull String body, @NotNull String contentType) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        org.apache.hc.core5.http.ContentType contentType2 = org.apache.hc.core5.http.ContentType.parse((CharSequence)contentType);
        Intrinsics.checkNotNullExpressionValue((Object)contentType2, (String)"parse(contentType)");
        return this.body(body, contentType2);
    }

    @NotNull
    public final PactDslRequestWithPath body(@NotNull String body, @NotNull org.apache.hc.core5.http.ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Charset charset = contentType.getCharset() == null ? Charset.defaultCharset() : contentType.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset");
        byte[] byArray = body.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String string = contentType.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contentType.toString()");
        this.requestBody = OptionalBody.Companion.body(byArray, new ContentType(string));
        this.requestHeaders.put("Content-Type", CollectionsKt.listOf((Object)contentType.toString()));
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath body(@NotNull Supplier<String> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        String string = body.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body.get()");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.requestBody = OptionalBody.Companion.body(byArray);
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath body(@NotNull Supplier<String> body, @NotNull String contentType) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        org.apache.hc.core5.http.ContentType contentType2 = org.apache.hc.core5.http.ContentType.parse((CharSequence)contentType);
        Intrinsics.checkNotNullExpressionValue((Object)contentType2, (String)"parse(contentType)");
        return this.body(body, contentType2);
    }

    @NotNull
    public final PactDslRequestWithPath body(@NotNull Supplier<String> body, @NotNull org.apache.hc.core5.http.ContentType contentType) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Charset charset = contentType.getCharset() == null ? Charset.defaultCharset() : contentType.getCharset();
        String string = body.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body.get()");
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String string3 = contentType.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"contentType.toString()");
        this.requestBody = OptionalBody.Companion.body(byArray, new ContentType(string3));
        this.requestHeaders.put("Content-Type", CollectionsKt.listOf((Object)contentType.toString()));
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath bodyWithSingleQuotes(@NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        String string = QuoteUtil.convert(body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convert(body)");
        return this.body(string);
    }

    @NotNull
    public final PactDslRequestWithPath bodyWithSingleQuotes(@NotNull String body, @NotNull String contentType) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        String string = QuoteUtil.convert(body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convert(body)");
        return this.body(string, contentType);
    }

    @NotNull
    public final PactDslRequestWithPath bodyWithSingleQuotes(@NotNull String body, @NotNull org.apache.hc.core5.http.ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        String string = QuoteUtil.convert(body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convert(body)");
        return this.body(string, contentType);
    }

    @NotNull
    public final PactDslRequestWithPath body(@NotNull JSONObject body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        String string = body.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body.toString()");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.requestBody = OptionalBody.Companion.body(byArray, ContentType.Companion.getJSON());
        if (this.isContentTypeHeaderNotSet()) {
            this.requestHeaders.put("Content-Type", CollectionsKt.listOf((Object)org.apache.hc.core5.http.ContentType.APPLICATION_JSON.toString()));
            String string3 = body.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"body.toString()");
            string2 = string3;
            byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            this.requestBody = OptionalBody.Companion.body(byArray2);
        } else {
            org.apache.hc.core5.http.ContentType contentType = org.apache.hc.core5.http.ContentType.parse((CharSequence)this.getContentTypeHeader());
            Charset charset = contentType.getCharset() != null ? contentType.getCharset() : Charset.defaultCharset();
            String string4 = body.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"body.toString()");
            String string5 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset");
            byte[] byArray3 = string5.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
            String string6 = contentType.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"contentType.toString()");
            this.requestBody = OptionalBody.Companion.body(byArray3, new ContentType(string6));
        }
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath body(@NotNull DslPart body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        DslPart dslPart = body.close();
        Intrinsics.checkNotNull((Object)dslPart);
        DslPart parent = dslPart;
        this.requestMatchers.addCategory(parent.getMatchers());
        Generators.addGenerators$default((Generators)this.requestGenerators, (Generators)parent.getGenerators(), null, (int)2, null);
        Charset charset = Charset.defaultCharset();
        String string = org.apache.hc.core5.http.ContentType.APPLICATION_JSON.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"APPLICATION_JSON.toString()");
        String contentType = string;
        if (this.isContentTypeHeaderNotSet()) {
            this.requestHeaders.put("Content-Type", CollectionsKt.listOf((Object)contentType));
        } else {
            contentType = this.getContentTypeHeader();
            org.apache.hc.core5.http.ContentType ct = org.apache.hc.core5.http.ContentType.parse((CharSequence)contentType);
            charset = ct.getCharset() != null ? ct.getCharset() : Charset.defaultCharset();
        }
        String string2 = parent.toString();
        Charset charset2 = charset;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"charset");
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.requestBody = OptionalBody.Companion.body(byArray, new ContentType(contentType));
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath body(@NotNull Document body) throws TransformerException {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        if (this.isContentTypeHeaderNotSet()) {
            String string = org.apache.hc.core5.http.ContentType.APPLICATION_XML.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"APPLICATION_XML.toString()");
            String contentType = string;
            this.requestHeaders.put("Content-Type", CollectionsKt.listOf((Object)contentType));
            String string2 = ConsumerPactBuilder.Companion.xmlToString(body);
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            this.requestBody = OptionalBody.Companion.body(byArray, new ContentType(contentType));
        } else {
            String contentType = this.getContentTypeHeader();
            org.apache.hc.core5.http.ContentType ct = org.apache.hc.core5.http.ContentType.parse((CharSequence)contentType);
            Charset charset = ct.getCharset() != null ? ct.getCharset() : Charset.defaultCharset();
            String string = ConsumerPactBuilder.Companion.xmlToString(body);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            this.requestBody = OptionalBody.Companion.body(byArray, new ContentType(contentType));
        }
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath body(@NotNull PactXmlBuilder xmlBuilder) {
        Intrinsics.checkNotNullParameter((Object)xmlBuilder, (String)"xmlBuilder");
        this.requestMatchers.addCategory(xmlBuilder.getMatchingRules());
        Generators.addGenerators$default((Generators)this.requestGenerators, (Generators)xmlBuilder.getGenerators(), null, (int)2, null);
        if (this.isContentTypeHeaderNotSet()) {
            this.requestHeaders.put("Content-Type", CollectionsKt.listOf((Object)org.apache.hc.core5.http.ContentType.APPLICATION_XML.toString()));
            this.requestBody = OptionalBody.Companion.body(PactXmlBuilder.asBytes$default(xmlBuilder, null, 1, null));
        } else {
            String contentType = this.getContentTypeHeader();
            org.apache.hc.core5.http.ContentType ct = org.apache.hc.core5.http.ContentType.parse((CharSequence)contentType);
            Charset charset = ct.getCharset() != null ? ct.getCharset() : Charset.defaultCharset();
            this.requestBody = OptionalBody.Companion.body(xmlBuilder.asBytes(charset), new ContentType(contentType));
        }
        return this;
    }

    @NotNull
    public PactDslRequestWithPath body(@NotNull MultipartEntityBuilder body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.setupMultipart(body);
        return this;
    }

    @Override
    @NotNull
    public PactDslRequestWithPath bodyMatchingContentType(@NotNull String contentType, @NotNull String exampleContents) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)exampleContents, (String)"exampleContents");
        PactDslRequestBase pactDslRequestBase = super.bodyMatchingContentType(contentType, exampleContents);
        Intrinsics.checkNotNull((Object)pactDslRequestBase, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.PactDslRequestWithPath");
        return (PactDslRequestWithPath)pactDslRequestBase;
    }

    @NotNull
    public final PactDslRequestWithPath withBinaryData(@NotNull byte[] example, @NotNull String contentType) {
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.requestBody = OptionalBody.Companion.body(example, ContentType.Companion.fromString(contentType));
        this.requestHeaders.put("Content-Type", CollectionsKt.listOf((Object)contentType));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.requestMatchers.addCategory("body"), (String)"$", (MatchingRule)((MatchingRule)new ContentTypeMatcher(contentType)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath path(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        return this;
    }

    @JvmOverloads
    @NotNull
    public final PactDslRequestWithPath matchPath(@NotNull String pathRegex, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)pathRegex, (String)"pathRegex");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Regex re = new Regex(pathRegex);
        if (!re.matches((CharSequence)path)) {
            throw new InvalidMatcherException("Example \"" + path + "\" does not match regular expression \"" + pathRegex + "\"");
        }
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.requestMatchers.addCategory("path"), (MatchingRule)((MatchingRule)new RegexMatcher(pathRegex, null, 2, null)), null, (int)2, null);
        this.path = path;
        return this;
    }

    public static /* synthetic */ PactDslRequestWithPath matchPath$default(PactDslRequestWithPath pactDslRequestWithPath, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: matchPath");
        }
        if ((n & 2) != 0) {
            string2 = Random.generateRandomString((String)string);
        }
        return pactDslRequestWithPath.matchPath(string, string2);
    }

    @JvmOverloads
    @NotNull
    public final PactDslRequestWithPath matchHeader(@NotNull String header, @NotNull String regex, @NotNull String headerExample) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)headerExample, (String)"headerExample");
        Regex re = new Regex(regex);
        if (!re.matches((CharSequence)headerExample)) {
            throw new InvalidMatcherException("Example \"" + headerExample + "\" does not match regular expression \"" + regex + "\"");
        }
        MatchingRuleCategory.setRule$default((MatchingRuleCategory)this.requestMatchers.addCategory("header"), (String)header, (MatchingRule)((MatchingRule)new RegexMatcher(regex, null, 2, null)), null, (int)4, null);
        this.requestHeaders.put(header, CollectionsKt.listOf((Object)headerExample));
        return this;
    }

    public static /* synthetic */ PactDslRequestWithPath matchHeader$default(PactDslRequestWithPath pactDslRequestWithPath, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: matchHeader");
        }
        if ((n & 4) != 0) {
            string3 = Random.generateRandomString((String)string2);
        }
        return pactDslRequestWithPath.matchHeader(string, string2, string3);
    }

    @NotNull
    public final PactDslResponse willRespondWith() {
        return new PactDslResponse(this.consumerPactBuilder, this, this.getDefaultRequestValues(), this.defaultResponseValues, this.getComments(), this.getVersion(), this.additionalMetadata);
    }

    @NotNull
    public final PactDslResponse willRespondWith(@NotNull Function1<? super PactDslResponse, ? extends PactDslResponse> addResponseMatchers) {
        Intrinsics.checkNotNullParameter(addResponseMatchers, (String)"addResponseMatchers");
        return (PactDslResponse)addResponseMatchers.invoke((Object)this.willRespondWith());
    }

    @JvmOverloads
    @NotNull
    public final PactDslRequestWithPath matchQuery(@NotNull String parameter, @NotNull String regex, @NotNull String example) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        Regex re = new Regex(regex);
        if (!re.matches((CharSequence)example)) {
            throw new InvalidMatcherException("Example \"" + example + "\" does not match regular expression \"" + regex + "\"");
        }
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.requestMatchers.addCategory("query"), (String)parameter, (MatchingRule)((MatchingRule)new RegexMatcher(regex, null, 2, null)), null, (int)4, null);
        this.query.put(parameter, CollectionsKt.listOf((Object)example));
        return this;
    }

    public static /* synthetic */ PactDslRequestWithPath matchQuery$default(PactDslRequestWithPath pactDslRequestWithPath, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: matchQuery");
        }
        if ((n & 4) != 0) {
            string3 = Random.generateRandomString((String)string2);
        }
        return pactDslRequestWithPath.matchQuery(string, string2, string3);
    }

    @NotNull
    public final PactDslRequestWithPath matchQuery(@NotNull String parameter, @NotNull String regex, @NotNull List<String> example) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter(example, (String)"example");
        Regex re = new Regex(regex);
        for (String e : example) {
            if (re.matches((CharSequence)e)) continue;
            throw new InvalidMatcherException("Example \"" + e + "\" does not match regular expression \"" + regex + "\"");
        }
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.requestMatchers.addCategory("query"), (String)parameter, (MatchingRule)((MatchingRule)new RegexMatcher(regex, null, 2, null)), null, (int)4, null);
        this.query.put(parameter, example);
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath withFileUpload(@NotNull String partName, @NotNull String fileName, @Nullable String fileContentType, @NotNull byte[] data) throws IOException {
        Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.setupFileUpload(partName, fileName, fileContentType, data);
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath headerFromProviderState(@NotNull String name, @NotNull String expression, @NotNull String example) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        this.requestGenerators.addGenerator(Category.HEADER, name, (Generator)new ProviderStateGenerator(expression, DataType.STRING));
        this.requestHeaders.put(name, CollectionsKt.listOf((Object)example));
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath queryParameterFromProviderState(@NotNull String name, @NotNull String expression, @NotNull String example) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        this.requestGenerators.addGenerator(Category.QUERY, name, (Generator)new ProviderStateGenerator(expression, DataType.STRING));
        this.query.put(name, CollectionsKt.listOf((Object)example));
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath pathFromProviderState(@NotNull String expression, @NotNull String example) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        this.requestGenerators.addGenerator(Category.PATH, "", (Generator)new ProviderStateGenerator(expression, DataType.STRING));
        this.path = example;
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath queryMatchingDate(@NotNull String field, @NotNull String pattern, @NotNull String example) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        PactDslRequestBase pactDslRequestBase = this.queryMatchingDateBase(field, pattern, example);
        Intrinsics.checkNotNull((Object)pactDslRequestBase, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.PactDslRequestWithPath");
        return (PactDslRequestWithPath)pactDslRequestBase;
    }

    @NotNull
    public final PactDslRequestWithPath queryMatchingDate(@NotNull String field, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        PactDslRequestBase pactDslRequestBase = this.queryMatchingDateBase(field, pattern, null);
        Intrinsics.checkNotNull((Object)pactDslRequestBase, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.PactDslRequestWithPath");
        return (PactDslRequestWithPath)pactDslRequestBase;
    }

    @NotNull
    public final PactDslRequestWithPath queryMatchingTime(@NotNull String field, @NotNull String pattern, @NotNull String example) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        PactDslRequestBase pactDslRequestBase = this.queryMatchingTimeBase(field, pattern, example);
        Intrinsics.checkNotNull((Object)pactDslRequestBase, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.PactDslRequestWithPath");
        return (PactDslRequestWithPath)pactDslRequestBase;
    }

    @NotNull
    public final PactDslRequestWithPath queryMatchingTime(@NotNull String field, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        PactDslRequestBase pactDslRequestBase = this.queryMatchingTimeBase(field, pattern, null);
        Intrinsics.checkNotNull((Object)pactDslRequestBase, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.PactDslRequestWithPath");
        return (PactDslRequestWithPath)pactDslRequestBase;
    }

    @NotNull
    public final PactDslRequestWithPath queryMatchingDatetime(@NotNull String field, @NotNull String pattern, @NotNull String example) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        PactDslRequestBase pactDslRequestBase = this.queryMatchingDatetimeBase(field, pattern, example);
        Intrinsics.checkNotNull((Object)pactDslRequestBase, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.PactDslRequestWithPath");
        return (PactDslRequestWithPath)pactDslRequestBase;
    }

    @NotNull
    public final PactDslRequestWithPath queryMatchingDatetime(@NotNull String field, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        PactDslRequestBase pactDslRequestBase = this.queryMatchingDatetimeBase(field, pattern, null);
        Intrinsics.checkNotNull((Object)pactDslRequestBase, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.PactDslRequestWithPath");
        return (PactDslRequestWithPath)pactDslRequestBase;
    }

    @JvmOverloads
    @NotNull
    public final PactDslRequestWithPath queryMatchingISODate(@NotNull String field, @Nullable String example) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        PactDslRequestBase pactDslRequestBase = this.queryMatchingDateBase(field, DateFormatUtils.ISO_DATE_FORMAT.getPattern(), example);
        Intrinsics.checkNotNull((Object)pactDslRequestBase, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.PactDslRequestWithPath");
        return (PactDslRequestWithPath)pactDslRequestBase;
    }

    public static /* synthetic */ PactDslRequestWithPath queryMatchingISODate$default(PactDslRequestWithPath pactDslRequestWithPath, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: queryMatchingISODate");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return pactDslRequestWithPath.queryMatchingISODate(string, string2);
    }

    @NotNull
    public final PactDslRequestWithPath queryMatchingISOTime(@NotNull String field, @Nullable String example) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        PactDslRequestBase pactDslRequestBase = this.queryMatchingTimeBase(field, DateFormatUtils.ISO_TIME_NO_T_FORMAT.getPattern(), example);
        Intrinsics.checkNotNull((Object)pactDslRequestBase, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.PactDslRequestWithPath");
        return (PactDslRequestWithPath)pactDslRequestBase;
    }

    @NotNull
    public final PactDslRequestWithPath queryMatchingTime(@NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.queryMatchingISOTime(field, null);
    }

    @JvmOverloads
    @NotNull
    public final PactDslRequestWithPath queryMatchingISODatetime(@NotNull String field, @Nullable String example) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        PactDslRequestBase pactDslRequestBase = this.queryMatchingDatetimeBase(field, "yyyy-MM-dd'T'HH:mm:ssXXX", example);
        Intrinsics.checkNotNull((Object)pactDslRequestBase, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.PactDslRequestWithPath");
        return (PactDslRequestWithPath)pactDslRequestBase;
    }

    public static /* synthetic */ PactDslRequestWithPath queryMatchingISODatetime$default(PactDslRequestWithPath pactDslRequestWithPath, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: queryMatchingISODatetime");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return pactDslRequestWithPath.queryMatchingISODatetime(string, string2);
    }

    @NotNull
    public final PactDslRequestWithPath body(@NotNull BodyBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        MatchingRuleCategory matchingRuleCategory = builder.getMatchers();
        Intrinsics.checkNotNullExpressionValue((Object)matchingRuleCategory, (String)"builder.matchers");
        this.requestMatchers.addCategory(matchingRuleCategory);
        MatchingRuleCategory headerMatchers = builder.getHeaderMatchers();
        if (headerMatchers != null) {
            this.requestMatchers.addCategory(headerMatchers);
        }
        Generators generators = builder.getGenerators();
        Intrinsics.checkNotNullExpressionValue((Object)generators, (String)"builder.generators");
        Generators.addGenerators$default((Generators)this.requestGenerators, (Generators)generators, null, (int)2, null);
        ContentType contentType = builder.getContentType();
        this.requestHeaders.put("Content-Type", CollectionsKt.listOf((Object)contentType.toString()));
        byte[] byArray = builder.buildBody();
        Intrinsics.checkNotNullExpressionValue((Object)contentType, (String)"contentType");
        this.requestBody = OptionalBody.Companion.body(byArray, contentType);
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath comment(@NotNull String comment2) {
        Intrinsics.checkNotNullParameter((Object)comment2, (String)"comment");
        this.getComments().add(comment2);
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath addMetadataValue(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.additionalMetadata.put(key, (JsonValue)new JsonValue.StringValue(value));
        return this;
    }

    @NotNull
    public final PactDslRequestWithPath addMetadataValue(@NotNull String key, @NotNull JsonValue value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.additionalMetadata.put(key, value);
        return this;
    }

    @JvmOverloads
    public PactDslRequestWithPath(@NotNull ConsumerPactBuilder consumerPactBuilder, @NotNull String consumerName, @NotNull String providerName, @NotNull List<ProviderState> state, @NotNull String description, @NotNull String path, @NotNull String requestMethod, @NotNull Map<String, List<String>> requestHeaders, @NotNull Map<String, List<String>> query, @NotNull OptionalBody requestBody, @NotNull MatchingRules requestMatchers, @NotNull Generators requestGenerators, @Nullable PactDslRequestWithoutPath defaultRequestValues, @Nullable PactDslResponse defaultResponseValues, @NotNull List<String> comments, @NotNull PactSpecVersion version) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        Intrinsics.checkNotNullParameter((Object)consumerName, (String)"consumerName");
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)requestMatchers, (String)"requestMatchers");
        Intrinsics.checkNotNullParameter((Object)requestGenerators, (String)"requestGenerators");
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this(consumerPactBuilder, consumerName, providerName, state, description, path, requestMethod, requestHeaders, query, requestBody, requestMatchers, requestGenerators, defaultRequestValues, defaultResponseValues, comments, version, null, 65536, null);
    }

    @JvmOverloads
    public PactDslRequestWithPath(@NotNull ConsumerPactBuilder consumerPactBuilder, @NotNull String consumerName, @NotNull String providerName, @NotNull List<ProviderState> state, @NotNull String description, @NotNull String path, @NotNull String requestMethod, @NotNull Map<String, List<String>> requestHeaders, @NotNull Map<String, List<String>> query, @NotNull OptionalBody requestBody, @NotNull MatchingRules requestMatchers, @NotNull Generators requestGenerators, @Nullable PactDslRequestWithoutPath defaultRequestValues, @Nullable PactDslResponse defaultResponseValues, @NotNull List<String> comments) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        Intrinsics.checkNotNullParameter((Object)consumerName, (String)"consumerName");
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)requestMatchers, (String)"requestMatchers");
        Intrinsics.checkNotNullParameter((Object)requestGenerators, (String)"requestGenerators");
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        this(consumerPactBuilder, consumerName, providerName, state, description, path, requestMethod, requestHeaders, query, requestBody, requestMatchers, requestGenerators, defaultRequestValues, defaultResponseValues, comments, null, null, 98304, null);
    }

    @JvmOverloads
    public PactDslRequestWithPath(@NotNull ConsumerPactBuilder consumerPactBuilder, @NotNull String consumerName, @NotNull String providerName, @NotNull List<ProviderState> state, @NotNull String description, @NotNull String path, @NotNull String requestMethod, @NotNull Map<String, List<String>> requestHeaders, @NotNull Map<String, List<String>> query, @NotNull OptionalBody requestBody, @NotNull MatchingRules requestMatchers, @NotNull Generators requestGenerators, @Nullable PactDslRequestWithoutPath defaultRequestValues, @Nullable PactDslResponse defaultResponseValues) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        Intrinsics.checkNotNullParameter((Object)consumerName, (String)"consumerName");
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)requestMatchers, (String)"requestMatchers");
        Intrinsics.checkNotNullParameter((Object)requestGenerators, (String)"requestGenerators");
        this(consumerPactBuilder, consumerName, providerName, state, description, path, requestMethod, requestHeaders, query, requestBody, requestMatchers, requestGenerators, defaultRequestValues, defaultResponseValues, null, null, null, 114688, null);
    }

    @JvmOverloads
    public PactDslRequestWithPath(@NotNull ConsumerPactBuilder consumerPactBuilder, @NotNull PactDslRequestWithPath existing, @NotNull String description, @Nullable PactDslRequestWithoutPath defaultRequestValues, @Nullable PactDslResponse defaultResponseValues, @NotNull List<String> comments, @NotNull PactSpecVersion version) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this(consumerPactBuilder, existing, description, defaultRequestValues, defaultResponseValues, comments, version, null, 128, null);
    }

    @JvmOverloads
    public PactDslRequestWithPath(@NotNull ConsumerPactBuilder consumerPactBuilder, @NotNull PactDslRequestWithPath existing, @NotNull String description, @Nullable PactDslRequestWithoutPath defaultRequestValues, @Nullable PactDslResponse defaultResponseValues, @NotNull List<String> comments) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        this(consumerPactBuilder, existing, description, defaultRequestValues, defaultResponseValues, comments, null, null, 192, null);
    }

    @JvmOverloads
    public PactDslRequestWithPath(@NotNull ConsumerPactBuilder consumerPactBuilder, @NotNull PactDslRequestWithPath existing, @NotNull String description, @Nullable PactDslRequestWithoutPath defaultRequestValues, @Nullable PactDslResponse defaultResponseValues) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this(consumerPactBuilder, existing, description, defaultRequestValues, defaultResponseValues, null, null, null, 224, null);
    }

    @JvmOverloads
    @NotNull
    public final PactDslRequestWithPath matchPath(@NotNull String pathRegex) {
        Intrinsics.checkNotNullParameter((Object)pathRegex, (String)"pathRegex");
        return PactDslRequestWithPath.matchPath$default(this, pathRegex, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final PactDslRequestWithPath matchHeader(@NotNull String header, @NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return PactDslRequestWithPath.matchHeader$default(this, header, regex, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final PactDslRequestWithPath matchQuery(@NotNull String parameter, @NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return PactDslRequestWithPath.matchQuery$default(this, parameter, regex, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final PactDslRequestWithPath queryMatchingISODate(@NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return PactDslRequestWithPath.queryMatchingISODate$default(this, field, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final PactDslRequestWithPath queryMatchingISODatetime(@NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return PactDslRequestWithPath.queryMatchingISODatetime$default(this, field, null, 2, null);
    }
}

